@extends("vendor.layouts.app")

@section("container")
    <div class="bg-white max-w-screen-xl mx-auto mt-4 shadow px-5 p-3">
        <h1 class="text-xl text-blue-700 font-semibold">Add Site</h1>
    </div>

    <div class="bg-white mx-auto max-w-screen-xl">
        <div class="px-4 pb-4">
            <nav aria-label="Progress">
                <ol class="border border-gray-300 rounded-md divide-y divide-gray-300 md:flex md:divide-y-0">

                    @if($step == "step1")
                        @include("harman.site._active_nav",["title"=>"Personal Information","link"=>route("vendor.site_create",["type"=>"step1"]),"num"=>"01"])
                        @include("harman.site._inactive_nav",["title"=>"Domain Information","link"=>route("vendor.site_create",["type"=>"step2"]),"num"=>'02'])
                        @include("harman.site._inactive_nav",["title"=>"Link Information","link"=>route("vendor.site_create",["type"=>"step3"]),"num"=>'03'])
                        @include("harman.site._last_nav",["title"=>"Seo Metrics","link"=>route("vendor.site_create",["type"=>"step4"]),"num"=>'04'])
                    @endif


                    @if($step == "step2")
                        @include("harman.site._completed_nav",["title"=>"Personal Information","link"=>route("vendor.site_create",["type"=>"step1"])])
                        @include("harman.site._active_nav",["title"=>"Domain Information","link"=>route("vendor.site_create",["type"=>"step2"]),"num"=>'02'])
                        @include("harman.site._inactive_nav",["title"=>"Link Information","link"=>route("vendor.site_create",["type"=>"step3"]),"num"=>'03'])
                        @include("harman.site._last_nav",["title"=>"Seo Metrics","link"=>route("vendor.site_create",["type"=>"step4"]),"num"=>'04'])
                    @endif

                    @if($step == "step3")*
                        @include("harman.site._completed_nav",["title"=>"Personal Information","link"=>route("vendor.site_create",["type"=>"step1"])])
                        @include("harman.site._completed_nav",["title"=>"Domain Information","link"=>route("vendor.site_create",["type"=>"step2"])])
                        @include("harman.site._active_nav",["title"=>"Link Information","link"=>route("vendor.site_create",["type"=>"step3"]),"num"=>'03'])
                        @include("harman.site._last_nav",["title"=>"Seo Metrics","link"=>route("vendor.site_create",["type"=>"step4"]),"num"=>'04'])
                    @endif


                    @if($step == "step4")
                        @include("harman.site._completed_nav",["title"=>"Personal Information","link"=>route("vendor.site_create",["type"=>"step1"])])
                        @include("harman.site._completed_nav",["title"=>"Domain Information","link"=>route("vendor.site_create",["type"=>"step2"])])
                        @include("harman.site._completed_nav",["title"=>"Link Information","link"=>route("vendor.site_create",["type"=>"step3"])])
                        @include("harman.site._last_nav_active",["title"=>"Seo Metrics","link"=>route("vendor.site_create",["type"=>"step4"]),"num"=>'04'])
                    @endif


                </ol>
            </nav>
        </div>


        <div class="p-4 mt-4">
            @if($step == 'step1')
                <form action="{{ route("vendor.site_create") }}" method="POST" >
                    <input type="hidden" name="id" value="{{ $code }}">
                    @csrf
                    <div class="grid grid-cols-2 gap-6">
                        <div>
                            <div class="flex items-center">
                                <label class="label-h-class w-2/5 text-right pr-8">Name</label>
                                <input type="text" autofocus class="textbox-class focus:ring-blue-500 focus:border-blue-500" name="name" value="{{ auth()->user()->name }}">
                            </div>
                            @error('name')
                            <div class="text-right mt-1 text-red-400 text-xs">{{ $message }}</div>
                            @enderror
                        </div>
                        <div>

                            <div class="flex items-center">
                                <label class="label-h-class w-2/5 text-right pr-8">Email</label>
                                <input type="text" class="textbox-class focus:ring-blue-500 focus:border-blue-500" name="email" value="{{ auth()->user()->email }}">
                            </div>
                            @error('email')
                            <div class="text-right mt-1 text-red-400 text-xs">{{ $message }}</div>
                            @enderror
                        </div>
                    </div>
                    <div class="flex justify-end mt-8 items-end">
                        <button type="submit" class="bg-gray-800 text-white text-lg rounded px-4 py-2">Save & Continue to Next Step</button>
                    </div>
                </form>
            @endif

                @if($step == 'step2')
                    <form action="{{ route("vendor.site_create",["type"=>"step2"]) }}" method="POST" >
                        @csrf
                        <input type="hidden" name="id" value="{{ $code }}">
                        <div class="grid grid-cols-2 gap-6">

                            <div>
                                <div class="flex items-center">
                                    <label class="label-h-class w-2/5 text-right pr-8">Your Association with Site</label>
                                    <select class="select-h-class focus:ring-blue-500 focus:border-blue-500" name="associate_type">
                                        <option value="">Select</option>
                                        <option value="Publisher">Publisher</option>
                                        <option value="Owner">Owner</option>
                                    </select>
                                </div>
                                @error('associate_type')
                                    <div class="text-right mt-1 text-red-400 text-xs">{{ $message }}</div>
                                @enderror
                            </div>

                            <div>
                                <div class="flex items-center">
                                    <label class="label-h-class w-2/5 text-right pr-8">Domain Type</label>
                                    <select class="select-h-class focus:ring-blue-500 focus:border-blue-500" name="domain_type">
                                        <option value="">Select</option>
                                        <option value="http://www.">http://www.</option>
                                        <option value="https://www.">https://www.</option>
                                        <option value="http://">http://</option>
                                        <option value="https://">http://</option>
                                    </select>
                                </div>
                                @error('domain_type')
                                    <div class="text-right mt-1 text-red-400 text-xs">{{ $message }}</div>
                                @enderror
                            </div>



                            <div>
                                <div class="flex items-center">
                                    <label class="label-h-class w-2/5 text-right pr-8">Root Domain</label>
                                    <input type="text" class="textbox-class focus:ring-blue-500 focus:border-blue-500" name="domain_name" value="{{ $site ? $site->domain_name : old('domain_name') }}">
                                </div>
                                @error('domain_name')
                                    <div class="text-right mt-1 text-red-400 text-xs">{{ $message }}</div>
                                @enderror
                            </div>

                            <div>
                                <div class="flex items-center">
                                    <label class="label-h-class w-2/5 text-right pr-8">Select Niche</label>
                                    <select class="select-h-class focus:ring-blue-500 focus:border-blue-500" name="niche_type">
                                        <option value="">Select</option>
                                        <option value="Specific Niche">Specific Niche</option>
                                        <option value="Multi Niche">Multi Niche</option>
                                    </select>
                                </div>
                                @error('niche_type')
                                    <div class="text-right mt-1 text-red-400 text-xs">{{ $message }}</div>
                                @enderror
                            </div>




                            <div>
                                <div class="flex items-center">
                                    <label class="label-h-class w-2/5 text-right pr-8">Select Category</label>
                                    <select class="select-h-class block mt-1 w-full focus:ring-blue-500 focus:border-blue-500 rounded-md cursor-pointer focus:outline-none" name="category_type[]" multiple>
                                        <option value="">Select</option>
                                        <option value="Automobiles">Automobiles </option>
                                        <option value="Animals and pets">Animals and pets  </option>
                                        <option value="Adult, Relationships and Sex">Adult, Relationships and Sex  </option>
                                        <option value="Agriculture & Farming">Agriculture & Farming </option>
                                        <option value="Aviation and Flight">Aviation and Flight </option>
                                        <option value="Architecture and Design">Architecture and Design </option>
                                        <option value="Arts">Arts  </option>
                                        <option value="Banking and Financial">Banking and Financial </option>
                                        <option value="Beauty and Cosmetics">Beauty and Cosmetics  </option>
                                        <option value="Books and Author">Books and Author  </option>
                                        <option value="Business and Entrepreneurship">Business and Entrepreneurship </option>
                                        <option value="Career and Employment">Career and Employment </option>
                                        <option value="Construction and Repairs">Construction and Repairs  </option>
                                        <option value="CBD, Casino, Betting and Gambling">CBD, Casino, Betting and Gambling </option>
                                        <option value="Computers and Electronics">Computers and Electronics </option>
                                        <option value="Cryptocurrency and Bitcoin">Cryptocurrency and Bitcoin  </option>
                                        <option value="Culture and Tradition">Culture and Tradition </option>
                                        <option value="Design and Web Development">Design and Web Development  </option>
                                        <option value="Digital Marketing, SEO, and Advertising">Digital Marketing, SEO, and Advertising   </option>
                                        <option value="Environment">Environment </option>
                                        <option value="E-commerce and Shopping">E-commerce and Shopping </option>
                                        <option value="Education">Education </option>
                                        <option value="Entertainment, Music, Movies and Recreation">Entertainment, Music, Movies and Recreation </option>
                                        <option value="Fashion and lifestyle">Fashion and lifestyle </option>
                                        <option value="Finance and Investing">Finance and Investing </option>
                                        <option value="Food and Cuisine">Food and Cuisine  </option>
                                        <option value="Family and Parenting Child">Family and Parenting Child  </option>
                                        <option value="Gadgets">Gadgets </option>
                                        <option value="Games">Games </option>
                                        <option value="General Blog">General Blog  </option>
                                        <option value="Gardening">Gardening </option>
                                        <option value="Green Energy & Technology">Green Energy & Technology </option>
                                        <option value="Hardware and Development">Hardware and Development  </option>
                                        <option value="Humor">Humor </option>
                                        <option value="Home Improvement and Decor">Home Improvement and Decor  </option>
                                        <option value="Health and Fitness">Health and Fitness  </option>
                                        <option value="Home Appliances">Home Appliances </option>
                                        <option value="Industry and  Company">Industry and  Company </option>
                                        <option value="Insurance & Investment">Insurance & Investment  </option>
                                        <option value="Internet, Data & Cyber Law">Internet, Data & Cyber Law  </option>
                                        <option value="Job Career">Job Career  </option>
                                        <option value="Leisure and Hobbies">Leisure and Hobbies </option>
                                        <option value="Literature">Literature  </option>
                                        <option value="Love and Dating Relationships">Love and Dating Relationships </option>
                                        <option value="Legal and law">Legal and law </option>
                                        <option value="Manufacturing, Machinery and Equipment">Manufacturing, Machinery and Equipment  </option>
                                        <option value="Marketing">Marketing </option>
                                        <option value="Medical">Medical </option>
                                        <option value="Metallurgy">Metallurgy  </option>
                                        <option value="Miscellaneous">Miscellaneous </option>
                                        <option value="Make Money">Make Money  </option>
                                        <option value="Movers and Packers">Movers and Packers  </option>
                                        <option value="Nature">Nature  </option>
                                        <option value="News and Media Updates">News and Media Updates  </option>
                                        <option value="Personal Blogs">Personal Blogs  </option>
                                        <option value="Places">Places  </option>
                                        <option value="Politics">Politics  </option>
                                        <option value="Programming">Programming </option>
                                        <option value="Public Service">Public Service  </option>
                                        <option value="Product Reviews">Product Reviews </option>
                                        <option value="Photography and Wedding">Photography and Wedding </option>
                                        <option value="Parenting, Baby and Moms">Parenting, Baby and Moms  </option>
                                        <option value="PR Banking">PR Banking  </option>
                                        <option value="Real Estate and Homes">Real Estate and Homes </option>
                                        <option value="Religion">Religion  </option>
                                        <option value="Science">Science </option>
                                        <option value="Society">Society </option>
                                        <option value="Startups">Startups  </option>
                                        <option value="Security">Security  </option>
                                        <option value="Society and Enforcements">Society and Enforcements  </option>
                                        <option value="Software development, Apps, Saas and Tools">Software development, Apps, Saas and Tools  </option>
                                        <option value="Sports and Games">Sports and Games  </option>
                                        <option value="Social Media">Social Media  </option>
                                        <option value="Senior Living">Senior Living </option>
                                        <option value="Technology">Technology  </option>
                                        <option value="Telecommunication">Telecommunication </option>
                                        <option value="Travel and Tourism">Travel and Tourism  </option>
                                        <option value="Trade and Commerce">Trade and Commerce  </option>
                                        <option value="Transportation">Transportation  </option>
                                        <option value="Writing and Tools Essay">Writing and Tools Essay </option>
                                    </select>

                                </div>
                                @error('category_type')
                                <div class="text-right mt-1 text-red-400 text-xs">{{ $message }}</div>
                                @enderror
                            </div>


                            <div>
                                <div class="flex items-center">
                                    <label class="label-h-class w-2/5 text-right pr-8">Select Traffic Source</label>
                                    <select class="select-h-class block focus:ring-blue-500 focus:border-blue-500 mt-1 w-full rounded-md cursor-pointer focus:outline-none" name="traffic_source[]" multiple>
                                        <option value="">Select</option>
                                        <option value="UK">UK</option>
                                        <option value="USA">USA</option>
                                        <option value="CANADA">CANADA</option>
                                        <option value="AUSTRALIA">AUSTRALIA</option>
                                        <option value="INDIA">INDIA</option>
                                        <option value="DUBAI">DUBAI</option>
                                        <option value="NEWZEALAND">NEWZEALAND</option>
                                        <option value="AUSTRIA">AUSTRIA</option>
                                    </select>

                                </div>
                                @error('traffic_source')
                                <div class="text-right mt-1 text-red-400 text-xs">{{ $message }}</div>
                                @enderror
                            </div>


                            <div>
                                <div class="flex items-center">
                                    <label class="label-h-class w-2/5 text-right pr-8">Spam Score <small class="text-gray-600">(optional)</small> </label>
                                    <input type="text" class="textbox-class focus:ring-blue-500 focus:border-blue-500" name="spam_score" value="{{ $site ? $site->spam_score : old('spam_score') }}">
                                </div>
                                @error('spam_score')
                                    <div class="text-right mt-1 text-red-400 text-xs">{{ $message }}</div>
                                @enderror
                            </div>


                            <div>
                                <div class="flex items-center">
                                    <label class="label-h-class w-2/5 text-right pr-8">Word Count</label>
                                    <input type="text" class="textbox-class focus:ring-blue-500 focus:border-blue-500" name="word_count" value="{{ $site ? $site->word_count : old('word_count') }}">
                                </div>
                                @error('word_count')
                                    <div class="text-right mt-1 text-red-400 text-xs">{{ $message }}</div>
                                @enderror
                            </div>

                            <div>
                                <div class="flex items-center">
                                    <label class="label-h-class w-2/5 text-right pr-8">Sample URL</label>
                                    <input type="text" class="textbox-class focus:ring-blue-500 focus:border-blue-500" name="sample_url" value="{{ $site ? $site->sample_url : old('sample_url') }}">
                                </div>
                                @error('sample_url')
                                    <div class="text-right mt-1 text-red-400 text-xs">{{ $message }}</div>
                                @enderror
                            </div>

                            <div>

                            </div>
                            <div>

                            </div>

                            <div class="flex justify-end mt-8 items-end">
                                <button type="submit" class="bg-gray-800 text-white text-lg rounded px-4 py-2">Save & Continue to Next Step</button>
                            </div>

                        </div>

                    </form>
                @endif



                @if($step == 'step3')
                    <form action="{{ route("vendor.site_create",["type"=>"step3"]) }}" method="POST" >
                        @csrf
                        <input type="hidden" name="id" value="{{ $code }}">
                        <div class="grid grid-cols-2 gap-6">
                            {!! select_dropdown($errors,'sponsor-type','Marked Sponsor','sponsor_type',false,($site ? $site->sponsor_type_id : false)) !!}
                            {!! select_dropdown($errors,'link-type','Link Type','link_type',false,($site ? $site->link_type_id : false)) !!}
                            {!! select_dropdown($errors,'validity-type','Link Validity','validity_type',false,($site ? $site->validity_type_id : false)) !!}
                            <div class="row-span-2">
                                <div class="flex items-center">
                                    <label class="label-h-class w-2/5 text-right pr-8">Do you accept grey niche</label>
                                    <select class="select-h-class focus:ring-blue-500 focus:border-blue-500" name="grey_niche_type">
                                        <option value="">Select</option>
                                        @foreach($grey_niche_types->masters as $types)
                                            <option
                                                @if($site && $site->grey_niche_type_id) {{ $site->grey_niche_type_id == $types->id ? 'selected' : '' }}
                                                @elseif(old('grey_niche_type')) {{ old('grey_niche_type') == $types->id ? 'selected' : '' }}
                                                @endif
                                                value="{{ $types->id }}">{{ $types->name }}</option>
                                        @endforeach
                                    </select>
                                </div>
                                @error('grey_niche_type')
                                <div class="text-right mt-1 text-red-400 text-xs">{{ $message }}</div>
                                @enderror
                                <div class="
                                    @if($site && $site->grey_niche_type_id) {{ $site->grey_niche_type_id == 9 ? 'block' : 'hidden' }}
                                @elseif(old('grey_niche_type')) {{ old('grey_niche_type') == 9 ? 'block' : 'hidden'  }}
                                @else hidden
                                    @endif " id="grey_niche">
                                    <div class="flex items-center space-x-4 justify-end mt-3 " >
                                        @foreach($grey_niches->masters as $master)
                                            <label class="flex items-center space-x-2">
                                                <input @if($site && $site->site_multiple_grey_niche) @if(in_array($master->id,$site->site_multiple_grey_niche->pluck("name")->map(function ($s){ return (double) $s; })->toArray())) checked @endif @endif type="checkbox" name="grey_niche[]" value="{{ $master->id }}"> <span>{{ $master->name }}</span>
                                            </label>
                                        @endforeach
                                    </div>
                                    @error('grey_niche')
                                    <div class="text-right mt-1 text-red-400 text-xs">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>


                        </div>
                        <div class="flex justify-end mt-8 items-end">
                            <button type="submit" class="bg-gray-800 text-white text-lg rounded px-4 py-2">Save & Continue to Next Step</button>
                        </div>
                    </form>
                @endif


                @if($step == 'step4')
                    <form action="{{ route("vendor.site_create",["type"=>"step4"]) }}" method="POST" >
                        @csrf
                        <input type="hidden" name="id" value="{{ $code }}">
                        <div class="grid grid-cols-2 gap-6">
                            <div>
                                <div class="flex items-center">
                                    <label class="label-h-class w-2/5 text-right pr-8">DA</label>
                                    <input type="text" autofocus class="textbox-class focus:ring-blue-500 focus:border-blue-500" name="da" value="{{ old('da') }}">
                                </div>
                                @error('da')
                                <div class="text-right mt-1 text-red-400 text-xs">{{ $message }}</div>
                                @enderror
                            </div>
                            <div>
                                <div class="flex items-center">
                                    <label class="label-h-class w-2/5 text-right pr-8">DR</label>
                                    <input type="text" class="textbox-class focus:ring-blue-500 focus:border-blue-500" name="dr" value="{{ old('dr') }}">
                                </div>
                                @error('dr')
                                <div class="text-right mt-1 text-red-400 text-xs">{{ $message }}</div>
                                @enderror
                            </div>
                            <div>
                                <div class="flex items-center">
                                    <label class="label-h-class w-2/5 text-right pr-8">Traffic</label>
                                    <input type="text" class="textbox-class focus:ring-blue-500 focus:border-blue-500" name="traffic" value="{{ old('traffic') }}">
                                </div>
                                @error('traffic')
                                <div class="text-right mt-1 text-red-400 text-xs">{{ $message }}</div>
                                @enderror
                            </div>
                            <div>
                                <div class="flex items-center">
                                    <label class="label-h-class w-2/5 text-right pr-8">GP Price (USD)</label>
                                    <input type="number" class="textbox-class focus:ring-blue-500 focus:border-blue-500" name="gp" value="{{ old('gp') }}">
                                </div>
                                <div id="gp_error" class="text-right mt-1 text-red-400 text-xs">

                                </div>
                                @error('gp')
                                <div id="gp_server_error" class="text-right mt-1 text-red-400 text-xs">{{ $message }}</div>
                                @enderror
                            </div>
                            <div>
                                <div class="flex items-center">
                                    <label class="label-h-class w-2/5 text-right pr-8">RD</label>
                                    <input type="text" class="textbox-class focus:ring-blue-500 focus:border-blue-500" name="rd" value="{{ old('rd') }}">
                                </div>
                                @error('rd')
                                <div class="text-right mt-1 text-red-400 text-xs">{{ $message }}</div>
                                @enderror
                            </div>

                            <div>
                                <div class="flex items-center">
                                    <label class="label-h-class w-2/5 text-right pr-8">Niche Edit Price (USD)</label>
                                    <input type="number" class="textbox-class focus:ring-blue-500 focus:border-blue-500" name="niche_price" value="{{ old('niche_price') }}">
                                </div>
                                <div id="niche_error" class="text-right mt-1 text-red-400 text-xs">

                                </div>
                                @error('niche_price')
                                <div id="niche_server_error" class="text-right mt-1 text-red-400 text-xs">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                        <div class="flex justify-end mt-8 items-end">
                            <button type="submit" class="bg-gray-800 text-white text-lg rounded px-4 py-2">Save & Submit</button>
                        </div>
                    </form>
                @endif
        </div>

    </div>




@endsection



@section("header")
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/chosen/1.8.7/chosen.min.css" integrity="sha512-yVvxUQV0QESBt1SyZbNJMAwyKvFTLMyXSyBHDO4BG5t7k/Lw34tyqlSDlKIrIENIzCl+RVUNjmCPG+V/GMesRw==" crossorigin="anonymous" referrerpolicy="no-referrer" />
    <style>
        .chosen-choices{
            border-color: #e2e2e2!important;
            border-radius: 0.3rem!important;
            padding: 6px 10px!important;
            background-image: none!important;
            margin-top: 3px!important;
            margin-top: 0.25rem!important;
            display: block!important;
            width: 100%!important;
            border-radius: 0.375rem;
            --tw-border-opacity: 1!important;
            border-color: rgb(209 213 219 / var(--tw-border-opacity))!important;
            padding-top: 0.3rem!important;
            padding-bottom: 0.3rem!important;
            padding-left: 0.75rem!important;
            padding-right: 2.5rem!important;
        }
        .search-choice{

        }

    </style>
@endsection

@section("footer")
    <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.6.0/jquery.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/chosen/1.8.7/chosen.jquery.min.js" integrity="sha512-rMGGF4wg1R73ehtnxXBt5mbUfN9JUJwbk21KMlnLZDJh7BkPmeovBuddZCENJddHYYMkCh9hPFnPmS9sspki8g==" crossorigin="anonymous" referrerpolicy="no-referrer"></script>
    <script>
        $('select[name="traffic_source[]"]').chosen();
        $('select[name="category_type[]"]').chosen({
            max_selected_options:5
        });
        $('.chosen-container.chosen-container-multi').css('width','100%');

        $('select[name="grey_niche_type"]').on("change",function () {
            let val= $(this).find("option:selected").text();
            if( val.toLowerCase() === 'yes' ){
                $('#grey_niche').show();
            }else{
                $('#grey_niche').hide();
            }
        });


        var debounceTimeout = null;

        $('input[name="gp"]').on("focusout",function () {
            let val= $(this).val();
            let traffic= $('input[name="traffic"]').val();
            console.log(traffic);
            if( traffic.length === 0 ){
                $('#gp_error').html("Enter Traffic Value");
            }else{
                $('#gp_error').html("");
                let request = $.ajax({
                    url : "/ajax/traffic",
                    method : "GET",
                    data : {
                        traffic : traffic,
                        gpprice : val
                    }
                });

                request.done(function (msg) {
                    $('#gp_server_error').html(" ");
                    $('#gp_error').html(msg);
                });
            }
        });


        $('input[name="niche_price"]').on("focusout",function () {
            let val= $(this).val();
            let rd= $('input[name="rd"]').val();
            if( rd.length === 0 ){
                $('#niche_error').html("Enter RD Value");
            }else{
                $('#niche_error').html("");
                let request = $.ajax({
                    url : "/ajax/rd",
                    method : "GET",
                    data : {
                        rd : rd,
                        niche : val
                    }
                });

                request.done(function (msg) {
                    $('#niche_server_error').html(" ");
                    $('#niche_error').html(msg);
                });
            }
        });



    </script>

    @if(request("type") == 'step2')
        <script>
            $('select[name="associate_type"]').focus();
        </script>
    @endif

    @if(request("type") == 'step3')
        <script>
            $('select[name="sponsor_type"]').focus();
        </script>
    @endif

@endsection
