@extends("vendor.layouts.app")

@section("container")
    <div class="max-w-screen-2xl mx-auto px-8">
        <div class="bg-white shadow mt-4 p-4">
            <div class="grid grid-cols-4">
                <div class="col-span-3 ml-6 border border-gray-100">
                    <h2 class="bg-gray-100 p-4 text-center">Order History</h2>

                    <div class="p-4">
                        <table class="table-auto w-full">
                            <thead class="bg-blue-500">
                            <tr>
                                <th class="px-2 py-4 text-xs border border-gray-200 text-white">Status</th>
                                <th class="px-2 py-4 text-xs border border-gray-200 text-white">Date</th>
                                <th class="px-2 py-4 text-xs border border-gray-200 text-white">User</th>
                                <th class="px-2 py-4 text-xs border border-gray-200 text-white">Info</th>
                            </tr>
                            </thead>
                            <tbody>
                            @foreach($order->order_histories as $history)
                                <tr>
                                    <td class="text-xs px-2 py-2 border border-gray-200 text-center">

                                        @if($history->status == App\Harman\Common\OrderDetailStatus::$TEAM_APPROVED_VENDOR_PENDING)
                                           Vendor Approval Pending
                                        @endif

                                            @if($history->status == App\Harman\Common\OrderDetailStatus::$VENDOR_APPROVED)
                                                Vendor Approved
                                            @endif


                                            @if($history->status == App\Harman\Common\OrderDetailStatus::$PROJECT_COMPLETED)
                                                Project Completed
                                            @endif


                                    </td>
                                    <td class="text-xs px-2 py-2 border border-gray-200 text-center">
                                        {{ $history->created_at->toDayDateTimeString() }}
                                    </td>
                                    <td class="text-xs px-2 py-2 border border-gray-200 text-center">
                                        <div>{{ $history->user->name }}</div>
                                        <div>{{ $history->user->email }}</div>
                                    </td>
                                    <td class="text-xs px-2 py-2 border border-gray-200 text-center">
                                        <div id="first{{ $history->id }}" class="view_modal scale-0 transition-all origin-top-right	 duration-300 fixed z-10 inset-0 overflow-y-auto" aria-labelledby="modal-title" role="dialog" aria-modal="true">
                                            <div class="flex items-end justify-center min-h-screen pt-4 px-4 pb-20 text-center sm:block sm:p-0">

                                                <div class="fixed inset-0 bg-white bg-opacity-75 transition-opacity" aria-hidden="true"></div>

                                                <span class="hidden sm:inline-block sm:align-middle sm:h-screen" aria-hidden="true">&#8203;</span>


                                                <div class="inline-block align-bottom bg-white rounded-lg text-left overflow-hidden shadow-xl transform transition-all sm:my-8 sm:align-middle sm:max-w-lg sm:w-full">
                                                    <div class="bg-white p-4">
                                                        <div class="">
                                                            <h1 class="bg-gray-100 text-sm p-3">Data Attached</h1>


                                                            @if($history->status == App\Harman\Common\OrderDetailStatus::$TEAM_APPROVED_VENDOR_PENDING)
                                                                <div class="p-3">
                                                                    <div class="mb-4 pb-4 border-b border-gray-200">
                                                                        <div class="text-blue-500 font-semibold">Replace</div>
                                                                        <div class="text-gray-600 ml-2 mt-1">{{ $history->oreplace }}</div>
                                                                    </div>
                                                                    <div class="mb-4 pb-4 border-b border-gray-200">
                                                                        <div class="text-blue-500 font-semibold">Insert After</div>
                                                                        <div class="text-gray-600 ml-2 mt-1">{{ $history->insert_after }}</div>
                                                                    </div>
                                                                    <div class="mb-4 pb-4 border-b border-gray-200">
                                                                        <div class="text-blue-500 font-semibold">Statement</div>
                                                                        <div class="text-gray-600 ml-2 mt-1">{!! $history->statement !!}</div>
                                                                    </div>
                                                                    @if($order->price_type)
                                                                        <div class="mb-4 pb-4 border-b border-gray-200">
                                                                            <div class="text-blue-500 font-semibold">Price</div>
                                                                            <div class="text-gray-600 ml-2 mt-1">{{ $order->price_type }}</div>
                                                                        </div>
                                                                    @endif

                                                                </div>
                                                            @endif

                                                            @if($history->status == App\Harman\Common\OrderDetailStatus::$VENDOR_APPROVED)
                                                                <div class="p-3">
                                                                    <div class="mb-4 pb-4 border-b border-gray-200">
                                                                        <div class="text-blue-500 font-semibold">Site URL</div>
                                                                        <div class="text-gray-600 ml-2 mt-1">{{ $history->site_url }}</div>
                                                                    </div>
                                                                </div>
                                                            @endif



                                                           <div class="flex items-center justify-between">

                                                               @if($history->status == App\Harman\Common\OrderDetailStatus::$TEAM_APPROVED_VENDOR_PENDING)
                                                               <div class="flex-1">
                                                                   @if($history->editable == 1)
                                                                       <form action="{{ route("vendor.change_status") }}" method="POST" class="flex items-center">
                                                                           @csrf
                                                                           <input type="url" name="site_url" class="w-48 textbox-class rounded-none" required placeholder="Site URL">
                                                                           <input type="hidden" name="order_detail_id" value="{{ $order->id }}">
                                                                           <button class="bg-green-700 text-white px-4 py-3 rounded-none">Accept & Done</button>
                                                                       </form>
                                                                   @endif
                                                               </div>
                                                               @endif


                                                               <div class="text-right">
                                                                   <button class="close bg-red-500 text-white px-4 py-2 rounded-md">Close</button>
                                                               </div>
                                                           </div>

                                                        </div>
                                                    </div>

                                                </div>
                                            </div>
                                        </div>
                                       @if($history->status == App\Harman\Common\OrderDetailStatus::$PROJECT_COMPLETED)

                                        @else
                                            <button class="bg-green-700 text-white px-3 py-1 view_buttons" id="{{ $history->id }}">view</button>
                                        @endif
                                    </td>
                                </tr>
                            @endforeach

                            </tbody>
                        </table>
                    </div>

                </div>
            </div>
        </div>
    </div>




    <script>
        $(function () {
            $('#first_btn').on("click",function () {
                $('div#first').removeClass('scale-0').addClass('scale-100');
            });

            $('div#first button').on("click",function () {
                $('div#first').removeClass('scale-100').addClass('scale-0');
            });

            $('div.view_modal button.close').on("click",function () {
                $(this).parents('.view_modal').removeClass('scale-100').addClass('scale-0');
            });

            $('.view_buttons').on("click",function () {
                let id= $(this).attr("id");
                $('div#first'+id).removeClass('scale-0').addClass('scale-100')
            });

        });
    </script>
@endsection
