@extends("vendor.layouts.app")

@section("container")
    <div class="bg-white max-w-screen-xl mx-auto shadow mt-4 p-4">
        <h1 class="uppercase border-b-2 border-gray-200 pb-2 mb-8">Setup Paypal</h1>

        <div>
            <form action="{{ route("vendor.setup_paypal") }}" method="POST">
                @csrf
                <div class="flex items-end">
                    <div>
                        <div>
                            <label class="label-h-class flex items-center justify-between">
                                <span>Enter Paypal Email</span>
                                @error('paypal_email')
                                    <span class="text-red-600 text-xs">*{{ $message }}</span>
                                @enderror
                            </label>
                            <input type="text" name="paypal_email" class="w-96 textbox-class" value="{{ auth()->user()->paypal_email }}">
                        </div>

                    </div>
                    <div class="ml-2">
                        <button class="bg-gray-800 text-white rounded-md px-4 py-2">Submit</button>
                    </div>
                </div>
            </form>
        </div>



    </div>
@endsection
