@extends("vendor.layouts.app")

@section("container")
<div class="bg-white max-w-screen-xl mx-auto shadow mt-4 p-4">
    <h1 class="uppercase border-b-2 border-gray-200 pb-2 mb-8">Payment Method</h1>

    <div class="flex items-start ">
        <div class="flex-1">
            <form action="{{ route("vendor.setup_paypal") }}" method="POST">
                @csrf
                <div class="flex items-end">
                    <div>
                        <div>
                            <label class="label-h-class flex items-center justify-between">
                                <span>Enter Paypal Email</span>
                            </label>
                            <input type="text" name="paypal_email" class="w-96 textbox-class" value="{{ auth()->user()->paypal_email }}">
                        </div>

                    </div>
                    <div class="ml-2">
                        <button class="bg-gray-800 text-white rounded-md px-4 py-2">Submit</button>
                    </div>
                </div>
            </form>
        </div>


        <div class="flex-1">
            <form action="{{ route("vendor.bank_details") }}" method="POST">
                @csrf
                <div class="flex flex-col space-y-4 mt-4">
                    <div>
                        <div class="flex items-center">
                            <label class="w-1/3 label-h-class text-right mr-10">Account Holder Name</label>
                            <input type="text" name="ac_holder_name" class="textbox-class" value="{{ auth()->user()->ac_holder_name}}">
                        </div>
                        @error('ac_holder_name')
                        <div class="text-red-600 text-xs text-right">{{ $message }}</div>
                        @enderror
                    </div>

                    <div>
                        <div class="flex items-center">
                            <label class="w-1/3 label-h-class text-right mr-10">Bank Name</label>
                            <input type="text" name="bank_name" class="textbox-class" value="{{ auth()->user()->bank_name}}">
                        </div>
                        @error('bank_name')
                        <div class="text-red-600 text-xs text-right">{{ $message }}</div>
                        @enderror
                    </div>

                    <div>
                        <div class="flex items-center">
                            <label class="w-1/3 label-h-class text-right mr-10">Account Number</label>
                            <input type="text" name="account_number" class="textbox-class" value="{{ auth()->user()->account_number}}">
                        </div>
                        @error('account_number')
                        <div class="text-red-600 text-xs text-right">{{ $message }}</div>
                        @enderror
                    </div>

                    <div>
                        <div class="flex items-center">
                            <label class="w-1/3 label-h-class text-right mr-10">Bank Address</label>
                            <input type="text" name="bank_address" class="textbox-class" value="{{ auth()->user()->bank_address}}">
                        </div>
                        @error('bank_address')
                        <div class="text-red-600 text-xs text-right">{{ $message }}</div>
                        @enderror
                    </div>

                    <div>
                        <div class="flex items-center">
                            <label class="w-1/3 label-h-class text-right mr-10">Swift Code</label>
                            <input type="text" name="swift_code" class="textbox-class" value="{{ auth()->user()->swift_code}}">
                        </div>
                        @error('swift_code')
                        <div class="text-red-600 text-xs text-right">{{ $message }}</div>
                        @enderror
                    </div>
                    <div class="col-span-2 w-full">
                        <button class="bg-gray-800 py-2 w-full text-white">Update Bank Details</button>
                    </div>

                </div>
            </form>
        </div>
    </div>
</div>
@endsection
