@php use App\Models\NewOrderProcessDetail;use App\Project\NewOrderStatus; @endphp
@extends("vendor.layouts.app")

@section("container")
    <div class="bg-white p-4">
        @include("partials.vendor_top_nav")
    </div>

    <div class="bg-white max-w-screen-xl mx-auto mt-4 shadow px-5 p-3 pt-6">

        @if($errors->all() )
            @foreach($errors as $error)
                {{ $error }}
            @endforeach
        @endif
        <table class="w-full">
            <thead class="bg-gray-50">
            <tr>
                <th class="p-5 text-xs font-black text-left" width="4%">S.no</th>
                <th class="p-5 text-xs font-black text-left" width="15%">Order No</th>
                <th class="p-5 text-xs font-black text-left" width="50%">Root Domain</th>
                <th class="p-5 text-xs font-black text-center">Action</th>
            </tr>
            </thead>
            <tbody>
            @php $i=1; @endphp
            @foreach($orders as $detail)
                <tr>
                    <td class="p-5 text-xs text-left">{{ $i++ }}</td>
                    <td class="p-5 text-xs text-left">{{ $detail->new_order_process->new_order->order_id }} @if($detail->new_order_process->new_order ->type=='sub')
                            (Sub Order)
                        @endif</td>
                    <td class="p-5 text-xs text-left">{{ $detail->new_site->root_domain }}</td>
                    <td class="p-5 text-xs text-center">
                        <a href="{{ route("vendor.view_completed_orders",[$detail->id,"action" => $action]) }}"
                           class="text-xs font-bold underline">view</a>
                    </td>
                </tr>
            @endforeach
            </tbody>
        </table>
    </div>

@endsection


@section("footer")
    <script>
        $(function () {
            $('body').on("click", "#copy_btn", function () {
                let text = $(this).siblings("#statement").text();
                window.navigator.clipboard.writeText(text);
                alert("copied");
            });
        });
    </script>
@endsection
