@php use App\Models\Country;use App\Models\Wallet;use Carbon\Carbon;use Illuminate\Support\Facades\Auth; @endphp
@extends("vendor.dashboard.new_design")

@section("heading")
    Edit Profile
@endsection

@section("container")
    <div class="bg-white mt-3 m-3 text-sm shadow">
        <div class="border-b border-gray-300 p-4 text-lg font-bold">User Profile</div>
        <div class="flex items-center justify-between border-b border-gray-300">
            <div class="flex items-start">
                <div class="w-80 flex items-center justify-center mb-6">
                    @if(Auth::user()->profile_image)
                        <img src="/uploads/{{ Auth::user()->profile_image }}"
                             class="w-64 h-64 rounded-full object-cover">
                    @else
                        <img src="/images/user.jpg" class="w-64">
                    @endif
                </div>
                <div class="flex-1 mt-8">
                    <div class="text-3xl font-bold text-black">{{ Auth::user()->name }}</div>
                    <div class="mt-2 text-lg">Blogger</div>

                    <div class="mt-10 text-4xl font-black">
                        {{ vendor_balance() }}</div>
                    <div class="text-lg mt-3">Balance</div>

                </div>
            </div>
            <div class="flex flex-col space-y-4 pr-8">
                <a href="{{ route("vendor.profile") }}"
                   class="bg-[#fc6527] text-white inline-block px-6 py-3 rounded-lg">Update Profile</a>
                <a href="{{ route("change_password") }}"
                   class="bg-[#fc6527] text-white inline-block px-6 py-3 rounded-lg">Change Password</a>
            </div>
        </div>


    </div>


    <div class="bg-white mt-3 p-3 text-sm shadow flex items-center">
        <div class="w-48"></div>
        <form method="POST" enctype="multipart/form-data" class="flex-1 max-w-4xl">
            @csrf

            <div class="flex items-center mt-4">
                <label class="label-h-class w-48 text-right mr-8">Name</label>
                <input type="text" class="textbox-class flex-1" name="name" value="{{ Auth::user()->name }}">
            </div>

            <div class="flex items-center mt-4">
                <label class="label-h-class w-48 text-right mr-8">Country</label>
                <select class="textbox-class flex-1" name="country_id">
                    <option value="">Select Country</option>
                    @foreach(Country::orderBy('name','asc')->get() as $country )
                        <option @if(Auth::user()->country_id == $country->id) selected @endif value="{{ $country->id }}">{{ $country->name }}</option>
                    @endforeach
                </select>
            </div>

            <div class="flex items-center mt-4">
                <label class="label-h-class w-48 text-right mr-8">Whatsapp</label>
                <input type="text" class="textbox-class flex-1" name="whatsapp" value="{{ Auth::user()->whatsapp }}">
            </div>

            <div class="flex items-center mt-4">
                <label class="label-h-class w-48 text-right mr-8">Skype</label>
                <input type="text" class="textbox-class flex-1" name="skype" value="{{ Auth::user()->skype }}">
            </div>

            <div class="flex items-center mt-4">
                <label class="label-h-class w-48 text-right mr-8">Profile Image</label>
                <input type="file" name="profile">
            </div>

            <div class="flex items-center mt-4">
                <label class="label-h-class w-48 text-right mr-8"></label>
                <button class="bg-red-500 text-white px-6 py-3 rounded">Update Profile</button>
            </div>


        </form>

    </div>
@stop

