@php use App\Models\NewOrderProcessDetail;use App\Models\Wallet;use App\Project\NewOrderStatus;use Illuminate\Support\Facades\Auth; @endphp
    <!doctype html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport"
          content="width=device-width, user-scalable=no, initial-scale=1.0, maximum-scale=1.0, minimum-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    @vite('resources/css/app.css')

    @yield("header")
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.6.0/jquery.min.js"></script>
    <script src="/js/app.js"></script>
    @livewireStyles
    @stack("styles")

    <title>Vendor</title>
    <script src="https://unpkg.com/@popperjs/core@2"></script>
    <script src="https://unpkg.com/tippy.js@6"></script>
</head>
<body class="bg-gray-50">
<div class="flex items-start">
    <div id="left_menu" class="w-64 bg-[#275570] h-screen overflow-y-auto z-50 fixed top-0">
        <div class="flex items-center justify-center mt-6">
            <img src="/images/d.png" class="w-6">
            <span class="text-white text-xl font-black">Link Management</span>
        </div>

        <div class="flex items-center justify-center mt-12">
            <div class="w-32 flex items-center justify-center h-32 bg-white rounded-full">
                @if(Auth::user()->profile_image)
                    <img src="/uploads/{{ Auth::user()->profile_image }}"
                         class="w-32 h-32 rounded-full border-2 border-white object-cover">
                @else
                    <img src="/images/user.jpg" class="w-32 h-32 border-2 border-white rounded-full object-cover"/>
                @endif
            </div>
        </div>

        <div class="text-center mt-4"><span class="text-xl font-black text-white">{{ Auth::user()->name }}</span></div>

        <div class="mt-12">
            <a href="{{ route("vendor.dashboard") }}"
               class="@if(request()->routeIs("vendor.dashboard")) bg-primary-color @endif flex items-center space-x-4 pl-6 py-4 text-white text-sm">
                    <span>
                        <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="1.5"
                             stroke="currentColor" class="w-5 h-5">
                            <path stroke-linecap="round" stroke-linejoin="round"
                                  d="M2.25 12l8.954-8.955c.44-.439 1.152-.439 1.591 0L21.75 12M4.5 9.75v10.125c0 .621.504 1.125 1.125 1.125H9.75v-4.875c0-.621.504-1.125 1.125-1.125h2.25c.621 0 1.125.504 1.125 1.125V21h4.125c.621 0 1.125-.504 1.125-1.125V9.75M8.25 21h8.25"/>
                        </svg>
                    </span>
                <span>
                        Dashboard
                    </span>
            </a>

            <a href="{{ route("vendor.view_profile") }}"
               class="@if(request()->routeIs("vendor.view_profile")) bg-primary-color @endif flex items-center space-x-4 pl-6 py-4 text-white text-sm hover:bg-primary-color">
                    <span>
                        <svg aria-hidden="true" focusable="false" data-prefix="fa-thin" data-icon="user" class="w-5 h-5"
                             role="img" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 448 512"><path
                                d="M224 256c70.7 0 128-57.31 128-128s-57.3-128-128-128C153.3 0 96 57.31 96 128S153.3 256 224 256zM224 16c61.76 0 112 50.24 112 112c0 61.76-50.24 112-112 112S112 189.8 112 128C112 66.24 162.2 16 224 16zM274.7 304H173.3C77.61 304 0 381.6 0 477.3c0 19.14 15.52 34.67 34.66 34.67h378.7C432.5 512 448 496.5 448 477.3C448 381.6 370.4 304 274.7 304zM413.3 496H34.67C24.37 496 16 487.6 16 477.3C16 390.6 86.58 320 173.3 320h101.3C361.4 320 432 390.6 432 477.3C432 487.6 423.6 496 413.3 496z"
                                fill="currentColor"/></svg>
                    </span>
                <span>
                        Profile
                    </span>
            </a>

            <a href="{{ route('new-site.create') }}"
               class="@if(request()->routeIs("new-site.create")) bg-primary-color @endif flex items-center space-x-4 pl-6 py-4 text-white text-sm hover:bg-primary-color">
                    <span>
                        <svg aria-hidden="true" focusable="false" data-prefix="fa-thin" data-icon="browser"
                             class="w-5 h-5" role="img" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512"><path
                                d="M464 32h-416C21.49 32 0 53.49 0 80v352C0 458.5 21.49 480 48 480h416c26.51 0 48-21.49 48-48v-352C512 53.49 490.5 32 464 32zM16 80c0-17.64 14.36-32 32-32h40V128H16V80zM496 432c0 17.64-14.36 32-32 32h-416c-17.64 0-32-14.36-32-32v-288h480V432zM496 128H104V48H464c17.64 0 32 14.36 32 32V128z"
                                fill="currentColor"/></svg>
                    </span>
                <span>
                        Single Site
                    </span>
            </a>

            <a href="{{ route("vendor.upload_excel") }}"
               class="@if(request()->routeIs("vendor.upload_excel")) bg-primary-color @endif flex items-center pl-6 py-4 text-white text-sm hover:bg-primary-color relative">

                    <span class="mr-4 relative">
                        <svg aria-hidden="true" focusable="false" data-prefix="fa-thin" data-icon="globe"
                             class="w-5 h-5" role="img" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512"><path
                                d="M256 16C123.5 16 16 123.5 16 256s107.5 240 240 240s239.1-107.5 239.1-240S388.5 16 256 16zM464.1 176h-103.5c-10.3-62.32-32.19-112.8-60.2-139.4C376.6 52.13 437.9 105.6 464.1 176zM352 256c0 22.63-1.578 43.98-4.274 64H164.3C161.6 299.1 160 278.6 160 256s1.578-43.98 4.273-64h183.5C350.4 212 352 233.4 352 256zM256 480c-35.5 0-74.05-56.38-89.24-144h178.5C330.1 423.6 291.5 480 256 480zM166.8 176C181.9 88.38 220.5 32 256 32s74.06 56.38 89.24 144H166.8zM210.7 36.61C182.7 63.21 160.8 113.7 150.5 176H47.02C74.07 105.6 135.4 52.13 210.7 36.61zM41.43 192h106.7C145.5 212.4 144 233.8 144 256s1.516 43.6 4.148 64H41.43C35.37 299.7 32 278.2 32 256S35.37 212.3 41.43 192zM47.02 336h103.5c10.3 62.32 32.19 112.8 60.2 139.4C135.4 459.9 74.07 406.4 47.02 336zM301.3 475.4c28.01-26.6 49.9-77.07 60.2-139.4h103.5C437.9 406.4 376.6 459.9 301.3 475.4zM470.6 320h-106.7C366.5 299.6 368 278.2 368 256s-1.516-43.6-4.148-64h106.7C476.6 212.3 480 233.8 480 256S476.6 299.7 470.6 320z"
                                fill="currentColor"/></svg>
                    </span>
                <span>
                        Bulk Sites
                    </span>
            </a>


            <a href="{{ route("vendor.sites") }}"
               class="@if(request()->routeIs("vendor.sites")) bg-primary-color @endif flex items-center space-x-4 pl-6 py-4 text-white text-sm hover:bg-primary-color">
                    <span>
                        <svg aria-hidden="true" focusable="false" data-prefix="fa-thin" data-icon="sitemap"
                             class="w-5 h-5" role="img" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 640 512"><path
                                d="M384 352H256c-17.67 0-32 14.33-32 32v96c0 17.67 14.33 32 32 32h128c17.67 0 32-14.33 32-32v-96C416 366.3 401.7 352 384 352zM400 480c0 8.822-7.178 16-16 16H256c-8.822 0-16-7.178-16-16v-96c0-8.822 7.178-16 16-16h128c8.822 0 16 7.178 16 16V480zM608 352h-128c-17.67 0-32 14.33-32 32v96c0 17.67 14.33 32 32 32h128c17.67 0 32-14.33 32-32v-96C640 366.3 625.7 352 608 352zM624 480c0 8.822-7.178 16-16 16h-128c-8.822 0-16-7.178-16-16v-96c0-8.822 7.178-16 16-16h128c8.822 0 16 7.178 16 16V480zM160 352H32c-17.67 0-32 14.33-32 32v96c0 17.67 14.33 32 32 32h128c17.67 0 32-14.33 32-32v-96C192 366.3 177.7 352 160 352zM176 480c0 8.822-7.178 16-16 16H32c-8.822 0-16-7.178-16-16v-96c0-8.822 7.178-16 16-16h128c8.822 0 16 7.178 16 16V480zM96 328c4.406 0 8-3.594 8-8V256c0-13.22 10.78-24 24-24h184V320c0 4.406 3.594 8 8 8s8-3.594 8-8V232H512c13.22 0 24 10.78 24 24v64c0 4.406 3.594 8 8 8s8-3.594 8-8V256c0-22.06-17.94-40-40-40h-184V160H384c17.67 0 32-14.33 32-32V32c0-17.67-14.33-32-32-32H256C238.3 0 224 14.33 224 32v96c0 17.67 14.33 32 32 32h56v56H128C105.9 216 88 233.9 88 256v64C88 324.4 91.59 328 96 328zM256 144C247.2 144 240 136.8 240 128V32c0-8.822 7.178-16 16-16h128c8.822 0 16 7.178 16 16v96c0 8.822-7.178 16-16 16H256z"
                                fill="currentColor"/></svg>
                    </span>
                <span>
                        Sites
                    </span>
            </a>

{{--            <a href="{{ route("vendor.pending_order_notification_from_manager") }}"--}}
{{--               class="@if(request()->routeIs("vendor.pending_order_notification_from_manager")) bg-primary-color @endif flex items-center space-x-4 pl-6 py-4 text-white text-sm hover:bg-primary-color">--}}
{{--                    <span class="relative">--}}
{{--                        <span class="bg-black text-white w-5 h-5 text-xs font-black flex items-center justify-center rounded-full absolute" style="font-size: 11px;top: -12px;right: -10px;">--}}
{{--                                {{ NewOrderProcessDetail::where('vendor_id',Auth::id())->whereIn('status',[NewOrderStatus::$MANAGER_PUSHED_TO_BLOGGER,NewOrderStatus::$MANAGER_DISAPPROVED_AND_PUSHED_BACK_TO_BLOGGER])->count() }}--}}
{{--                        </span>--}}

{{--                        <svg aria-hidden="true" focusable="false" data-prefix="fa-thin" data-icon="send-back"--}}
{{--                             class="w-5 h-5" role="img" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 640 512"><path--}}
{{--                                d="M296 112H416c26.51 0 48 21.49 48 48v56C464 220.4 467.6 224 472 224S480 220.4 480 216V160c0-35.35-28.65-64-64-64H296C291.6 96 288 99.58 288 104S291.6 112 296 112zM344 400H224c-26.51 0-48-21.49-48-48V296C176 291.6 172.4 288 168 288S160 291.6 160 296V352c0 35.35 28.65 64 64 64h120c4.418 0 8-3.582 8-8S348.4 400 344 400zM576 256h-128c-35.35 0-64 28.65-64 64v128c0 35.35 28.65 64 64 64h128c35.35 0 64-28.65 64-64v-128C640 284.7 611.3 256 576 256zM624 448c0 26.51-21.49 48-48 48h-128c-26.51 0-48-21.49-48-48v-128c0-26.51 21.49-48 48-48h128c26.51 0 48 21.49 48 48V448zM256 192V64c0-35.35-28.65-64-64-64H64C28.65 0 0 28.65 0 64v128c0 35.35 28.65 64 64 64h128C227.3 256 256 227.3 256 192zM16 192V64c0-26.51 21.49-48 48-48h128c26.51 0 48 21.49 48 48v128c0 26.51-21.49 48-48 48H64C37.49 240 16 218.5 16 192zM552 320h-80C458.8 320 448 330.8 448 344v80c0 13.23 10.78 24 24 24h80c13.22 0 24-10.77 24-24v-80C576 330.8 565.2 320 552 320zM560 424c0 4.406-3.594 8-8 8h-80c-4.406 0-8-3.594-8-8v-80c0-4.406 3.594-8 8-8h80c4.406 0 8 3.594 8 8V424zM192 88C192 74.77 181.2 64 168 64h-80C74.78 64 64 74.77 64 88v80C64 181.2 74.78 192 88 192h80C181.2 192 192 181.2 192 168V88zM176 168c0 4.406-3.594 8-8 8h-80C83.59 176 80 172.4 80 168v-80c0-4.406 3.594-8 8-8h80c4.406 0 8 3.594 8 8V168z"--}}
{{--                                fill="currentColor"/></svg>--}}
{{--                    </span>--}}
{{--                <span>--}}
{{--                        Pending Order Notifications--}}
{{--                    </span>--}}
{{--            </a>--}}

            <a href="{{ route("vendor.my_orders",["action"=>"completed"]) }}"
               class="@if(request()->routeIs("vendor.my_orders")) bg-primary-color @endif flex items-center space-x-4 pl-6 py-4 text-white text-sm hover:bg-primary-color">
                    <span class="relative">

                        <svg aria-hidden="true" focusable="false" data-prefix="fa-thin" data-icon="boxes-stacked"
                             class="w-5 h-5" role="img" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 576 512"><path
                                d="M224 288H32c-17.67 0-32 14.33-32 32v160c0 17.67 14.33 32 32 32h192c17.67 0 32-14.33 32-32v-160C256 302.3 241.7 288 224 288zM96 304h64v95.36l-27-21.61c-2.938-2.344-7.062-2.344-10 0L96 399.4V304zM240 480c0 8.822-7.176 16-16 16H32c-8.824 0-16-7.178-16-16v-160c0-8.822 7.176-16 16-16h48V416c0 3.078 1.75 5.875 4.531 7.203c2.719 1.328 6.062 .9687 8.469-.9531L128 394.3l35 28C164.4 423.4 166.2 424 168 424c1.188 0 2.375-.2656 3.469-.7969C174.3 421.9 176 419.1 176 416V304H224c8.824 0 16 7.178 16 16V480zM544 288h-192c-17.67 0-32 14.33-32 32v160c0 17.67 14.33 32 32 32h192c17.67 0 32-14.33 32-32v-160C576 302.3 561.7 288 544 288zM416 304h64v95.36l-27-21.61c-2.938-2.344-7.062-2.344-10 0L416 399.4V304zM560 480c0 8.822-7.176 16-16 16h-192c-8.824 0-16-7.178-16-16v-160c0-8.822 7.176-16 16-16h48V416c0 3.078 1.75 5.875 4.531 7.203c2.719 1.328 6.062 .9687 8.469-.9531l35-28l35 28C484.4 423.4 486.2 424 488 424c1.188 0 2.375-.2656 3.469-.7969C494.3 421.9 496 419.1 496 416V304H544c8.824 0 16 7.178 16 16V480zM192 224h192c17.67 0 32-14.33 32-32V32c0-17.67-14.33-32-32-32H192C174.3 0 160 14.33 160 32v160C160 209.7 174.3 224 192 224zM256 16h64v95.36l-27-21.61c-2.938-2.344-7.062-2.344-10 0L256 111.4V16zM176 32c0-8.822 7.176-16 16-16h48V128c0 3.078 1.75 5.875 4.531 7.203C247.3 136.5 250.6 136.2 253 134.3L288 106.3l35 28C324.4 135.4 326.2 136 328 136c1.188 0 2.375-.2656 3.469-.7969C334.3 133.9 336 131.1 336 128V16H384c8.824 0 16 7.178 16 16v160c0 8.822-7.176 16-16 16H192C183.2 208 176 200.8 176 192V32z"
                                fill="currentColor"/></svg>
                    </span>
                <span>
                        My Orders
                    </span>
            </a>

            <a href="{{ route("vendor.wallet_index") }}"
               class="@if(request()->routeIs("vendor.wallet_index")) bg-primary-color @endif flex items-center space-x-4 pl-6 py-4 text-white text-sm hover:bg-primary-color">
                    <span>
                        <svg aria-hidden="true" focusable="false" data-prefix="fa-thin" data-icon="wallet"
                             class="w-5 h-5" role="img" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512"><path
                                d="M440 112H72C67.59 112 64 115.6 64 120S67.59 128 72 128h368c30.88 0 56 25.12 56 56v224c0 30.88-25.12 56-56 56H72c-30.88 0-56-25.12-56-56v-304c0-30.88 25.12-56 56-56h400C476.4 48 480 44.41 480 40S476.4 32 472 32H72C32.31 32 0 64.31 0 104v304C0 447.7 32.31 480 72 480h368c39.69 0 72-32.31 72-72v-224C512 144.3 479.7 112 440 112zM440 296C440 273.9 422.1 256 400 256s-40 17.94-40 40s17.94 40 40 40S440 318.1 440 296zM376 296c0-13.22 10.78-24 24-24s24 10.78 24 24S413.2 320 400 320S376 309.2 376 296z"
                                fill="currentColor"/></svg>
                    </span>
                <span>
                        Wallet
                    </span>
            </a>

            <a href="{{ route("vendor.messages.create") }}"
               class="@if(request()->routeIs("vendor.messages.create")) bg-primary-color @endif flex items-center space-x-4 pl-6 py-4 text-white text-sm hover:bg-primary-color">
                    <span>
                        <svg aria-hidden="true" focusable="false" data-prefix="fa-thin" data-icon="comment-lines"
                             class="w-5 h-5" role="img" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512"><path
                                d="M256 31.1c-141.4 0-255.1 93.09-255.1 208c0 49.59 21.38 95.03 56.97 130.7c-12.5 50.39-54.27 95.27-54.77 95.77c-2.188 2.297-2.781 5.734-1.5 8.734c1.312 3 4.083 4.766 7.271 4.766c66.31 0 116-31.78 140.6-51.39c32.72 12.31 68.99 19.39 107.4 19.39c141.4 0 255.1-93.09 255.1-207.1S397.4 31.1 256 31.1zM255.1 431.1c-35.12 0-69.36-6.184-101.8-18.38l-8.508-3.201l-7.105 5.666c-20.2 16.11-60.14 42.04-112.7 47.06c14.44-18.29 37.42-51.68 46.57-88.59l2.172-8.758l-6.371-6.391C34.1 325.1 15.1 283.8 15.1 239.1c0-105.9 107.7-192 240-192s240 86.13 240 192S388.3 431.1 255.1 431.1zM375.1 183.1H135.1c-4.422 0-7.1 3.579-7.1 8.001s3.578 7.999 7.1 7.999h239.1c4.422 0 8-3.578 8-7.999S380.4 183.1 375.1 183.1zM279.1 279.1H135.1c-4.422 0-7.1 3.579-7.1 8.001s3.578 7.999 7.1 7.999h143.1c4.422 0 8-3.578 8-7.999S284.4 279.1 279.1 279.1z"
                                fill="currentColor"/></svg>
                    </span>
                <span>
                        Create new Ticket
                    </span>
            </a>

            <a href="{{ route("vendor.messages") }}"
               class="@if(request()->routeIs("vendor.messages")) bg-primary-color @endif flex items-center space-x-4 pl-6 py-4 text-white text-sm hover:bg-primary-color">
                    <span class="relative">
                        <span class="bg-black text-white w-5 h-5 text-xs font-black flex items-center justify-center rounded-full absolute" style="font-size: 11px;top: -12px;right: -10px;">
                            {{ \App\Models\Thread::where('owner_id', Auth::id())->orWhere('user_id',Auth::id())->with("last_updated")->withCount("messages")->orderBy('updated_at','desc')->count() }}
                        </span>
                        <svg aria-hidden="true" focusable="false" data-prefix="fa-thin" data-icon="comments"
                             class="w-5 h-5" role="img" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 640 512"><path
                                d="M416 176C416 78.8 322.9 0 208 0S0 78.8 0 176c0 39.57 15.62 75.96 41.67 105.4c-16.39 32.76-39.23 57.32-39.59 57.68c-2.1 2.205-2.67 5.475-1.441 8.354C1.9 350.3 4.602 352 7.66 352c38.35 0 70.76-11.12 95.74-24.04C134.2 343.1 169.8 352 208 352C322.9 352 416 273.2 416 176zM208 336c-34.14 0-67.86-7.742-97.51-22.39L103.2 310L96.05 313.7c-22.64 11.71-46.03 18.84-69.75 21.29c8.633-11.07 20.12-27.4 29.69-46.52l4.838-9.674L53.65 270.7C29.02 242.1 16 210.2 16 176c0-88.22 86.13-160 192-160s192 71.78 192 160S313.9 336 208 336zM599.6 443.7C624.8 413.9 640 376.6 640 336c0-89.54-72.1-163.3-167.4-174.4c-4.912-.5762-9.135 3.488-8.83 8.424c.2363 3.832 3.18 6.947 6.994 7.398C557.1 187.6 624 254.8 624 336c0 35.44-12.66 69.12-36.62 97.39l-6.918 8.168l4.91 9.512c9.25 17.92 20.15 33.37 28.38 43.96c-22.29-2.318-44.37-8.807-65.85-19.38l-7.174-3.529l-7.131 3.621C507.5 488.1 477.9 496 448 496c-73.58 0-136.6-41.33-162.8-99.74c-1.537-3.42-5.25-5.295-8.908-4.471l-.3594 .082c-4.859 1.096-7.426 6.369-5.389 10.91C299.2 466.8 367.8 512 448 512c33.69 0 65.32-8.008 92.85-21.98C565.2 502 596.1 512 632.3 512c3.059 0 5.76-1.725 7.02-4.605c1.229-2.879 .6582-6.148-1.441-8.354C637.6 498.7 615.9 475.3 599.6 443.7z"
                                fill="currentColor"/></svg>
                    </span>
                <span>
                        View Tickets
                    </span>
            </a>

            <a href="{{ route("vendor.payment_details") }}"
               class="@if(request()->routeIs("vendor.payment_details")) bg-primary-color @endif flex items-center space-x-4 pl-6 py-4 text-white text-sm hover:bg-primary-color">
                    <span class="relative">
                        <svg aria-hidden="true" focusable="false" data-prefix="fa-thin" data-icon="comments"
                             class="w-5 h-5" role="img" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 640 512"><path
                                d="M416 176C416 78.8 322.9 0 208 0S0 78.8 0 176c0 39.57 15.62 75.96 41.67 105.4c-16.39 32.76-39.23 57.32-39.59 57.68c-2.1 2.205-2.67 5.475-1.441 8.354C1.9 350.3 4.602 352 7.66 352c38.35 0 70.76-11.12 95.74-24.04C134.2 343.1 169.8 352 208 352C322.9 352 416 273.2 416 176zM208 336c-34.14 0-67.86-7.742-97.51-22.39L103.2 310L96.05 313.7c-22.64 11.71-46.03 18.84-69.75 21.29c8.633-11.07 20.12-27.4 29.69-46.52l4.838-9.674L53.65 270.7C29.02 242.1 16 210.2 16 176c0-88.22 86.13-160 192-160s192 71.78 192 160S313.9 336 208 336zM599.6 443.7C624.8 413.9 640 376.6 640 336c0-89.54-72.1-163.3-167.4-174.4c-4.912-.5762-9.135 3.488-8.83 8.424c.2363 3.832 3.18 6.947 6.994 7.398C557.1 187.6 624 254.8 624 336c0 35.44-12.66 69.12-36.62 97.39l-6.918 8.168l4.91 9.512c9.25 17.92 20.15 33.37 28.38 43.96c-22.29-2.318-44.37-8.807-65.85-19.38l-7.174-3.529l-7.131 3.621C507.5 488.1 477.9 496 448 496c-73.58 0-136.6-41.33-162.8-99.74c-1.537-3.42-5.25-5.295-8.908-4.471l-.3594 .082c-4.859 1.096-7.426 6.369-5.389 10.91C299.2 466.8 367.8 512 448 512c33.69 0 65.32-8.008 92.85-21.98C565.2 502 596.1 512 632.3 512c3.059 0 5.76-1.725 7.02-4.605c1.229-2.879 .6582-6.148-1.441-8.354C637.6 498.7 615.9 475.3 599.6 443.7z"
                                fill="currentColor"/></svg>
                    </span>
                <span>
                        Payment Details
                    </span>
            </a>


        </div>

    </div>
    <div id="right_menu" class="flex-1 pl-64">
        <div class="bg-[#275570] p-5 flex items-center justify-between">
            <div>
                <svg aria-hidden="true" focusable="false" id="menu" data-prefix="fa-solid" data-icon="bars-sort"
                     class="w-6 h-6 text-white cursor-pointer" role="img" xmlns="http://www.w3.org/2000/svg"
                     viewBox="0 0 448 512">
                    <path
                        d="M288 224H31.1C14.33 224 0 238.3 0 255.1S14.33 288 31.1 288h256C305.7 288 320 273.7 320 256S305.7 224 288 224zM160 384H31.1C14.33 384 0 398.3 0 415.1S14.33 448 31.1 448H160C177.7 448 192 433.7 192 416S177.7 384 160 384zM416 64H31.1C14.33 64 0 78.33 0 95.1S14.33 128 31.1 128h384C433.7 128 448 113.7 448 96S433.7 64 416 64z"
                        fill="currentColor"/>
                </svg>
            </div>
            <div class="relative" x-data="{open : false}" @click.outside="open= false">
                <div class="flex items-center space-x-3 cursor-pointer" @click="open = !open">
                    <div>
                        @if(Auth::user()->profile_image)
                            <img src="/uploads/{{ Auth::user()->profile_image }}"
                                 class="w-8 h-8 rounded-full border-2 border-white object-cover">
                        @else
                            <img src="/images/user.jpg" class="w-8 h-8 border-2 border-white object-cover"/>
                        @endif
                    </div>
                    <div class="text-white">
                        {{ auth()->user()->name }}
                    </div>
                    <div>
                        <svg aria-hidden="true" focusable="false" data-prefix="fa-solid" data-icon="angle-down"
                             class="w-4 h-4 text-white" role="img" xmlns="http://www.w3.org/2000/svg"
                             viewBox="0 0 384 512">
                            <path
                                d="M192 384c-8.188 0-16.38-3.125-22.62-9.375l-160-160c-12.5-12.5-12.5-32.75 0-45.25s32.75-12.5 45.25 0L192 306.8l137.4-137.4c12.5-12.5 32.75-12.5 45.25 0s12.5 32.75 0 45.25l-160 160C208.4 380.9 200.2 384 192 384z"
                                fill="currentColor"/>
                        </svg>
                    </div>
                </div>
                <div class="bg-white absolute w-full w-48 p-4 z-50 flex flex-col space-y-4 mt-2 right-0" x-show="open" x-transition
                     style="display: none">

                    <a href="{{ route("vendor.view_profile") }}" class="flex items-center space-x-4">
                        <x-usericon class="w-4 h-4 text-gray-700"/>
                        <span class="text-sm text-gray-700 font-semibold">Profile</span>
                    </a>
                    <a href="{{ route("change_password") }}">
                        <div class="flex items-center space-x-4">
                            <x-settings class="w-4 h-4 text-gray-700"/>
                            <span class="text-sm text-gray-700 font-semibold">Settings</span>
                        </div>
                    </a>
                    <form action="{{ route("logout") }}" method="post">
                        {!! csrf_field() !!}
                        <div class="flex items-center space-x-4 border-t border-gray-300 pt-3">
                            <x-logout class="w-4 h-4 text-gray-700"/>
                            <button type="submit" class="text-sm text-gray-700 font-semibold">Logout</button>
                        </div>
                    </form>


                </div>
            </div>
        </div>

        @if(!Auth::user()->country_id)
            <div class="bg-red-600 text-white text-xs p-4 flex items-center justify-between">
                <span>Please update your profile</span>
                <a class="underline font-bold" href="{{ route("vendor.profile") }}">complete profile</a>
            </div>
        @endif

        @yield("container")
        {{--            <div class="grid grid-cols-3 gap-8 max-w-6xl mx-auto mt-12">--}}

        {{--                <div class="bg-gradient-to-r from-sky-400 to-sky-500 p-8 rounded-lg relative">--}}
        {{--                    <div class="absolute top-0 -z-0">--}}

        {{--                        <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" width="394" height="320" viewBox="0 0 394 320">--}}
        {{--                            <defs>--}}
        {{--                                <linearGradient id="linear-gradient" x1="-0.151" y1="-0.049" x2="3.191" y2="0.793" gradientUnits="objectBoundingBox">--}}
        {{--                                    <stop offset="0" stop-color="#36d1dc"/>--}}
        {{--                                    <stop offset="1" stop-color="#5b86e5"/>--}}
        {{--                                </linearGradient>--}}
        {{--                                <clipPath id="clip-path">--}}
        {{--                                    <rect id="Rectangle_872" data-name="Rectangle 872" width="394" height="320" rx="30" transform="translate(104 160)" fill="url(#linear-gradient)"/>--}}
        {{--                                </clipPath>--}}
        {{--                            </defs>--}}
        {{--                            <g id="Mask_Group_13" data-name="Mask Group 13" transform="translate(-104 -160)" opacity="0.56" clip-path="url(#clip-path)">--}}
        {{--                                <g id="bg-image">--}}
        {{--                                    <circle id="Ellipse_549" data-name="Ellipse 549" cx="108" cy="108" r="108" transform="translate(344 104)" fill="#fff" opacity="0.16"/>--}}
        {{--                                    <circle id="Ellipse_550" data-name="Ellipse 550" cx="136" cy="136" r="136" transform="translate(264 240)" fill="#fff" opacity="0.16"/>--}}
        {{--                                </g>--}}
        {{--                            </g>--}}
        {{--                        </svg>--}}

        {{--                    </div>--}}
        {{--                    <a href="#" class="block relative z-50">--}}
        {{--                         <span class="flex flex-col items-start">--}}
        {{--                        <span class="bg-black/10 block w-14 h-14 flex items-center justify-center rounded-full">--}}
        {{--                            <svg aria-hidden="true" focusable="false" data-prefix="fa-thin" data-icon="sitemap" class="w-8 h-8 text-white" role="img" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 640 512"><path d="M384 352H256c-17.67 0-32 14.33-32 32v96c0 17.67 14.33 32 32 32h128c17.67 0 32-14.33 32-32v-96C416 366.3 401.7 352 384 352zM400 480c0 8.822-7.178 16-16 16H256c-8.822 0-16-7.178-16-16v-96c0-8.822 7.178-16 16-16h128c8.822 0 16 7.178 16 16V480zM608 352h-128c-17.67 0-32 14.33-32 32v96c0 17.67 14.33 32 32 32h128c17.67 0 32-14.33 32-32v-96C640 366.3 625.7 352 608 352zM624 480c0 8.822-7.178 16-16 16h-128c-8.822 0-16-7.178-16-16v-96c0-8.822 7.178-16 16-16h128c8.822 0 16 7.178 16 16V480zM160 352H32c-17.67 0-32 14.33-32 32v96c0 17.67 14.33 32 32 32h128c17.67 0 32-14.33 32-32v-96C192 366.3 177.7 352 160 352zM176 480c0 8.822-7.178 16-16 16H32c-8.822 0-16-7.178-16-16v-96c0-8.822 7.178-16 16-16h128c8.822 0 16 7.178 16 16V480zM96 328c4.406 0 8-3.594 8-8V256c0-13.22 10.78-24 24-24h184V320c0 4.406 3.594 8 8 8s8-3.594 8-8V232H512c13.22 0 24 10.78 24 24v64c0 4.406 3.594 8 8 8s8-3.594 8-8V256c0-22.06-17.94-40-40-40h-184V160H384c17.67 0 32-14.33 32-32V32c0-17.67-14.33-32-32-32H256C238.3 0 224 14.33 224 32v96c0 17.67 14.33 32 32 32h56v56H128C105.9 216 88 233.9 88 256v64C88 324.4 91.59 328 96 328zM256 144C247.2 144 240 136.8 240 128V32c0-8.822 7.178-16 16-16h128c8.822 0 16 7.178 16 16v96c0 8.822-7.178 16-16 16H256z" fill="currentColor"/></svg>--}}
        {{--                        </span>--}}
        {{--                       <span class="text-2xl text-white my-4">--}}
        {{--                        Total Sites--}}
        {{--                        </span>--}}
        {{--                       <span class="font-bold text-6xl text-white">12</span>--}}
        {{--                   </span>--}}
        {{--                    </a>--}}
        {{--                </div>--}}

        {{--                <div class="bg-gradient-to-r from-orange-400 to-orange-500 p-8 rounded-lg relative">--}}
        {{--                    <div class="absolute top-0 -z-0">--}}

        {{--                        <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" width="394" height="320" viewBox="0 0 394 320">--}}
        {{--                            <defs>--}}
        {{--                                <linearGradient id="linear-gradient" x1="-0.151" y1="-0.049" x2="3.191" y2="0.793" gradientUnits="objectBoundingBox">--}}
        {{--                                    <stop offset="0" stop-color="#36d1dc"/>--}}
        {{--                                    <stop offset="1" stop-color="#5b86e5"/>--}}
        {{--                                </linearGradient>--}}
        {{--                                <clipPath id="clip-path">--}}
        {{--                                    <rect id="Rectangle_872" data-name="Rectangle 872" width="394" height="320" rx="30" transform="translate(104 160)" fill="url(#linear-gradient)"/>--}}
        {{--                                </clipPath>--}}
        {{--                            </defs>--}}
        {{--                            <g id="Mask_Group_13" data-name="Mask Group 13" transform="translate(-104 -160)" opacity="0.56" clip-path="url(#clip-path)">--}}
        {{--                                <g id="bg-image">--}}
        {{--                                    <circle id="Ellipse_549" data-name="Ellipse 549" cx="108" cy="108" r="108" transform="translate(344 104)" fill="#fff" opacity="0.16"/>--}}
        {{--                                    <circle id="Ellipse_550" data-name="Ellipse 550" cx="136" cy="136" r="136" transform="translate(264 240)" fill="#fff" opacity="0.16"/>--}}
        {{--                                </g>--}}
        {{--                            </g>--}}
        {{--                        </svg>--}}

        {{--                    </div>--}}
        {{--                    <a href="#" class="block relative z-50">--}}
        {{--                         <span class="flex flex-col items-start">--}}
        {{--                        <span class="bg-black/10 block w-14 h-14 flex items-center justify-center rounded-full">--}}
        {{--                            <svg aria-hidden="true" focusable="false" data-prefix="fa-thin" data-icon="wallet" class="w-8 h-8 text-white" role="img" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512"><path d="M440 112H72C67.59 112 64 115.6 64 120S67.59 128 72 128h368c30.88 0 56 25.12 56 56v224c0 30.88-25.12 56-56 56H72c-30.88 0-56-25.12-56-56v-304c0-30.88 25.12-56 56-56h400C476.4 48 480 44.41 480 40S476.4 32 472 32H72C32.31 32 0 64.31 0 104v304C0 447.7 32.31 480 72 480h368c39.69 0 72-32.31 72-72v-224C512 144.3 479.7 112 440 112zM440 296C440 273.9 422.1 256 400 256s-40 17.94-40 40s17.94 40 40 40S440 318.1 440 296zM376 296c0-13.22 10.78-24 24-24s24 10.78 24 24S413.2 320 400 320S376 309.2 376 296z" fill="currentColor"/></svg>--}}
        {{--                        </span>--}}
        {{--                       <span class="text-2xl text-white my-4">--}}
        {{--                        Wallet--}}
        {{--                        </span>--}}
        {{--                       <span class="font-bold text-6xl text-white">$45</span>--}}
        {{--                   </span>--}}
        {{--                    </a>--}}
        {{--                </div>--}}

        {{--                <div class="bg-gradient-to-r from-green-600 to-green-700 p-8 rounded-lg relative">--}}
        {{--                    <div class="absolute top-0 -z-0">--}}

        {{--                        <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" width="394" height="320" viewBox="0 0 394 320">--}}
        {{--                            <defs>--}}
        {{--                                <linearGradient id="linear-gradient" x1="-0.151" y1="-0.049" x2="3.191" y2="0.793" gradientUnits="objectBoundingBox">--}}
        {{--                                    <stop offset="0" stop-color="#36d1dc"/>--}}
        {{--                                    <stop offset="1" stop-color="#5b86e5"/>--}}
        {{--                                </linearGradient>--}}
        {{--                                <clipPath id="clip-path">--}}
        {{--                                    <rect id="Rectangle_872" data-name="Rectangle 872" width="394" height="320" rx="30" transform="translate(104 160)" fill="url(#linear-gradient)"/>--}}
        {{--                                </clipPath>--}}
        {{--                            </defs>--}}
        {{--                            <g id="Mask_Group_13" data-name="Mask Group 13" transform="translate(-104 -160)" opacity="0.56" clip-path="url(#clip-path)">--}}
        {{--                                <g id="bg-image">--}}
        {{--                                    <circle id="Ellipse_549" data-name="Ellipse 549" cx="108" cy="108" r="108" transform="translate(344 104)" fill="#fff" opacity="0.16"/>--}}
        {{--                                    <circle id="Ellipse_550" data-name="Ellipse 550" cx="136" cy="136" r="136" transform="translate(264 240)" fill="#fff" opacity="0.16"/>--}}
        {{--                                </g>--}}
        {{--                            </g>--}}
        {{--                        </svg>--}}

        {{--                    </div>--}}
        {{--                    <a href="#" class="block relative z-50">--}}
        {{--                         <span class="flex flex-col items-start">--}}
        {{--                        <span class="bg-black/10 block w-14 h-14 flex items-center justify-center rounded-full">--}}
        {{--                            <svg aria-hidden="true" focusable="false" data-prefix="fa-thin" data-icon="globe" class="w-8 h-8 text-white" role="img" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512"><path d="M256 16C123.5 16 16 123.5 16 256s107.5 240 240 240s239.1-107.5 239.1-240S388.5 16 256 16zM464.1 176h-103.5c-10.3-62.32-32.19-112.8-60.2-139.4C376.6 52.13 437.9 105.6 464.1 176zM352 256c0 22.63-1.578 43.98-4.274 64H164.3C161.6 299.1 160 278.6 160 256s1.578-43.98 4.273-64h183.5C350.4 212 352 233.4 352 256zM256 480c-35.5 0-74.05-56.38-89.24-144h178.5C330.1 423.6 291.5 480 256 480zM166.8 176C181.9 88.38 220.5 32 256 32s74.06 56.38 89.24 144H166.8zM210.7 36.61C182.7 63.21 160.8 113.7 150.5 176H47.02C74.07 105.6 135.4 52.13 210.7 36.61zM41.43 192h106.7C145.5 212.4 144 233.8 144 256s1.516 43.6 4.148 64H41.43C35.37 299.7 32 278.2 32 256S35.37 212.3 41.43 192zM47.02 336h103.5c10.3 62.32 32.19 112.8 60.2 139.4C135.4 459.9 74.07 406.4 47.02 336zM301.3 475.4c28.01-26.6 49.9-77.07 60.2-139.4h103.5C437.9 406.4 376.6 459.9 301.3 475.4zM470.6 320h-106.7C366.5 299.6 368 278.2 368 256s-1.516-43.6-4.148-64h106.7C476.6 212.3 480 233.8 480 256S476.6 299.7 470.6 320z" fill="currentColor"/></svg>--}}
        {{--                        </span>--}}
        {{--                       <span class="text-2xl text-white my-4">--}}
        {{--                        Total Sites--}}
        {{--                        </span>--}}
        {{--                       <span class="font-bold text-6xl text-white">20</span>--}}
        {{--                   </span>--}}
        {{--                    </a>--}}
        {{--                </div>--}}


        {{--            </div>--}}


    </div>
</div>
@livewireScripts

@yield("footer")
@stack("scripts")
<script>
    tippy('[data-tippy-content]');
</script>
<script>
    $(function () {
        $('#menu').on("click", function () {
            if ($('#left_menu').hasClass('w-64')) {
                $('#left_menu').removeClass('w-64').addClass('w-0');
                $('#right_menu').removeClass('pl-64').addClass('pl-0');
            } else {
                $('#left_menu').addClass('w-64').removeClass('w-0');
                $('#right_menu').addClass('pl-64').removeClass('pl-0');
            }
        });
    });
</script>
</body>
</html>
