<div>
    <form method="POST" wire:submit.prevent="step3">
        <div class="grid grid-cols-2 gap-6 mt-8">
            @csrf

        <div class="col-span-2">
            <h2 class="text-indigo-700">Domain Information</h2>
        </div>


{{--        <div>--}}

{{--            <div class="flex items-center">--}}
{{--                <label class="label-h-class w-2/5 text-right pr-8">Your Association with Site</label>--}}
{{--                <select autofocus class="select-h-class focus:ring-blue-500 focus:border-blue-500" wire:model.defer="association_type">--}}
{{--                    <option value="">Select</option>--}}
{{--                    <option value="Publisher">Publisher</option>--}}
{{--                    <option value="Owner">Owner</option>--}}
{{--                </select>--}}
{{--            </div>--}}
{{--            @error('association_type')--}}
{{--                <div class="text-right mt-1 text-red-400 text-xs">{{ $message }}</div>--}}
{{--            @enderror--}}
{{--        </div>--}}

{{--        <div>--}}
{{--            <div class="flex items-center">--}}
{{--                <label class="label-h-class w-2/5 text-right pr-8">Domain Type</label>--}}
{{--                <select class="select-h-class focus:ring-blue-500 focus:border-blue-500" wire:model.defer="domain_type">--}}
{{--                    <option value="">Select</option>--}}
{{--                    <option value="http://www.">http://www.</option>--}}
{{--                    <option value="https://www.">https://www.</option>--}}
{{--                    <option value="http://">http://</option>--}}
{{--                    <option value="https://">http://</option>--}}
{{--                </select>--}}
{{--            </div>--}}
{{--            @error('domain_type')--}}
{{--             <div class="text-right mt-1 text-red-400 text-xs">{{ $message }}</div>--}}
{{--            @enderror--}}
{{--        </div>--}}


        <div>
            <div class="flex items-center">
                <label class="label-h-class w-2/5 text-right pr-8 flex items-center justify-end space-x-1">
                    <span>Root Domain</span>
                    <svg xmlns="http://www.w3.org/2000/svg" data-tippy-content="Tooltip" viewBox="0 0 24 24" fill="currentColor" class="w-4 h-4 text-black">
                        <path fill-rule="evenodd" d="M2.25 12c0-5.385 4.365-9.75 9.75-9.75s9.75 4.365 9.75 9.75-4.365 9.75-9.75 9.75S2.25 17.385 2.25 12zm11.378-3.917c-.89-.777-2.366-.777-3.255 0a.75.75 0 01-.988-1.129c1.454-1.272 3.776-1.272 5.23 0 1.513 1.324 1.513 3.518 0 4.842a3.75 3.75 0 01-.837.552c-.676.328-1.028.774-1.028 1.152v.75a.75.75 0 01-1.5 0v-.75c0-1.279 1.06-2.107 1.875-2.502.182-.088.351-.199.503-.331.83-.727.83-1.857 0-2.584zM12 18a.75.75 0 100-1.5.75.75 0 000 1.5z" clip-rule="evenodd" />
                    </svg>

                </label>

                <input type="text" class="textbox-class focus:ring-blue-500 focus:border-blue-500" wire:model.defer="root_domain" >
            </div>
            @error('root_domain')
            <div class="text-right mt-1 text-red-400 text-xs">{{ $message }}</div>
            @enderror
        </div>


{{--        <div>--}}
{{--            <div class="flex items-center">--}}
{{--                <label class="label-h-class w-2/5 text-right pr-8">Select Niche</label>--}}
{{--                <select class="select-h-class focus:ring-blue-500 focus:border-blue-500" wire:model.defer="niche">--}}
{{--                    <option value="">Select</option>--}}
{{--                    <option value="Specific Niche">Specific Niche</option>--}}
{{--                    <option value="Multi Niche">Multi Niche</option>--}}
{{--                </select>--}}
{{--            </div>--}}
{{--            @error('niche')--}}
{{--            <div class="text-right mt-1 text-red-400 text-xs">{{ $message }}</div>--}}
{{--            @enderror--}}
{{--        </div>--}}

        <div>
            <div >
                <div wire:ignore class="flex-1">
                    <div class="flex items-center">
                    <label class="label-h-class w-2/5 text-right pr-8">Select Category</label>
                    <select class="select-h-class block mt-1 w-full focus:ring-blue-500 focus:border-blue-500 rounded-md cursor-pointer focus:outline-none"
                            multiple id="category_chosen">
                        <option value="">Select</option>
                        @foreach(App\Harman\Helpers\CategoriesList::show() as $show)
                            <option
                                @if(in_array(trim($show),explode("linkmanagement",$category))) selected @endif
                                value="{{ $show }}">{{ $show }}</option>
                        @endforeach
                    </select>
                    </div>
                </div>
                @error('category')
                    <div class="text-right mt-1 text-red-400 text-xs">{{ $message }}</div>
                @enderror
            </div>
        </div>

        <div >
            <div wire:ignore >
                <div class="flex items-center">
                    <label class="label-h-class w-2/5 text-right pr-8">Traffic Source</label>
                    <select id="country_chosen" class="select-h-class block focus:ring-blue-500 focus:border-blue-500 mt-1 w-full rounded-md cursor-pointer focus:outline-none" name="traffic_source[]" multiple>
                    <option value="">Select</option>
                    @foreach(App\Harman\Helpers\CountriesList::show() as $show)
                        <option value="{{ $show }}">{{ $show }}</option>
                    @endforeach
                </select>
                </div>
                @error('traffic_source')
                <div class="text-right mt-1 text-red-400 text-xs">{{ $message }}</div>
                @enderror
            </div>
            @error('traffic_source')
            <div class="text-right mt-1 text-red-400 text-xs">{{ $message }}</div>
            @enderror
        </div>

        <div>
            <div class="flex items-center">
                <label class="label-h-class w-2/5 text-right pr-8">Spam Score(optional)</label>
                <input type="number" class="textbox-class focus:ring-blue-500 focus:border-blue-500" wire:model.defer="spam_score" >
            </div>
            @error('spam_score')
            <div class="text-right mt-1 text-red-400 text-xs">{{ $message }}</div>
            @enderror
        </div>




        <div>
            <div class="flex items-center">
                <label class="label-h-class w-2/5 text-right pr-8 flex items-center justify-end space-x-1">
                    <span>Sample URL</span>
                    <svg xmlns="http://www.w3.org/2000/svg" data-tippy-content="Tooltip" viewBox="0 0 24 24" fill="currentColor" class="w-4 h-4 text-black">
                        <path fill-rule="evenodd" d="M2.25 12c0-5.385 4.365-9.75 9.75-9.75s9.75 4.365 9.75 9.75-4.365 9.75-9.75 9.75S2.25 17.385 2.25 12zm11.378-3.917c-.89-.777-2.366-.777-3.255 0a.75.75 0 01-.988-1.129c1.454-1.272 3.776-1.272 5.23 0 1.513 1.324 1.513 3.518 0 4.842a3.75 3.75 0 01-.837.552c-.676.328-1.028.774-1.028 1.152v.75a.75.75 0 01-1.5 0v-.75c0-1.279 1.06-2.107 1.875-2.502.182-.088.351-.199.503-.331.83-.727.83-1.857 0-2.584zM12 18a.75.75 0 100-1.5.75.75 0 000 1.5z" clip-rule="evenodd" />
                    </svg>

                </label>
                <input type="url" class="textbox-class focus:ring-blue-500 focus:border-blue-500" wire:model.defer="sample_url" >
            </div>
            @error('sample_url')
                <div class="text-right mt-1 text-red-400 text-xs">{{ $message }}</div>
            @enderror
        </div>

            <div>
                <div class="flex items-center">
                    <label class="label-h-class w-2/5 text-right pr-8">Total Time</label>
                    <select class="textbox-class focus:ring-blue-500 focus:border-blue-500" wire:model.defer="total_time">
                        <option value="">Select</option>
                        <option value="24">24 Hrs</option>
                        <option value="48">48 Hrs</option>
                        <option value="72">72 Hrs</option>
                    </select>
{{--                    <input type="text" class="textbox-class focus:ring-blue-500 focus:border-blue-500" wire:model.defer="total_time" >--}}
                </div>
                @error('total_time')
                <div class="text-right mt-1 text-red-400 text-xs">{{ $message }}</div>
                @enderror
            </div>



            <div class="col-span-2 mt-8">
                <h2 class="text-indigo-700">Link Information</h2>
            </div>

                <div>
                    <div class="flex items-center">
                        <label class="label-h-class w-2/5 text-right pr-8">Marked Sponsor</label>
                        <select class="select-h-class focus:ring-blue-500 focus:border-blue-500" wire:model.defer="marked_sponsor">
                            <option value="">Select</option>
                            <option value="Yes">Yes</option>
                            <option value="No">No</option>
                        </select>
                    </div>
                    @error('marked_sponsor')
                        <div class="text-right mt-1 text-red-400 text-xs">{{ $message }}</div>
                    @enderror
                </div>
{{--                <div>--}}
{{--                    <div class="flex items-center">--}}
{{--                        <label class="label-h-class w-2/5 text-right pr-8">Link Type</label>--}}
{{--                        <select class="select-h-class focus:ring-blue-500 focus:border-blue-500" wire:model.defer="link_type">--}}
{{--                            <option value="">Select</option>--}}
{{--                            <option value="NoFollow">NoFollow</option>--}}
{{--                            <option value="DoFollow">DoFollow</option>--}}
{{--                        </select>--}}
{{--                    </div>--}}
{{--                    @error('link_type')--}}
{{--                    <div class="text-right mt-1 text-red-400 text-xs">{{ $message }}</div>--}}
{{--                    @enderror--}}
{{--                </div>--}}


{{--                <div>--}}
{{--                    <div class="flex items-center">--}}
{{--                        <label class="label-h-class w-2/5 text-right pr-8">Link Validity</label>--}}
{{--                        <select class="select-h-class focus:ring-blue-500 focus:border-blue-500" wire:model.defer="link_validity">--}}
{{--                            <option value="">Select</option>--}}
{{--                            <option value="Permanent">Permanent</option>--}}
{{--                            <option value="6 Months">6 Months</option>--}}
{{--                            <option value="12 Months">12 Months</option>--}}
{{--                        </select>--}}
{{--                    </div>--}}
{{--                    @error('link_validity')--}}
{{--                    <div class="text-right mt-1 text-red-400 text-xs">{{ $message }}</div>--}}
{{--                    @enderror--}}
{{--                </div>--}}


                <div>
                    <div class="flex items-center">
                        <label class="label-h-class w-2/5 text-right pr-8">Do you accept grey niche</label>
                        <select class="select-h-class focus:ring-blue-500 focus:border-blue-500" wire:model="accept_grey_niche">
                            <option value="">Select</option>
                            <option value="Yes">Yes</option>
                            <option value="No">No</option>
                        </select>
                    </div>
                    @error('accept_grey_niche')
                        <div class="text-right mt-1 text-red-400 text-xs">{{ $message }}</div>
                    @enderror

                    @if($accept_grey_niche == 'Yes')
                    <div class="flex items-center space-x-4 justify-end mt-3 " >
                        <label class="flex items-center space-x-2">
                            <input type="checkbox" wire:model="grey_niche_types" value="Adult">
                            <span>Adult</span>
                        </label>
                        <label class="flex items-center space-x-2">
                            <input type="checkbox" wire:model="grey_niche_types" value="CBD">
                            <span>CBD</span>
                        </label>
                        <label class="flex items-center space-x-2">
                            <input type="checkbox" wire:model="grey_niche_types" value="Gaming">
                            <span>Gaming</span>
                        </label>
                        <label class="flex items-center space-x-2">
                            <input type="checkbox" wire:model="grey_niche_types" value="Gambling">
                            <span>Gambling</span>
                        </label>
                        <label class="flex items-center space-x-2">
                            <input type="checkbox" wire:model="grey_niche_types" value="Vaping">
                            <span>Vaping</span>
                        </label>
                    </div>
                    @endif
                </div>



            <div class="col-span-2 mt-8">
                <h2 class="text-indigo-700">Seo Metrics</h2>
            </div>

                <div>
                    <div class="flex items-center">
                        <label class="label-h-class w-2/5 text-right pr-8">DA</label>
                        <input type="number" class="textbox-class focus:ring-blue-500 focus:border-blue-500" wire:model.lazy="da">
                    </div>
                    @error('da')
                        <div class="text-right mt-1 text-red-400 text-xs">{{ $message }}</div>
                    @enderror
                </div>

                <div>
                    <div class="flex items-center">
                        <label class="label-h-class w-2/5 text-right pr-8">DR</label>
                        <input type="number" class="textbox-class focus:ring-blue-500 focus:border-blue-500" wire:model.lazy="dr">
                    </div>
                    @error('dr')
                    <div class="text-right mt-1 text-red-400 text-xs">{{ $message }}</div>
                    @enderror
                </div>


                <div>
                    <div class="flex items-center">
                        <label class="label-h-class w-2/5 text-right pr-8">Traffic</label>
                        <input type="number" class="textbox-class focus:ring-blue-500 focus:border-blue-500" wire:model.lazy="traffic">
                    </div>
                    @error('traffic')
                    <div class="text-right mt-1 text-red-400 text-xs">{{ $message }}</div>
                    @enderror
                </div>
                <div>
                    <div class="flex items-center">
                        <label class="label-h-class w-2/5 text-right pr-8">GP Price (USD)</label>
                        <input type="number" class="textbox-class focus:ring-blue-500 focus:border-blue-500" wire:model.lazy="gp_price">
                    </div>
                    @error('gp_price')
                    <div id="gp_server_error" class="text-right mt-1 text-red-400 text-xs">{{ $message }}</div>
                    @enderror
                </div>

                <div>
                    <div class="flex items-center">
                        <label class="label-h-class w-2/5 text-right pr-8">RD</label>
                        <input type="number" class="textbox-class focus:ring-blue-500 focus:border-blue-500" wire:model.lazy="rd">
                    </div>
                    @error('rd')
                    <div class="text-right mt-1 text-red-400 text-xs">{{ $message }}</div>
                    @enderror
                </div>

                <div>
                    <div class="flex items-center">
                        <label class="label-h-class w-2/5 text-right pr-8">Niche Edit Price (USD)</label>
                        <input type="number" class="textbox-class focus:ring-blue-500 focus:border-blue-500" wire:model.lazy="niche_edit_price">
                    </div>
                    @error('niche_edit_price')
                    <div id="niche_server_error" class="text-right mt-1 text-red-400 text-xs">{{ $message }}</div>
                    @enderror
                </div>



            <div>

                <div>
                    <div>
                        <div class="flex items-center">
                            <label class="label-h-class w-2/5 text-right pr-8">FC GP</label>
                            <input type="number" class="textbox-class focus:ring-blue-500 focus:border-blue-500" wire:model.lazy="fc_gp">
                        </div>
                        @error('fc_gp')
                            <div id="niche_server_error" class="text-right mt-1 text-red-400 text-xs">{{ $message }}</div>
                        @enderror
                    </div>
                </div>
            </div>


                <div>
                    <div>
                        <div class="flex items-center">
                            <label class="label-h-class w-2/5 text-right pr-8">FC NE</label>
                            <input type="number" class="textbox-class focus:ring-blue-500 focus:border-blue-500" wire:model.lazy="fc_ne">
                        </div>
                        @error('fc_ne')
                        <div id="niche_server_error" class="text-right mt-1 text-red-400 text-xs">{{ $message }}</div>
                        @enderror
                    </div>
                </div>


            <div></div>
            <div class="flex justify-end mt-8 items-end">
                <button type="submit" class="bg-gray-800 text-white text-lg rounded px-4 py-2">Save & Continue to Next Step</button>
            </div>


        </div>
    </form>





</div>

@push("scripts")
    <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.6.0/jquery.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/chosen/1.8.7/chosen.jquery.min.js" integrity="sha512-rMGGF4wg1R73ehtnxXBt5mbUfN9JUJwbk21KMlnLZDJh7BkPmeovBuddZCENJddHYYMkCh9hPFnPmS9sspki8g==" crossorigin="anonymous" referrerpolicy="no-referrer"></script>
    <script>
        var selected_options = [];
        $('select#category_chosen').on("chosen:ready",function () {
            console.log("Ready");
        });
        $('select#category_chosen').chosen();
        $('select#country_chosen').chosen();
        $('.chosen-container.chosen-container-multi').css('width','100%');

        $('select#category_chosen').on("change",function (evt,params) {
           values = $('select#category_chosen').chosen().val();
           @this.set("category",values.join(","));
        });

        $('select#country_chosen').on("change",function (evt,params) {
            values = $('select#country_chosen').chosen().val();
            @this.set("traffic_source",values.join(","));
        });

    </script>
@endpush


@push("styles")
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/chosen/1.8.7/chosen.min.css" integrity="sha512-yVvxUQV0QESBt1SyZbNJMAwyKvFTLMyXSyBHDO4BG5t7k/Lw34tyqlSDlKIrIENIzCl+RVUNjmCPG+V/GMesRw==" crossorigin="anonymous" referrerpolicy="no-referrer" />
    <style>
        .chosen-choices{
            border-color: #e2e2e2!important;
            border-radius: 0.3rem!important;
            padding: 6px 10px!important;
            background-image: none!important;
            margin-top: 3px!important;
            margin-top: 0.25rem!important;
            display: block!important;
            width: 100%!important;
            border-radius: 0.375rem;
            --tw-border-opacity: 1!important;
            border-color: rgb(209 213 219 / var(--tw-border-opacity))!important;
            padding-top: 0.3rem!important;
            padding-bottom: 0.3rem!important;
            padding-left: 0.75rem!important;
            padding-right: 2.5rem!important;
        }
        .search-choice{

        }

    </style>
@endpush
