@php use App\Project\NewOrderStatus; @endphp
<div class="bg-white shadow m-4 p-4">
    <div class="overflow-x-auto">
         <table class="table-auto w-full table-bordered whitespace-nowrap">
            <thead class="bg-gray-200">
                <tr>
                    <th class="p-3 text-sm font-semibold border border-white w-24">
                        <div class="flex items-center space-x-2">
                            <input type="search" wire:model.debounce.150ms="order_id" placeholder="Order Id" class="text-xs text-gray-700 border-0">
                            <svg wire:click="sortOperations('order_id')" xmlns="http://www.w3.org/2000/svg" height="1em" viewBox="0 0 320 512" class="w-4 h-4 text-black"><!--! Font Awesome Free 6.4.0 by @fontawesome - https://fontawesome.com License - https://fontawesome.com/license (Commercial License) Copyright 2023 Fonticons, Inc. --><path d="M137.4 41.4c12.5-12.5 32.8-12.5 45.3 0l128 128c9.2 9.2 11.9 22.9 6.9 34.9s-16.6 19.8-29.6 19.8H32c-12.9 0-24.6-7.8-29.6-19.8s-2.2-25.7 6.9-34.9l128-128zm0 429.3l-128-128c-9.2-9.2-11.9-22.9-6.9-34.9s16.6-19.8 29.6-19.8H288c12.9 0 24.6 7.8 29.6 19.8s2.2 25.7-6.9 34.9l-128 128c-12.5 12.5-32.8 12.5-45.3 0z" fill="currentColor"/></svg>
                        </div>
                    </th>
                    <th class="p-3 text-sm font-semibold border border-white">
                        <div class="flex items-center justify-center space-x-2">
                            <input type="search" wire:model.debounce.150ms="client_name" placeholder="Client Name" class="text-xs text-gray-700 border-0">
                            <svg wire:click="sortOperations('client_name')" xmlns="http://www.w3.org/2000/svg" height="1em" viewBox="0 0 320 512" class="w-4 h-4 text-black"><!--! Font Awesome Free 6.4.0 by @fontawesome - https://fontawesome.com License - https://fontawesome.com/license (Commercial License) Copyright 2023 Fonticons, Inc. --><path d="M137.4 41.4c12.5-12.5 32.8-12.5 45.3 0l128 128c9.2 9.2 11.9 22.9 6.9 34.9s-16.6 19.8-29.6 19.8H32c-12.9 0-24.6-7.8-29.6-19.8s-2.2-25.7 6.9-34.9l128-128zm0 429.3l-128-128c-9.2-9.2-11.9-22.9-6.9-34.9s16.6-19.8 29.6-19.8H288c12.9 0 24.6 7.8 29.6 19.8s2.2 25.7-6.9 34.9l-128 128c-12.5 12.5-32.8 12.5-45.3 0z" fill="currentColor"/></svg>
                        </div>
                    </th>
                    <th class="p-3 text-sm font-semibold border border-white">
                        <select wire:model="status" class="text-xs text-black">
                            <option value="all">All</option>
                            <option value="completed">Completed</option>
                            <option value="in_process">In Process</option>
                            <option value="pending">Pending</option>
                            <option value="manager">Manager</option>
                            <option value="team">Team</option>
                            <option value="writer">Writer</option>
                            <option value="blogger">Blogger</option>
                        </select>
                    </th>
                    <th class="p-3 text-sm font-semibold border border-white">
                        <div class="flex items-center justify-center space-x-2">
                            <span>Ordered At</span>
                            <svg wire:click="sortOperations('created_at')" xmlns="http://www.w3.org/2000/svg" height="1em" viewBox="0 0 320 512" class="w-4 h-4 text-black"><!--! Font Awesome Free 6.4.0 by @fontawesome - https://fontawesome.com License - https://fontawesome.com/license (Commercial License) Copyright 2023 Fonticons, Inc. --><path d="M137.4 41.4c12.5-12.5 32.8-12.5 45.3 0l128 128c9.2 9.2 11.9 22.9 6.9 34.9s-16.6 19.8-29.6 19.8H32c-12.9 0-24.6-7.8-29.6-19.8s-2.2-25.7 6.9-34.9l128-128zm0 429.3l-128-128c-9.2-9.2-11.9-22.9-6.9-34.9s16.6-19.8 29.6-19.8H288c12.9 0 24.6 7.8 29.6 19.8s2.2 25.7-6.9 34.9l-128 128c-12.5 12.5-32.8 12.5-45.3 0z" fill="currentColor"/></svg>
                        </div>
                    </th>
                    <th class="p-3 text-sm font-semibold border border-white">Edit</th>
                    <th class="p-3 text-sm font-semibold border border-white">Delete</th>
                </tr>
            </thead>

             <tbody>
                @foreach($orders as $order)
                    <tr>
                        <td class="p-3 text-xs text-center font-medium border border-gray-200">
                            <a style="text-decoration: underline" class="flex items-center justify-between"  href="{{ route("manager.search_order",["order"=>$order->order_id,"type"=>$order->type]) }}">
                                <span>
                                    @if($order->type == 'new') New Order @endif
                                    @if($order->type == 'sub') Sub Order @endif
                                </span>
                                <span>{{ $order->order_id }}</span>

                            </a>
                        </td>
                        <td class="p-3 text-xs text-center font-medium border border-gray-200">{{ $order->client_name }}</td>
                        <td class="p-3 text-xs text-center font-medium border border-gray-200">

                          <div class="flex items-center justify-between ">
                              @if(($order->total == $order->total1) && $order->total != 0 && $order->total1 !=0 )
                                  <span style="background: green;color: white;padding:6px"> Completed</span>
                              @elseif( ( $order->new_order_status == NewOrderStatus::$PENDING_ORDER ) || ($order->new_order_status == NewOrderStatus::$MANAGER_CREATED_ORDER_AND_PUSHED_TO_TEAM) )
                                  <span style="background: red;color: white;padding:6px">Pending</span>
                              @else
                                  <span style="background: blue;color: white;padding:6px">In Process</span>
                              @endif
                              <div>
                                  {{ new_order_status($order->new_order_status) }}
                              </div>
                          </div>
                        </td>
                        <td class="p-3 text-xs text-center font-medium border border-gray-200">{{ Carbon\Carbon::parse($order->created_at)->toDateTimeString() }}</td>
                        <td class="p-3 text-xs text-center font-medium border border-gray-200">
                            <a href="{{ route("manager.view_order_edit",$order->order_id)  }}" class="bg-blue-500 text-xs text-white px-3 py-1 rounded">Edit</a>
                        </td>
                        <td class="p-3 text-xs text-center font-medium border border-gray-200">
                            <a href="{{ route("manager.view_order_delete_confirm",$order->id) }}" class="bg-red-500 text-xs text-white px-3 py-1 rounded">Delete</a>
                        </td>
                    </tr>
                @endforeach
             </tbody>
         </table>
    </div>
    <div>
        {{ $orders->links() }}
    </div>
</div>
