<div class="w-full">
    <table class="table-fixed w-full">
        <thead class="bg-slate-700">
            <tr>
                <th class="break-words px-2 py-4 text-xs border border-gray-200 text-white bg-slate-700 z-50 sticky left-0 top-0 ">
                    <div class="flex items-center space-x-2">
                        <input type="search" wire:model.debounce.150ms="order_id" placeholder="Order Id" class="text-xs text-gray-700 border-0">
                        <svg wire:click="sortOperations('order_id')" xmlns="http://www.w3.org/2000/svg" height="1em" viewBox="0 0 320 512" class="w-4 h-4 text-white"><!--! Font Awesome Free 6.4.0 by @fontawesome - https://fontawesome.com License - https://fontawesome.com/license (Commercial License) Copyright 2023 Fonticons, Inc. --><path d="M137.4 41.4c12.5-12.5 32.8-12.5 45.3 0l128 128c9.2 9.2 11.9 22.9 6.9 34.9s-16.6 19.8-29.6 19.8H32c-12.9 0-24.6-7.8-29.6-19.8s-2.2-25.7 6.9-34.9l128-128zm0 429.3l-128-128c-9.2-9.2-11.9-22.9-6.9-34.9s16.6-19.8 29.6-19.8H288c12.9 0 24.6 7.8 29.6 19.8s2.2 25.7-6.9 34.9l-128 128c-12.5 12.5-32.8 12.5-45.3 0z" fill="currentColor"/></svg>
                    </div>
                </th>

                <th class="px-2 py-4 text-xs border border-gray-200 text-white bg-slate-700 sticky top-0">
                    <div class="flex items-center justify-center space-x-2">
                        <input type="search" wire:model.debounce.150ms="client_name" placeholder="Client Name" class="text-xs text-gray-700 border-0">
                        <svg wire:click="sortOperations('client_name')" xmlns="http://www.w3.org/2000/svg" height="1em" viewBox="0 0 320 512" class="w-4 h-4 text-white"><!--! Font Awesome Free 6.4.0 by @fontawesome - https://fontawesome.com License - https://fontawesome.com/license (Commercial License) Copyright 2023 Fonticons, Inc. --><path d="M137.4 41.4c12.5-12.5 32.8-12.5 45.3 0l128 128c9.2 9.2 11.9 22.9 6.9 34.9s-16.6 19.8-29.6 19.8H32c-12.9 0-24.6-7.8-29.6-19.8s-2.2-25.7 6.9-34.9l128-128zm0 429.3l-128-128c-9.2-9.2-11.9-22.9-6.9-34.9s16.6-19.8 29.6-19.8H288c12.9 0 24.6 7.8 29.6 19.8s2.2 25.7-6.9 34.9l-128 128c-12.5 12.5-32.8 12.5-45.3 0z" fill="currentColor"/></svg>
                    </div>
                </th>
                <th class="px-2 py-4 text-xs border border-gray-200 text-white bg-slate-700 sticky top-0">Client Website</th>
                <th class="px-2 py-4 text-xs border border-gray-200 text-white bg-slate-700 sticky top-0">No. of Links</th>
                <th class="px-2 py-4 text-xs border border-gray-200 text-white bg-slate-700 sticky top-0">Order Type</th>
                <th class="px-2 py-4 text-xs border border-gray-200 text-white bg-slate-700 sticky top-0">Action</th>
            </tr>
        </thead>
        <tbody>
            @foreach($orders as $order)
                <tr>
                    <td class="text-xs font-medium  px-2 py-3 border border-gray-200 text-slate-700 text-center sticky bg-white z-20 left-0">
                        <div class="flex items-center justify-between">
                            <div>
                                @if($order->type == 'new') New Order @endif
                                @if($order->type == 'sub') Sub Order @endif
                            </div>
                            <div>{{ $order->order_id }}</div>
                        </div>
                    </td>

                    <td class="text-xs font-medium  px-2 py-3 border border-gray-200 text-center">{{ $order->client_name }}</td>
                    <td class="text-xs font-medium text-red-500  px-2 py-3 border border-gray-200 text-center">{{ $order->client_website }}</td>
                    <td class="text-xs font-medium  px-2 py-3 border border-gray-200 text-center">{{ $order->no_of_links }}</td>
                    <td class="text-xs font-medium  px-2 py-3 border border-gray-200 text-center">{{ $order->order_type }}</td>
                    <td class="text-xs font-medium  px-2 py-3 border border-gray-200 text-center">
                        <a href="{{ route("manager.pending_approvals_for_team_details",$order->id) }}" class="text-xs font-semibold text-black underline">View Details</a>
                    </td>
                </tr>
            @endforeach
        </tbody>
    </table>
</div>
