@php use Carbon\Carbon; @endphp

<div>
    <div>
        @include("admin.partials.messages")
    </div>
    <div>
        <div class="bg-gray-800 text-white text-xs p-3">Message</div>
        <div class="p-3 prose" >{!! $order->message !!} </div>
    </div>
    <div class="flex items-start">
        <div class="w-1/3">

            <table class="w-full border-separate">
                <tr>
                    <th class="p-2 text-xs border border-gray-300">Order Date</th>
                    <td class="p-2 text-xs border border-gray-300">{{ Carbon::parse($order->created_at)->toDayDateTimeString() }}</td>
                </tr>
                <tr>
                    <th class="p-2 text-xs border border-gray-300">Pushed Date</th>
                    <td class="p-2 text-xs border border-gray-300">{{ Carbon::parse($order->order_processes_team_pushed_to_manager->created_at)->toDayDateTimeString() }}</td>
                </tr>
                <tr>
                    <th class="p-2 text-xs border border-gray-300">Team</th>
                    <td class="p-2 text-xs border border-gray-300">{{ $order->team->email }}</td>
                </tr>
                <tr>
                    <th class="p-2 text-xs border border-gray-300">Order Id</th>
                    <td class="p-2 text-xs border border-gray-300">{{ $order->order_id }} @if($order->type=='sub') (Sub Order) @endif</td>
                </tr>
                <tr>
                    <th class="p-2 text-xs border border-gray-300">Client Name</th>
                    <td class="p-2 text-xs border border-gray-300">{{ $order->client_name }}</td>
                </tr>
                <tr>
                    <th class="p-2 text-xs border border-gray-300">Client Website</th>
                    <td class="p-2 text-xs border border-gray-300">{{ $order->client_website }}</td>
                </tr>
                <tr>
                    <th class="p-2 text-xs border border-gray-300">Order Type</th>
                    <td class="p-2 text-xs border border-gray-300">{{ $order->order_type }}</td>
                </tr>
                <tr>
                    <th class="p-2 text-xs border border-gray-300">No of Links</th>
                    <td class="p-2 text-xs border border-gray-300">{{ $order->no_of_links }}</td>
                </tr>
                <tr>
                    <th class="p-2 text-xs border border-gray-300">Order Package</th>
                    <td class="p-2 text-xs border border-gray-300">{{ $order->order_package }}</td>
                </tr>


                <tr>
                    <td colspan="2" class="p-2 text-xs border border-gray-300">
                        <div class="font-bold border-b border-gray-200 pb-1 mb-2">Push Note</div>
                        <div>
                            {{ optional($order->order_processes_team_pushed_to_manager)->note }}
                        </div>
                    </td>
                </tr>
            </table>


        </div>

        <div class="w-2/3 ml-4">
            <table class="w-full table-auto">
                <thead class="bg-slate-800 text-white">
                <tr>
                    <th class="text-xs text-center p-3"></th>
                    <th class="text-xs text-center p-3">Root Domain</th>
                    @if($order->order_type == "niche")
                        <th class="text-xs text-center p-3 break-words" width="35%">POST URL</th>
                    @endif
                    <th class="text-xs text-center p-3">Price</th>
                </tr>
                </thead>
                <tbody>

                @foreach($order->order_processes_team_pushed_to_manager->new_order_process_details as $details)
                    <tr>
                        <td class="text-xs text-center break-words p-3"><input type="checkbox" wire:model="selected_sites.{{ $details->id }}.selected" value="true"></td>
                        <td class="text-xs text-center break-words p-3">
                            @if($order->order_type == 'gp')
                                <div class="bg-gray-100 py-2">
                                    <div class="flex flex-col space-y-1">
                                        <div>{{ $details->new_site->root_domain }}</div>
                                        <div class="flex items-center justify-center space-x-2">
                                            <input type="text" placeholder="Url" wire:model="selected_sites.{{ $details->id }}.url" class="text-xs p-0.5 h-textbox">
                                            <input type="text" placeholder="Anchor" wire:model="selected_sites.{{ $details->id }}.anchor" class="text-xs p-0.5 h-textbox">
                                            <input type="text" placeholder="Title" wire:model="selected_sites.{{ $details->id }}.title" class="text-xs p-0.5 h-textbox">
                                        </div>
                                    </div>
                                    <div class="flex items-center justify-center mt-2 space-x-3 bg-gray-200 p-2">
                                        <span class="font-black">Note:-</span>
                                        <span>{{ $details->new_note }}</span>
                                    </div>
                                </div>
                            @else
                                <div class="bg-gray-100 py-2">
                                <div class="flex flex-col space-y-1">
                                    <div>{{ $details->new_site->root_domain }}</div>
                                    <div class="flex items-center justify-center space-x-2">
                                        <input type="text" placeholder="Url" wire:model.lazy="selected_sites.{{ $details->id }}.url" class="text-xs p-0.5 h-textbox">
                                        <input type="text" placeholder="Anchor" wire:model.lazy="selected_sites.{{ $details->id }}.anchor" class="text-xs p-0.5 h-textbox">
                                    </div>
                                </div>
                                    <div class="flex items-center justify-center mt-2 space-x-3 bg-gray-200 p-2">
                                        <span class="font-black">Note:-</span>
                                        <span>{{ $details->new_note }}</span>
                                    </div>
                                </div>
                            @endif
                        </td>
                        @if($order->order_type == "niche")
                            <td class="text-xs text-center break-words p-3">{{ $details->url }}</td>
                        @endif
                        <td class="text-xs text-center break-words p-3">{{ $details->price }}</td>
                    </tr>
                @endforeach
                </tbody>
            </table>

            <div class="flex items-center justify-between mt-6">

                <form wire:submit.prevent="postDisapproved()" class="flex flex-col">
                    @csrf
                    <textarea wire:model="disapproved_note" class="w-full text-xs" rows="3" placeholder="Note...."></textarea>
                    <button class="border border-red-500 bg-red-500 px-6 text-sm font-semibold py-2 text-white">Post Disapproved</button>

                </form>

                <form wire:submit.prevent="pushToWriter()" class="flex flex-col">
                    @csrf
                    @if($errors->any())
                        @foreach($errors->all() as $error)
                            <div class="bg-red-600 text-white text-xs p-2">{{ $error }}</div>
                        @endforeach
                    @endif
                    <textarea wire:model="note" class="w-full" rows="3" placeholder="Note...."></textarea>
                    <div class="flex items-center">
                        <select class="py-2 border border-gray-700 text-sm font-semibold" wire:model="writer">
                            <option>Select Writer</option>
                            @foreach($writers as $writer)
                                <option value="{{ $writer->id }}">{{ $writer->name  }}</option>
                            @endforeach
                        </select>
                        <button class="border border-gray-700 bg-gray-700 px-6 text-sm font-semibold py-2 text-white">Push to Writer</button>
                    </div>
                </form>

            </div>
        </div>
    </div>
</div>
