<div>

    <x-flash-messages/>

    <form wire:submit.prevent="createNewOrder">
        <div class="grid grid-cols-3 gap-8">
            <div>
                <div class="">
                    <label class="label-h-class flex items-center space-x-1" >
                        <span>Type</span>
                        <svg xmlns="http://www.w3.org/2000/svg" data-tippy-content="Tooltip" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor" class="w-4 h-4 text-black">
                            <path stroke-linecap="round" stroke-linejoin="round" d="M9.879 7.519c1.171-1.025 3.071-1.025 4.242 0 1.172 1.025 1.172 2.687 0 3.712-.203.179-.43.326-.67.442-.745.361-1.45.999-1.45 1.827v.75M21 12a9 9 0 11-18 0 9 9 0 0118 0zm-9 5.25h.008v.008H12v-.008z" />
                        </svg>

                    </label>
                    <select class="select-h-class mt-0 focus:ring-blue-500 focus:border-blue-500" wire:model="type">
                        <option value="">Select</option>
                        <option value="new">New Order</option>
                        <option value="sub">Sub Order</option>
                    </select>
                </div>
                @error('type')
                <div class="text-right mt-1 text-red-400 text-xs">{{ $message }}</div>
                @enderror
            </div>
            <div class="">
                <div class="">
                    <label class="label-h-class flex items-center space-x-1" >
                        <span>Select Team</span>
                        <svg xmlns="http://www.w3.org/2000/svg" data-tippy-content="Tooltip" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor" class="w-4 h-4 text-black">
                            <path stroke-linecap="round" stroke-linejoin="round" d="M9.879 7.519c1.171-1.025 3.071-1.025 4.242 0 1.172 1.025 1.172 2.687 0 3.712-.203.179-.43.326-.67.442-.745.361-1.45.999-1.45 1.827v.75M21 12a9 9 0 11-18 0 9 9 0 0118 0zm-9 5.25h.008v.008H12v-.008z" />
                        </svg>

                    </label>
                    <select class="select-h-class mt-0 focus:ring-blue-500 focus:border-blue-500" wire:model.defer="team_id">
                        <option value="">Select</option>
                        @foreach($teams as $team)
                            <option value="{{ $team->id }}">{{ $team->name }}</option>
                        @endforeach
                    </select>
                </div>
                @error('team_id')
                <div class="text-right mt-1 text-red-400 text-xs">{{ $message }}</div>
                @enderror
            </div>

            <div>
                <div class="">
                    <label class="label-h-class flex items-center space-x-1" >
                        <span>Order Id</span>
                        <svg xmlns="http://www.w3.org/2000/svg" data-tippy-content="Tooltip" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor" class="w-4 h-4 text-black">
                            <path stroke-linecap="round" stroke-linejoin="round" d="M9.879 7.519c1.171-1.025 3.071-1.025 4.242 0 1.172 1.025 1.172 2.687 0 3.712-.203.179-.43.326-.67.442-.745.361-1.45.999-1.45 1.827v.75M21 12a9 9 0 11-18 0 9 9 0 0118 0zm-9 5.25h.008v.008H12v-.008z" />
                        </svg>

                    </label>
                    <input type="text" class="textbox-class focus:ring-blue-500 focus:border-blue-500" wire:model.defer="order_id" >
                </div>
                @error('order_id')
                <div class="text-right mt-1 text-red-400 text-xs">{{ $message }}</div>
                @enderror
            </div>

            <div>
                <div class="">
                    <label class="label-h-class">Client Name</label>
                    <input type="text" class="textbox-class focus:ring-blue-500 focus:border-blue-500" wire:model.defer="client_name" >
                </div>
                @error('client_name')
                <div class="text-right mt-1 text-red-400 text-xs">{{ $message }}</div>
                @enderror
            </div>


            <div>
                <div class="">
                    <label class="label-h-class">Client Website</label>
                    <input type="text" class="textbox-class focus:ring-blue-500 focus:border-blue-500" wire:model.defer="client_website" >
                </div>
                @error('client_website')
                <div class="text-right mt-1 text-red-400 text-xs">{{ $message }}</div>
                @enderror
            </div>


            <div>
                <div class="">
                    <label class="label-h-class">No of Links Ordered</label>
                    <input type="text" class="textbox-class focus:ring-blue-500 focus:border-blue-500" wire:model.defer="no_of_links" >
                </div>
                @error('no_of_links')
                <div class="text-right mt-1 text-red-400 text-xs">{{ $message }}</div>
                @enderror
            </div>

            <div>
                <div class="">
                    <label class="label-h-class">Order Type</label>
                    <select class="select-h-class mt-0 focus:ring-blue-500 focus:border-blue-500" wire:model="order_type">
                        <option value="">Select</option>
                        <option value="gp">GP</option>
                        <option value="niche">NICHE</option>

                    </select>
                </div>
                @error('order_type')
                <div class="text-right mt-1 text-red-400 text-xs">{{ $message }}</div>
                @enderror
            </div>

            <div>
                <div class="">
                    <label class="label-h-class">FC</label>
                    <div class="flex items-center space-x-4 mt-3">
                        <label class="flex items-center space-x-2 text-xs "><input type="radio" wire:model="forgotton_category" value="1"> <span>YES</span></label>
                        <label class="flex items-center space-x-2 text-xs "><input type="radio" wire:model="forgotton_category" value="0"> <span>NO</span></label>
                    </div>
                </div>
                @error('forgotton_category')
                <div class="text-right mt-1 text-red-400 text-xs">{{ $message }}</div>
                @enderror
            </div>


            <div>
                <div class="">
                    <label class="label-h-class">Order Package</label>
                    <select class="select-h-class mt-0 focus:ring-blue-500 focus:border-blue-500" wire:model="order_package">
                        <option value="">Select</option>
                        @foreach($order_packages as $package)
                            <option value="{{ $package }}">{{ $package }}</option>
                        @endforeach
                    </select>
                </div>
                @error('order_package')
                <div class="text-right mt-1 text-red-400 text-xs">{{ $message }}</div>
                @enderror
            </div>

            <div>
                <div class="">
                    <label class="label-h-class">Category</label>
                    <select class="select-h-class mt-0 focus:ring-blue-500 focus:border-blue-500" wire:model="category">
                        <option value="">Select Category</option>
                        @if($forgotton_category == 1)
                            <option value="cbd">CBD</option>
                            <option value="casino">Casino</option>
                        @else
                            @foreach(App\Harman\Helpers\CategoriesList::show() as $show)
                                <option value="{{ $show }}">{{ $show }}</option>
                            @endforeach
                        @endif
                    </select>
                </div>
                @error('category')
                <div class="text-right mt-1 text-red-400 text-xs">{{ $message }}</div>
                @enderror
            </div>



            <div class="col-span-3" >
                <div class="prose max-w-none">
                    <label class="label-h-class flex items-center justify-between">
                        <span>Message</span>
                    </label>
                    <x-input.rich-text wire:model.lazy="message" id="message"></x-input.rich-text>
{{--                    <textarea id="message" class="textbox-class focus:ring-blue-500 focus:border-blue-500" rows="5"></textarea>--}}
                </div>
                @error('message')
                <div class="text-right mt-1 text-red-400 text-xs">{{ $message }}</div>
                @enderror
            </div>


            <div class="col-span-3 flex justify-end mt-4 items-end">
                <div wire:loading.block wire:target="createNewOrder">Loading...</div>
                <button type="submit" class="bg-gray-800 text-white text-lg rounded px-4 py-2" wire:loading.remove>Pushing Order to the Team</button>
            </div>



        </div>
    </form>



</div>
