<div>
    <div>

        <form wire:submit.prevent="createThread" class="mt-8">
            @csrf

            @include("admin.partials.messages")


                <div class="flex items-center w-2/3">
                    <label class="w-64 text-sm text-right mr-6">Select Role</label>
                    <div class="flex-1">
                        <select class="w-full border border-gray-300 p-2 text-sm" wire:model.live="role">
                            <option value="">Select</option>
                            @if(auth()->user()->role == "manager")
                                <option value="vendor">Vendor</option>
                                <option value="team">Team</option>
                                <option value="writer">Writer</option>
                            @else
                                <option value="manager">Manager</option>
                            @endif
                        </select>
                        @error('role')
                            <div class="text-red-500 text-xs text-right font-medium">*{{ $message }}</div>
                        @enderror
                    </div>
                </div>

                <div class="flex items-center w-2/3 mt-6">
                    <label class="w-64 text-sm text-right mr-6">Select User</label>
                    <div class="flex-1">
                        <select class="w-full border border-gray-300 p-2 text-sm" wire:model="user">
                            <option value="">Select User</option>
                            @foreach($users as $u)
                                <option value="{{ $u->id }}">{{ $u->name }}</option>
                            @endforeach
                        </select>
                        @error('user')
                            <div class="text-red-500 text-xs text-right font-medium">*{{ $message }}</div>
                        @enderror
                    </div>
                </div>


            <div class="flex items-center w-2/3 mt-6">
                <label class="w-64 text-sm text-right mr-6">Subject</label>
                <div class="flex-1">
                    <input type="text" placeholder="Subject..." wire:model.defer="subject" class="w-full border border-gray-300 p-2 text-sm">
                    @error('subject')
                        <div class="text-red-500 text-xs text-right font-medium">*{{ $message }}</div>
                    @enderror
                </div>
            </div>

            <div class="flex items-center w-2/3 mt-6">
                <label class="w-64 text-right mr-6"></label>
                <button class="bg-red-500 text-white text-sm px-6 py-3 rounded">Create New Thread</button>
            </div>

        </form>
    </div>
</div>
