<div>

    <x-flash-messages/>
    <form wire:submit.prevent="createNewOrder">
        <div class="grid grid-cols-3 gap-8">
            <div>
                <div class="">
                    <label class="label-h-class" data-tippy-content="Tooltip">Type</label>
                    <select class="select-h-class mt-0 focus:ring-blue-500 focus:border-blue-500" wire:model="type">
                        <option value="">Select</option>
                        <option value="new">New Order</option>
                        <option value="sub">Sub Order</option>
                    </select>
                </div>
                @error('type')
                    <div class="text-right mt-1 text-red-400 text-xs">{{ $message }}</div>
                @enderror
            </div>
            <div class="">
                <div class="">
                    <label class="label-h-class">Select Team</label>
                    <select class="select-h-class mt-0 focus:ring-blue-500 focus:border-blue-500" wire:model.defer="team_id">
                        <option value="">Select</option>
                        @foreach($teams as $team)
                            <option value="{{ $team->id }}">{{ $team->name }} ({{ $team->email }})</option>
                        @endforeach
                    </select>
                </div>
                @error('team_id')
                <div class="text-right mt-1 text-red-400 text-xs">{{ $message }}</div>
                @enderror
            </div>

            <div>
                <div class="">
                    <label class="label-h-class">Order Id</label>
                    <input type="text" class="textbox-class focus:ring-blue-500 focus:border-blue-500" wire:model.defer="order_id" >
                </div>
                @error('order_id')
                <div class="text-right mt-1 text-red-400 text-xs">{{ $message }}</div>
                @enderror
            </div>

            <div>
                <div class="">
                    <label class="label-h-class">Client Name</label>
                    <input type="text" class="textbox-class focus:ring-blue-500 focus:border-blue-500" wire:model.defer="client_name" >
                </div>
                @error('client_name')
                <div class="text-right mt-1 text-red-400 text-xs">{{ $message }}</div>
                @enderror
            </div>


            <div>
                <div class="">
                    <label class="label-h-class">Client Website</label>
                    <input type="text" class="textbox-class focus:ring-blue-500 focus:border-blue-500" wire:model.defer="client_website" >
                </div>
                @error('client_website')
                <div class="text-right mt-1 text-red-400 text-xs">{{ $message }}</div>
                @enderror
            </div>


            <div>
                <div class="">
                    <label class="label-h-class">No of Links Ordered</label>
                    <input type="text" class="textbox-class focus:ring-blue-500 focus:border-blue-500" wire:model.defer="no_of_links" >
                </div>
                @error('no_of_links')
                <div class="text-right mt-1 text-red-400 text-xs">{{ $message }}</div>
                @enderror
            </div>

            <div>
                <div class="">
                    <label class="label-h-class">Order Type</label>
                    <select class="select-h-class mt-0 focus:ring-blue-500 focus:border-blue-500" wire:model="order_type">
                        <option value="">Select</option>
                        <option value="gp">GP</option>
                        <option value="niche">NICHE</option>
                        <option value="fcgp">FC GP</option>
                        <option value="fcne">FC NE</option>
                    </select>
                </div>
                @error('order_type')
                <div class="text-right mt-1 text-red-400 text-xs">{{ $message }}</div>
                @enderror
            </div>


            <div>
                <div class="">
                    <label class="label-h-class">Order Package</label>
                    <select class="select-h-class mt-0 focus:ring-blue-500 focus:border-blue-500" wire:model="order_package">
                        <option value="">Select</option>
                        @foreach($order_packages as $package)
                            <option value="{{ $package }}">{{ $package }}</option>
                        @endforeach
                    </select>
                </div>
                @error('order_package')
                    <div class="text-right mt-1 text-red-400 text-xs">{{ $message }}</div>
                @enderror
            </div>

            <div>
                <div class="">
                    <label class="label-h-class">Category</label>
                    <select class="select-h-class mt-0 focus:ring-blue-500 focus:border-blue-500" wire:model="category">
                        <option value="">Select Category</option>
                        @foreach(App\Harman\Helpers\CategoriesList::show() as $show)
                            <option value="{{ $show }}">{{ $show }}</option>
                        @endforeach
                    </select>
                </div>
                @error('category')
                <div class="text-right mt-1 text-red-400 text-xs">{{ $message }}</div>
                @enderror
            </div>



            <div class="col-span-3" >
                <div class="prose max-w-none" wire:ignore>
                    <label class="label-h-class">Message</label>
                    <textarea id="message" class="textbox-class focus:ring-blue-500 focus:border-blue-500" rows="5"></textarea>
                </div>
                @error('message')
                    <div class="text-right mt-1 text-red-400 text-xs">{{ $message }}</div>
                @enderror
            </div>


            <div class="col-span-3 flex justify-end mt-4 items-end">
                <div wire:loading.block wire:target="createNewOrder">Loading...</div>
                <button type="submit" class="bg-gray-800 text-white text-lg rounded px-4 py-2" wire:loading.remove>Pushing Order to the Team</button>
            </div>



        </div>
    </form>

    <script>
        $(function (){
           $('textarea#message').trumbowyg()
               .on('tbwblur', function(){
                   var editorValue = $('textarea#message').trumbowyg('html');
                   Livewire.emit('changeDescription',editorValue);
               });
        });
    </script>

</div>
