<div>
    <div class="mb-1 flex items-center justify-between">
        <div>
            @if(count($histories) > 0)



            <div x-data="{open: false}">
                <button class="bg-blue-500 text-white px-6 py-2 text-xs" @click="open=!open">Bulk</button>
                <div>Total Amount {{ $total_amount }}</div>
                <div x-show="open" class="fixed bg-black/50 w-full h-screen left-0 top-0 flex items-center justify-center ">
                    <div class="bg-white w-1/2 " @click.outside="open=false" style="height: 500px;overflow: auto;padding: 20px;">
                       <form wire:submit.prevent="saveRemarks">
                           <div></div>
                           <div>
                               <label>Remarks</label>
                               <textarea class="textbox-class" wire:model="remarks" placeholder="Remarks" rows="4"></textarea>
                           </div>

                           <div class="mt-4">
                               <button type="submit" class="bg-pink-700 text-white py-3 w-full rounded">Send</button>
                           </div>
                       </form>
                    </div>
                </div>
            </div>
            @endif
        </div>
        <form method="post" action="{{ route("admin.download_csv_bank") }}">
            @csrf
            <button class="bg-green-600 text-white rounded px-6 py-2 text-xs">Download Bank Details CSV</button>
        </form>
    </div>
    <div>
    </div>
    <table class="w-full table-auto text-xs">
        <thead class="bg-pink-700 text-white">
            <tr>
            <th class="text-left w-72 py-2 px-4 " style="width: 5%">
                <input type="checkbox" wire:model="select_all" value="1"/>
            </th>
            <th class="text-left w-72 py-2 px-4">
                    <input type="search" wire:model.debounce.500ms="email" placeholder="Email Address" class="text-xs text-black p-1" >
            </th>
            <th class="text-left py-2 px-4">Payment Method
                <select wire:model.live="payment_method" class="text-xs text-black p-1" style="width: 100px;">
                    <option value="">All</option>
                    <option  value="bank">Bank</option>
                    <option value="paypal_id">Paypal ID</option>
                    <option value="paypal_link">QR Code</option>
                    <option value="upi_id">UPI ID</option>
                </select>

            </th>
            <th class="text-center py-2 px-4">Request Amount</th>
            <th class="text-left py-2 px-4">Datetime</th>
            <th class="text-left py-2 px-4">Action</th>
        </tr>
        </thead>
        <tbody>
        @php $total = 0; @endphp
        @foreach($requests as $req)
            @if(isset($req->wallet_histories[0]))
                <tr wire:key="{{ $req->id }}">
                    <td class="py-2 px-4 border border-gray-100">
                        <input type="checkbox" wire:model="histories" value="{{ $req->id }}">
                    </td>
                    <td class="py-2 px-4 border border-gray-100">
                        <div class="flex flex-col space-y-1 text-sm font-semibold mt-2">
                            <div>{{ $req->user->name }}</div>
                            <div>{{ $req->user->email }}</div>
                        </div>
                    </td>
                    <td class="py-2 px-4 border border-gray-100">
                        <div class="flex items-center justify-between">
                            <span class="text-gray-600 text-sm">Payment Method</span>
                            <span class="text-black font-bold">{{ $req->wallet_histories[0]->payment_method }}</span>
                        </div>
                        <div class="text-sm mt-4">
                            @if($req->wallet_histories[0]->payment_method == "bank")
                                <h3 class="text-pink-700">Bank Details</h3>

                                <div class="flex items-center justify-between border-b border-gray-200 mt-2 pb-1 mb-1">
                                    <span class="text-gray-600 text-sm">Bank Type</span>
                                    <span class="text-black font-bold">{{ $req->wallet_histories[0]->bank_type }}</span>
                                </div>
                                <div class="flex items-center justify-between border-b border-gray-200 pb-1 mb-1">
                                    <span class="text-gray-600 text-sm">Beneficiary Account Number</span>
                                    <span class="text-black font-bold">{{ $req->wallet_histories[0]->beneficiary_account_number }}</span>
                                </div>

                                <div class="flex items-center justify-between border-b border-gray-200 pb-1 mb-1">
                                    <span class="text-gray-600 text-sm">Beneficiary Name</span>
                                    <span class="text-black font-bold">{{ $req->wallet_histories[0]->beneficiary_name }}</span>
                                </div>

                                <div class="flex items-center justify-between border-b border-gray-200 pb-1 mb-1">
                                    <span class="text-gray-600 text-sm">Customer Reference Number</span>
                                    <span class="text-black font-bold">{{ $req->wallet_histories[0]->customer_reference_number }}</span>
                                </div>

                                <div class="flex items-center justify-between border-b border-gray-200 pb-1 mb-1">
                                    <span class="text-gray-600 text-sm">IFSC Code</span>
                                    <span class="text-black font-bold">{{ $req->wallet_histories[0]->ifsc_code }}</span>
                                </div>

                                <div class="flex items-center justify-between border-b border-gray-200 pb-1 mb-1">
                                    <span class="text-gray-600 text-sm">Beneficiary Bank Name</span>
                                    <span class="text-black font-bold">{{ $req->wallet_histories[0]->bene_bank_name }}</span>
                                </div>

                                <div class="flex items-center justify-between border-b border-gray-200 pb-1 mb-1">
                                    <span class="text-gray-600 text-sm">Beneficiary Bank Branch Name</span>
                                    <span class="text-black font-bold">{{ $req->wallet_histories[0]->bene_bank_branch_name }}</span>
                                </div>

                                <div class="flex items-center justify-between border-b border-gray-200 pb-1 mb-1">
                                    <span class="text-gray-600 text-sm">Beneficiary Email id</span>
                                    <span class="text-black font-bold">{{ $req->wallet_histories[0]->beneficiary_email_id }}</span>
                                </div>

                            @endif

                            @if($req->wallet_histories[0]->payment_method == "qr_code")
                                <div class="flex items-center justify-between border-b border-gray-200 mt-2 pb-1 mb-1">
                                    <span class="text-gray-600 text-sm">QR Code</span>
                                    <span class="text-black font-bold">
                                    <a href="/uploads/{{$req->wallet_histories[0]->qr_code_image }}" target="_blank">
                                        <img src="/uploads/{{$req->wallet_histories[0]->qr_code_image }}" class="w-32">
                                    </a>
                                    </span>
                                </div>
                            @endif

                            @if($req->wallet_histories[0]->payment_method == "paypal_id")
                                <div class="flex items-center justify-between border-b border-gray-200 mt-2 pb-1 mb-1">
                                    <span class="text-gray-600 text-sm">Paypal ID</span>
                                    <span class="text-black font-bold">{{$req->wallet_histories[0]->paypal_email }}</span>
                                </div>

                            @endif

                            @if($req->wallet_histories[0]->payment_method == "upi_id")
                                <h3 class="text-pink-700">UPI Details</h3>
                                <div class="flex items-center justify-between border-b border-gray-200 mt-2 pb-1 mb-1">
                                    <span class="text-gray-600 text-sm">UPI ID</span>
                                    <span class="text-black font-bold">{{$req->wallet_histories[0]->upi_id }}</span>
                                </div>

                            @endif

                        </div>
                    </td>


                    <td class="py-2 px-4 border text-left text-center border-gray-100">
                        <div class="text-2xl font-bold">
                            {{ $req->wallet_histories->sum('price') }}
                        </div>
                    </td>
                    <td class="py-2 px-4 border border-gray-100">
                        {{ Carbon\Carbon::parse($req->created_at)->toDayDateTimeString() }}
                    </td>

                    <td class="py-2 px-4 border text-center border-gray-100 ">
                        <div x-data="{open: false}">
                            <button class="bg-blue-500 text-white px-3 py-1 text-xs" @click="open=!open">Send</button>
                            <div x-show="open" class="fixed bg-black/50 w-full h-screen left-0 top-0 flex items-center justify-center ">
                                <div class="bg-white w-1/2 " @click.outside="open=false" style="height: 500px;overflow: auto;padding: 20px;">
                                    <livewire:admin.send-request-money :wire:key="uniqid()" :withdrawId="$req->id"/>
                                </div>
                            </div>
                        </div>
                    </td>


                </tr>

                @php $total += $req->wallet_histories->sum('price'); @endphp
            @endif
        @endforeach

        <tr>
            <th class="text-left w-72 py-2 px-4"></th>
            <th class="text-left w-72 py-2 px-4"></th>
            <th class="text-center py-2 px-4" style="font-size: 25px;font-weight: bold">
                Total
            </th>
            <th class="text-center py-2 px-4" style="font-size: 25px;font-weight: bold">{{ $total }}</th>
            <th class="text-left py-2 px-4"></th>
            <th class="text-left py-2 px-4"></th>
        </tr>
        </tbody>

    </table>
</div>
