@php use Carbon\Carbon;use Illuminate\Support\Facades\Auth; @endphp

<div>
    <style>
        .noUi-tooltip {
            font-size: 10px;
            font-weight: bold;
            padding: 4px;
        }

        .noUi-value {
            font-size: 11px;
            font-weight: bold;
            color: black;
            margin-top: 8px;
            display: inline-block;
        }

        .noUi-horizontal {
            height: 8px;
        }

        .noUi-horizontal .noUi-handle {
            height: 20px;
            right: -17px;
            top: -8px;
            width: 20px;
        }

        .noUi-handle:after, .noUi-handle:before {
            background: #e8e7e6;
            content: "";
            display: block;
            height: 10px;
            left: 8px;
            position: absolute;
            top: 5px;
            width: 1px;
        }

        .noUi-handle:after {
            left: 11px;
        }

        .noUi-horizontal .noUi-tooltip {
            bottom: 120%;
            left: 25%;
            transform: translate(-50%);
        }
    </style>
    <div>

        <div class="flex items-start">
            @if(Auth::user()->role == 'admin' || Auth::user()->role == 'manager' || Auth::user()->role == 'team' )
                <div id="sidebar" class="shrink-0 mt-14 mr-2 overflow-y-auto" style="height: 700px;width: 16rem">


                    <div class="bg-white p-2">
                        <div class="font-semibold border-b border-gray-400 pb-1">Category</div>
                        <div class="mt-4 mb-4 flex items-center">
                            <input type="search" placeholder="Category" wire:model.debounce.300ms="category"
                                   class="text-xs flex-1 w-full focus:ring-0 p-2 border border-gray-300">
                        </div>
                    </div>
                    <div class="h-2"></div>
                    <div class="bg-white p-2">
                        <div class="font-semibold border-b border-gray-400 pb-1">Website Niche</div>
                        <div class="mt-4 mb-4 flex items-center">
                            <input type="search" placeholder="Website Niche" wire:model.debounce.300ms="website_niche"
                                   class="text-xs flex-1 w-full focus:ring-0 p-2 border border-gray-300">
                        </div>
                    </div>
                    <div class="h-2"></div>
                    <div class="bg-white p-2">
                        <div class="font-semibold border-b border-gray-400 pb-1">FC</div>
                        <div class="mt-4 mb-2 flex items-center">
                            <div class="flex flex-col space-y-3">
                                <label class="flex items-end text-sm space-x-3 pb-1 mb-1">
                                    <span><input type="radio" wire:model="fc" value="GP"
                                                 style="width: 12px;height: 12px;"></span>
                                    <span class="text-xs">GP FC</span>
                                </label>
                                <label class="flex items-end text-sm space-x-3 pb-1 mb-1">
                                    <span><input type="radio" wire:model="fc" value="NE"
                                                 style="width: 12px;height: 12px;"></span>
                                    <span class="text-xs">NE FC</span>
                                </label>
                            </div>
                        </div>
                        <button type="button" wire:click="clearFc" class="bg-red-600 text-white text-xs px-2 py-1">
                            Clear
                        </button>
                    </div>
{{--                    <div class="h-2"></div>--}}
{{--                    <div class="bg-white p-2">--}}
{{--                        <div class="font-semibold border-b border-gray-400 pb-1">DR</div>--}}
{{--                        <div class="p-2 mt-8 pr-4">--}}
{{--                            <x-range-slider :options="$dr_options" wire:model="dr_range.min,dr_range.max"/>--}}
{{--                        </div>--}}
{{--                    </div>--}}
{{--                    <div class="h-2"></div>--}}
{{--                    <div class="bg-white p-2">--}}
{{--                        <div class="font-semibold border-b border-gray-300 pb-1">DA</div>--}}
{{--                        <div class="p-2 mt-8 pr-4">--}}
{{--                            <x-range-slider :options="$da_options" wire:model="da_range.min,da_range.max"/>--}}
{{--                        </div>--}}
{{--                    </div>--}}
{{--                    <div class="h-2"></div>--}}
{{--                    <div class="bg-white p-2 pr-4">--}}
{{--                        <div class="font-semibold border-b border-gray-300 pb-1">RD</div>--}}
{{--                        <div class="p-2 mt-8">--}}
{{--                            <x-range-slider :options="$rd_options" wire:model="rd_range.min,rd_range.max"/>--}}
{{--                        </div>--}}
{{--                    </div>--}}

                    <div class="h-2"></div>
                    <div class="bg-white p-2">
                        <div class="font-semibold border-b border-gray-300 pb-1">Traffic</div>
                        <div class="mt-2">
                            <label class="flex items-end text-sm space-x-3 pb-1 mb-1">
                                <span><input type="radio" wire:model="traffic" value="0-5000"
                                             style="width: 12px;height: 12px;"></span>
                                <span class="text-xs">Below 5K</span>
                            </label>
                            <label class="flex items-end text-sm space-x-3 pb-1 mb-1">
                                <span><input type="radio" wire:model="traffic" value="5001-10000"
                                             style="width: 12px;height: 12px;"></span>
                                <span class="text-xs">5K - 10K</span>
                            </label>
                            <label class="flex items-end text-sm space-x-3 pb-1 mb-1">
                                <span><input type="radio" wire:model="traffic" value="10001-50000"
                                             style="width: 12px;height: 12px;"></span>
                                <span class="text-xs">10K - 50K</span>
                            </label>
                            <label class="flex items-end text-sm space-x-3 pb-1 mb-1">
                                <span><input type="radio" wire:model="traffic" value="50001-100000"
                                             style="width: 12px;height: 12px;"></span>
                                <span class="text-xs">50K - 100K</span>
                            </label>
                            <label class="flex items-end text-sm space-x-3 pb-1 mb-1">
                                <span><input type="radio" wire:model="traffic" value="100001-250000"
                                             style="width: 12px;height: 12px;"></span>
                                <span class="text-xs">100K - 250K</span>
                            </label>
                            <label class="flex items-end text-sm space-x-3 pb-1 mb-1">
                                <span><input type="radio" wire:model="traffic" value="250001-500000"
                                             style="width: 12px;height: 12px;"></span>
                                <span class="text-xs">250K - 500K</span>
                            </label>
                            <label class="flex items-end text-sm space-x-3 pb-1 mb-1">
                                <span><input type="radio" wire:model="traffic" value="500001-750000"
                                             style="width: 12px;height: 12px;"></span>
                                <span class="text-xs">500K - 750K</span>
                            </label>
                            <label class="flex items-end text-sm space-x-3 pb-1 mb-1">
                                <span><input type="radio" wire:model="traffic" value="750001-all"
                                             style="width: 12px;height: 12px;"></span>
                                <span class="text-xs">Above 750K</span>
                            </label>


                        </div>
                        <div class="mt-4 mb-4 flex items-start">
                            <input type="number" placeholder="MIN"
                                   class="text-xs w-16 flex-1 p-2 border border-gray-300 mr-3"
                                   wire:model.defer="traffic_start_range">
                            <input type="number" placeholder="MAX"
                                   class="text-xs w-16 flex-1 p-2 border border-gray-300 mr-3"
                                   wire:model.defer="traffic_end_range">
                            <button
                                class="bg-primary-color text-white p-1.5 px-3 font-black text-sm border border-primary-color mr-2"
                                wire:click="searchTraffic">GO
                            </button>
                        </div>
                    </div>

                    <div class="h-2"></div>
                    <div class="bg-white p-2">
                        <div class="font-semibold border-b border-gray-300 pb-1">GP Price</div>
                        <div class="mt-2">
                            <label class="flex items-end text-sm space-x-3 pb-1 mb-1">
                                <span><input type="radio" wire:model="gp_price" value="0-10"
                                             style="width: 12px;height: 12px;"></span>
                                <span class="text-xs">Under 10</span>
                            </label>
                            <label class="flex items-end text-sm space-x-3 pb-1 mb-1">
                                <span><input type="radio" wire:model="gp_price" value="10-20"
                                             style="width: 12px;height: 12px;"></span>
                                <span class="text-xs">10 - 20</span>
                            </label>
                            <label class="flex items-end text-sm space-x-3 pb-1 mb-1">
                                <span><input type="radio" wire:model="gp_price" value="20-30"
                                             style="width: 12px;height: 12px;"></span>
                                <span class="text-xs">20 - 30</span>
                            </label>
                            <label class="flex items-end text-sm space-x-3 pb-1 mb-1">
                                <span><input type="radio" wire:model="gp_price" value="30-50"
                                             style="width: 12px;height: 12px;"></span>
                                <span class="text-xs">30 - 50</span>
                            </label>
                            <label class="flex items-end text-sm space-x-3 pb-1 mb-1">
                                <span><input type="radio" wire:model="gp_price" value="50-all"
                                             style="width: 12px;height: 12px;"></span>
                                <span class="text-xs">Above 50</span>
                            </label>

                        </div>
                        <div class="mt-4 mb-4 flex items-start">
                            <input type="number" placeholder="MIN"
                                   class="text-xs w-16 flex-1 p-2 border border-gray-300 mr-3"
                                   wire:model.defer="gpprice_start_range">
                            <input type="number" placeholder="MAX"
                                   class="text-xs w-16 flex-1 p-2 border border-gray-300 mr-3"
                                   wire:model.defer="gpprice_end_range">
                            <button
                                class="bg-primary-color text-white p-1.5 px-3 font-black text-sm border border-primary-color mr-2"
                                wire:click="searchWithGpPrice">GO
                            </button>
                        </div>
                    </div>

                    <div class="h-2"></div>
                    <div class="bg-white p-2">
                        <div class="font-semibold border-b border-gray-300 pb-1">Niche Edit Price</div>
                        <div class="mt-2">
                            <label class="flex items-end text-sm space-x-3 pb-1 mb-1">
                                <span><input type="radio" wire:model="niche_price" value="0-10"
                                             style="width: 12px;height: 12px;"></span>
                                <span class="text-xs">Under 10</span>
                            </label>
                            <label class="flex items-end text-sm space-x-3 pb-1 mb-1">
                                <span><input type="radio" wire:model="niche_price" value="10-20"
                                             style="width: 12px;height: 12px;"></span>
                                <span class="text-xs">10 - 20</span>
                            </label>
                            <label class="flex items-end text-sm space-x-3 pb-1 mb-1">
                                <span><input type="radio" wire:model="niche_price" value="20-30"
                                             style="width: 12px;height: 12px;"></span>
                                <span class="text-xs">20 - 30</span>
                            </label>
                            <label class="flex items-end text-sm space-x-3 pb-1 mb-1">
                                <span><input type="radio" wire:model="niche_price" value="30-50"
                                             style="width: 12px;height: 12px;"></span>
                                <span class="text-xs">30 - 50</span>
                            </label>
                            <label class="flex items-end text-sm space-x-3 pb-1 mb-1">
                                <span><input type="radio" wire:model="niche_price" value="50-all"
                                             style="width: 12px;height: 12px;"></span>
                                <span class="text-xs">Above 50</span>
                            </label>

                        </div>
                        <div class="mt-4 mb-4 flex items-start">
                            <input type="number" placeholder="MIN"
                                   class="text-xs w-16 flex-1 p-2 border border-gray-300 mr-3"
                                   wire:model.defer="nicheprice_start_range">
                            <input type="number" placeholder="MAX"
                                   class="text-xs w-16 flex-1 p-2 border border-gray-300 mr-3"
                                   wire:model.defer="nicheprice_end_range">
                            <button
                                class="bg-primary-color text-white p-1.5 px-3 font-black text-sm border border-primary-color mr-2"
                                wire:click="searchWithNichePrice">GO
                            </button>
                        </div>
                    </div>


                </div>
            @endif
            <div class="flex-1 w-full overflow-scroll">
                <div class="flex items-end justify-between">
                    <div class="flex items-center space-x-4">
                        @if(Auth::user()->role == 'admin' || Auth::user()->role == 'manager' || Auth::user()->role == 'team' )
                            <svg id="menu_sidebar" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24"
                                 stroke-width="1.5" stroke="currentColor" class="w-5 h-5">
                                <path stroke-linecap="round" stroke-linejoin="round"
                                      d="M3.75 6.75h16.5M3.75 12h16.5m-16.5 5.25h16.5"/>
                            </svg>
                        @endif
                        <div class="text-gray-500 text-xs">
                            Showing {{ $sites->firstItem() }} to {{ $sites->lastItem() }} of {{ $sites->total() }}
                            results
                        </div>

                    </div>
                    <div>
                        <select class="text-xs border border-gray-300 bg-white mt-2 rounded" wire:model="column_name">
                            <option value="root_domain">Root Domain</option>
                            <option value="email">Email</option>
                            <option value="website_status">Website Status</option>
                        </select>
                        <input type="search" wire:model.debounce.300ms="root_domain" placeholder="Search Website Here"
                               class="text-xs border border-gray-300 bg-white mt-2 rounded">
                        <button wire:click="export_csv" class="bg-green-600 text-white text-xs px-4 py-2.5 rounded">
                            Export CSV
                        </button>
                    </div>
                </div>
                <div class="relative" style="max-height: 700px;overflow: auto;">
                    <table class="border border-gray-50 border-separate w-full table-auto "
                           style="border-spacing: 0 10px;">
                        <thead class="text-xs bg-gray-200 ">
                        <tr class="sticky top-0">
                            <th class="px-2 py-5 text-left z-50 bg-gray-200 sticky top-0" width="5%">S.No</th>
                            <th class="px-2 py-5 text-left z-50 bg-gray-200 sticky top-0" width="15%">Root Domain
                                <span>
                                    <input type="checkbox" wire:model="new_arrival" value="1"> New Arrival
                                </span>
                            </th>
                            @if(\auth()->user()->role != "vendor")
                                <th class="px-2 py-5 text-left z-50 bg-gray-200 sticky top-0" width="6%">
                                    <select class="text-gray-600 text-xs p-1" wire:model="site_status">
                                        <option value="">Status</option>
                                        <option value="1">Approved</option>
                                        <option value="0">Pending</option>
                                        <option value="2">Rejected</option>
                                    </select>
                                </th>
                            @endif
                            <th class="px-2 py-5 text-left z-50 bg-gray-200 sticky top-0" width="6%">DR</th>
                            <th class="px-2 py-5 text-left z-50 bg-gray-200 sticky top-0" width="6%">DA</th>
                            <th class="px-2 py-5 text-left z-50 bg-gray-200 sticky top-0" width="6%">Spam Score</th>
                            <th class="px-2 py-5 text-left z-50 bg-gray-200 sticky top-0" width="6%">RD</th>
                            <th class="px-2 py-5 text-left z-50 bg-gray-200 sticky top-0" width="6%">Traffic</th>

                            @if($fc == 'GP')
                                <th class="px-2 py-5 text-left z-50 bg-gray-200 sticky top-0" width="6%">FC GP</th>
                            @elseif($fc == 'NE')
                                <th class="px-2 py-5 text-left z-50 bg-gray-200 sticky top-0" width="6%">FC NE</th>
                            @else
                                <th class="px-2 py-5 text-left z-50 bg-gray-200 sticky top-0" width="6%">GP</th>
                                <th class="px-2 py-5 text-left z-50 bg-gray-200 sticky top-0" width="6%">Niche Edit</th>
                                <th class="px-2 py-5 text-left z-50 bg-gray-200 sticky top-0" width="6%">FC GP</th>
                                <th class="px-2 py-5 text-left z-50 bg-gray-200 sticky top-0" width="6%">FC NE</th>
                            @endif


                            <th class="px-2 py-5 text-left z-50 bg-gray-200 sticky top-0" width="10%">Website Status
                            </th>
                            <th class="px-2 py-5 text-left z-50 bg-gray-200 sticky top-0">Email</th>
                            <th class="px-2 py-5 text-left z-50 bg-gray-200 sticky top-0">
                                <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24"
                                     stroke-width="1.5" stroke="currentColor" class="w-6 h-6">
                                    <path stroke-linecap="round" stroke-linejoin="round"
                                          d="M6.75 12a.75.75 0 11-1.5 0 .75.75 0 011.5 0zM12.75 12a.75.75 0 11-1.5 0 .75.75 0 011.5 0zM18.75 12a.75.75 0 11-1.5 0 .75.75 0 011.5 0z"/>
                                </svg>

                            </th>
                        </tr>
                        </thead>
                        <tbody>
                        @php $i=$sites->firstItem(); @endphp
                        @foreach($sites as $d)
                            <tr>
                                <td class="text-xs px-2 py-5 bg-white border-b border-gray-300">{{ $i++ }}</td>
                                <td class="text-xs px-2 py-5 bg-white border-b border-gray-300 rounded-l break-words">
                                    @if(Carbon::now()->diffInDays($d->created_at) <= 30)
                                        <div style="background: green;color: white;font-size: 10px;padding: 4px 10px;margin-bottom: 6px;display: inline-block;">NEW ARRIVAL</div>
                                    @endif
                                    <div class="text-orange-500 font-bold underline">{{ $d->root_domain }}


                                    </div>
                                    <div class="text-gray-600 mt-1">Category: {{ $d->category }}</div>
                                    <div style="margin-top: 5px;font-size: 10px;font-weight: bold;color: #999;">
                                        Added :- {{ Carbon::parse($d->created_at)->toDayDateTimeString() }}
                                    </div>

                                        @if(Auth::user()->role == 'admin' || Auth::user()->role == 'manager' || Auth::user()->role == 'team' )
                                            @if($d->new_order_process_detail)
                                                <div style="margin-top: 5px;font-size: 10px;font-weight: bold;color: #999;">
                                                    Last Order Created :-
                                                    <div>{{ Carbon::parse($d->new_order_process_detail->created_at)->toDayDateTimeString() }}</div>
                                                </div>
                                            @endif
                                        @endif
                                </td>
                                @if(\auth()->user()->role != "vendor")
                                    <td class="text-xs px-2 py-5 bg-white border-b border-gray-300">
                                        @if($d->site_status == 0)
                                            <span class="bg-orange-500 text-white text-xs px-2 py-1">P</span>
                                        @elseif($d->site_status == 2)
                                            <span class="bg-red-500 text-white text-xs px-2 py-1">R</span>
                                        @elseif( $d->site_status == 1 )
                                            <span class="bg-green-700 text-white text-xs px-2 py-1">A</span>
                                        @endif
                                    </td>
                                @endif
                                <td class="text-xs px-2 py-5 bg-white border-b border-gray-300">{{ $d->dr }}</td>
                                <td class="text-xs px-2 py-5 bg-white border-b border-gray-300">{{ $d->da }}</td>
                                <td class="text-xs px-2 py-5 bg-white border-b border-gray-300">{{ $d->spam_score }}</td>
                                <td class="text-xs px-2 py-5 bg-white border-b border-gray-300">{{ $d->rd }}</td>
                                <td class="text-xs px-2 py-5 bg-white border-b border-gray-300">{{ $d->traffic_source }}</td>
                                @if($fc == 'GP')
                                    <td class="text-xs px-2 py-5 bg-white border-b border-gray-300">{{ $d->fc_gp }}</td>
                                @elseif($fc == 'NE')
                                    <td class="text-xs px-2 py-5 bg-white border-b border-gray-300">{{ $d->fc_ne }}</td>
                                @else
                                    <td class="text-xs px-2 py-5 bg-white border-b border-gray-300">{{ $d->gp_price }}</td>
                                    <td class="text-xs px-2 py-5 bg-white border-b border-gray-300">{{ $d->niche_edit_price }}</td>
                                    <td class="text-xs px-2 py-5 bg-white border-b border-gray-300">{{ $d->fc_gp }}</td>
                                    <td class="text-xs px-2 py-5 bg-white border-b border-gray-300">{{ $d->fc_ne }}</td>

                                @endif


                                <td class="text-xs px-2 py-5 bg-white border-b border-gray-300">{{ $d->website_status }}</td>
                                <td class="text-xs px-2 py-5 bg-white border-b border-gray-300 rounded-r">
                                    @if(!empty($d->email))
                                        {{ $d->email }}
                                    @else
                                        {{ optional($d->uploaded_user)->email }}
                                    @endif

                                </td>
                                <td class="text-xs px-2 py-5 bg-white border-b border-gray-300 rounded-r">
                                    <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24"
                                         stroke-width="1.5" stroke="currentColor"
                                         class="cursor-pointer more_data w-6 h-6 text-orange-500">
                                        <path stroke-linecap="round" stroke-linejoin="round"
                                              d="M6.75 12a.75.75 0 11-1.5 0 .75.75 0 011.5 0zM12.75 12a.75.75 0 11-1.5 0 .75.75 0 011.5 0zM18.75 12a.75.75 0 11-1.5 0 .75.75 0 011.5 0z"/>
                                    </svg>

                                </td>
                            </tr>
                            <tr id="{{ $d->id }}" style="display: none;">
                                <td colspan="14" class="text-xs p-5 bg-white border-b border-gray-300">
                                    @if(Auth::user()->role == "admin")
                                        <div class="flex items-center justify-between mb-4">
                                            <div>

                                                <div wire:loading.remove>
                                                    <button type="button"
                                                            wire:click.prevent="approvedSite({{ $d->id }})"
                                                            class="bg-green-700 text-white text-xs rounded px-6 py-2">
                                                        Approved
                                                    </button>
                                                    <button type="button" wire:click.prevent="rejectSite({{ $d->id }})"
                                                            class="bg-red-700 text-white text-xs rounded px-6 py-2">
                                                        Reject
                                                    </button>
                                                </div>
                                                <div wire:loading.block wire:target="approvedSite">
                                                    Loading...Please wait
                                                </div>

                                            </div>
                                            <a href="{{ route("admin.site_edit",[$d->id,"prev_url" => request()->fullUrl()]) }}"
                                               class="bg-blue-500 text-white p-1 rounded flex">
                                                <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24"
                                                     stroke-width="1.5" stroke="currentColor" class="w-4 h-4">
                                                    <path stroke-linecap="round" stroke-linejoin="round"
                                                          d="M16.862 4.487l1.687-1.688a1.875 1.875 0 112.652 2.652L10.582 16.07a4.5 4.5 0 01-1.897 1.13L6 18l.8-2.685a4.5 4.5 0 011.13-1.897l8.932-8.931zm0 0L19.5 7.125M18 14v4.75A2.25 2.25 0 0115.75 21H5.25A2.25 2.25 0 013 18.75V8.25A2.25 2.25 0 015.25 6H10"/>
                                                </svg>
                                            </a>


                                        </div>
                                    @endif
                                    <div>

                                        <div class="flex items-center border-b border-gray-100 pb-2 mb-2">
                                            <span class="text-orange-500 font-semibold w-48">Website Niche:</span>
                                            <span class="flex-1">{{ $d->website_niche }}</span>
                                        </div>
                                        <div class="flex items-center border-b border-gray-100 pb-2 mb-2">
                                            <span class="text-orange-500 font-semibold w-48">Sample Url:</span>
                                            <span class="flex-1">{{ $d->sample_url }}</span>
                                        </div>
                                        <div class="flex items-center border-b border-gray-100 pb-2 mb-2">
                                            <span class="text-orange-500 font-semibold w-48">Href URL</span>
                                            <span class="flex-1 break-words"
                                                  style="max-width: 50%">{{ $d->href_url }}</span>
                                        </div>

                                        <div
                                            class="flex items-center justify-between border-b border-gray-100 pb-2 mb-2">
                                            <div>
                                                <span class="text-orange-500 font-semibold">Paypal : </span>
                                                <span class="">{{ $d->paypal_id }}</span>
                                            </div>

                                            <div>
                                                <span class="text-orange-500 font-semibold">Skype : </span>
                                                <span class="">{{ $d->skype }}</span>
                                            </div>

                                            <div>
                                                <span class="text-orange-500 font-semibold">Whatsapp : </span>
                                                <span class="">{{ $d->whatsapp }}</span>
                                            </div>

                                            <div>
                                                <span class="text-orange-500 font-semibold">Country Source: </span>
                                                <span class="">{{ $d->country_source }}</span>
                                            </div>

                                        </div>

                                    </div>
                                </td>
                            </tr>
                        @endforeach

                        </tbody>
                    </table>

                </div>
                <div>
                    {!! $sites->links() !!}
                </div>

                <script>
                    $(function () {

                        if (localStorage) {
                            if (localStorage.getItem('menu') === 'open') {
                                $('#sidebar').css('width', '256px');
                            } else {
                                $('#sidebar').css('width', '0px');
                            }
                        }


                        $('body').on("click", 'svg.more_data', function () {
                            let tr = $(this).parents("td").parents("tr").next("tr").attr("id");
                            $('tr#' + tr).toggle();
                        });

                        $('#menu_sidebar').on("click", function () {
                            const width = $('#sidebar').css('width');
                            if (width === "0px") {
                                localStorage.setItem('menu', 'open');
                                $('#sidebar').css('width', '256px');
                            } else {
                                localStorage.setItem('menu', 'close');
                                $('#sidebar').css('width', '0px');
                            }
                        });


                    });
                </script>

            </div>

        </div>
    </div>

</div>
