<div>
    @include("admin.partials.messages")
    <div>
        {!! $users->links() !!}
    </div>

    <table class="w-full table-auto text-xs border border-gray-300 border-separate">
        <thead class="bg-gray-300">
        <tr>
            <th class="p-2 text-xs text-left">#</th>
            <th class="p-2 text-xs text-left">Name</th>
            <th class="p-2 text-xs text-left">Email
                <input type="search" wire:model.debounce.500ms="qemail" class="text-xs p-0.5">
            </th>
            <th class="p-2 text-xs text-left">Role
                <select class="text-xs p-0.5" wire:model="q_role">
                    <option value="">all</option>
                    <option value="vendor">vendor</option>
                    <option value="manager">manager</option>
                    <option value="team">team</option>
                    <option value="writer">writer</option>
                </select>
            </th>
            <th class="p-2 text-xs text-left">Action</th>
        </tr>
        </thead>


        <tbody>
            @php $i = $users->firstItem() @endphp
            @foreach($users as $user)
                <tr>
                    <td class="p-2 text-xs border border-gray-300">{{ $i++ }}</td>
                    <td class="p-2 text-xs border border-gray-300">{{ $user->name }}</td>
                    <td class="p-2 text-xs border border-gray-300">{{ $user->email }}</td>
                    <td class="p-2 text-xs border border-gray-300">{{ $user->role }}</td>
                    <td class="p-2 text-xs border border-gray-300">
                        @if($user->status == 1)
                            <button wire:click="changeStatus({{ $user->id }})" class="text-xs bg-green-600 text-white px-4 py-1">Active</button>
                        @endif

                        @if($user->status == 0)
                            <button wire:click="changeStatus({{ $user->id }})" class="text-xs bg-red-600 text-white px-4 py-1">Block</button>
                        @endif
                    </td>
                </tr>
            @endforeach
        </tbody>



    </table>


</div>
