@php use App\Models\Video; @endphp
@extends("frontend.layouts.master")

@section("container")

    <?php
        $videos= Video::where("active",1)->orderBy('id','desc')->get();
    ?>


    <div class="">
        <h2 class="text-3xl font-extrabold text-gray-900">
            Videos
        </h2>

        <div class="grid grid-cols-3 gap-8 mt-12">
            @foreach($videos as $video)
                <div class="bg-white p-4 shadow">
                    <div class="w-full aspect-video">
                        @php

                            $embed= Cohensive\OEmbed\Facades\OEmbed::get($video->link);
                             if( $embed ){
                                 echo $embed->html(['class'=>'aspect-video w-full']);
                             }

                        @endphp
                    </div>
                    <div class="mt-4 text-xl font-semibold text-gray-700">{{ $video->title }}</div>
                </div>
            @endforeach
        </div>

    </div>
@endsection
