<!doctype html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport"
          content="width=device-width, user-scalable=no, initial-scale=1.0, maximum-scale=1.0, minimum-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <link rel="stylesheet" href="/css/app.css">

    <script src="/js/app.js"></script>
    <title>Website</title>

<body class="bg-gray-100">
    <div>
        <div class="max-w-screen-xl mx-auto">
            @include("front.partials._messages")
        </div>
        <form action="{{ route("change_password") }}" method="POST" class="flex flex-col space-y-8 max-w-lg bg-white mx-auto border border-gray-200 px-6 pb-6 mt-12 mb-8">
            @csrf
            <div>
                <h1 class="text-pink-700 text-lg border-b pb-1 border-pink-700">Change Password</h1>
            </div>

            <div>
                <label class="label-h-class">Old Password</label>
                <div class="mt-1">
                    <input type="password" name="old_password" class="textbox-class">
                </div>
            </div>

            <div>
                <label class="label-h-class">New Password</label>
                <div class="mt-1">
                    <input type="password" name="new_password" class="textbox-class">
                </div>
            </div>

            <div>
                <label class="label-h-class">Confirm New Password</label>
                <div class="mt-1">
                    <input type="password" name="new_password_confirmation" class="textbox-class">
                </div>
            </div>
            <div>
                <button class="bg_primary_color shadow shadow-pink-900 py-3 text-white rounded-lg w-full font-medium uppercase">Change Password</button>
            </div>

            @if(auth()->user()->role == 'admin')
                <a class="block justify-center flex items-center text-center" href="{{ route("dashboard") }}">
                    <svg aria-hidden="true" focusable="false" data-prefix="fa-solid" data-icon="arrow-left-rotate" class="w-4 h-4 text-pink-700" role="img" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512"><path d="M47.998 16C65.668 16 79.992 30.324 79.992 47.992V93.305C124.859 44.789 188.227 16 256 16C388.344 16 496 123.656 496 256S388.344 496 256 496C203.531 496 153.75 479.406 111.969 447.969C94.312 434.687 90.75 409.625 104.031 391.969C117.344 374.312 142.437 370.75 160.031 384.031C187.844 404.938 221.031 416 256 416C344.219 416 416 344.219 416 256S344.219 96 256 96C205.246 96 158.059 120.094 128.057 160H128.176C128.174 160 128.172 160.008 128.17 160.008H192.006C209.676 160.008 224 174.336 224 192.004C224 209.676 209.674 224 192.004 224H47.996C39.158 224 31.158 220.422 25.369 214.633S16 200.844 16 192.004V47.996C16 30.324 30.326 16 47.998 16Z" fill="currentColor"/></svg>
                    <span class="ml-2 text-pink-700"> Return to Dashboard</span>
                </a>
            @endif

            @if(auth()->user()->role == 'vendor')
                <a class="block justify-center flex items-center text-center" href="{{ route("vendor.dashboard") }}">
                    <svg aria-hidden="true" focusable="false" data-prefix="fa-solid" data-icon="arrow-left-rotate" class="w-4 h-4 text-pink-700" role="img" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512"><path d="M47.998 16C65.668 16 79.992 30.324 79.992 47.992V93.305C124.859 44.789 188.227 16 256 16C388.344 16 496 123.656 496 256S388.344 496 256 496C203.531 496 153.75 479.406 111.969 447.969C94.312 434.687 90.75 409.625 104.031 391.969C117.344 374.312 142.437 370.75 160.031 384.031C187.844 404.938 221.031 416 256 416C344.219 416 416 344.219 416 256S344.219 96 256 96C205.246 96 158.059 120.094 128.057 160H128.176C128.174 160 128.172 160.008 128.17 160.008H192.006C209.676 160.008 224 174.336 224 192.004C224 209.676 209.674 224 192.004 224H47.996C39.158 224 31.158 220.422 25.369 214.633S16 200.844 16 192.004V47.996C16 30.324 30.326 16 47.998 16Z" fill="currentColor"/></svg>
                    <span class="ml-2 text-pink-700"> Return to Dashboard</span>
                </a>
            @endif

            @if(auth()->user()->role == 'team')
                <a class="block justify-center flex items-center text-center" href="{{ route("team.dashboard") }}">
                    <svg aria-hidden="true" focusable="false" data-prefix="fa-solid" data-icon="arrow-left-rotate" class="w-4 h-4 text-pink-700" role="img" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512"><path d="M47.998 16C65.668 16 79.992 30.324 79.992 47.992V93.305C124.859 44.789 188.227 16 256 16C388.344 16 496 123.656 496 256S388.344 496 256 496C203.531 496 153.75 479.406 111.969 447.969C94.312 434.687 90.75 409.625 104.031 391.969C117.344 374.312 142.437 370.75 160.031 384.031C187.844 404.938 221.031 416 256 416C344.219 416 416 344.219 416 256S344.219 96 256 96C205.246 96 158.059 120.094 128.057 160H128.176C128.174 160 128.172 160.008 128.17 160.008H192.006C209.676 160.008 224 174.336 224 192.004C224 209.676 209.674 224 192.004 224H47.996C39.158 224 31.158 220.422 25.369 214.633S16 200.844 16 192.004V47.996C16 30.324 30.326 16 47.998 16Z" fill="currentColor"/></svg>
                   <span class="ml-2 text-pink-700"> Return to Dashboard</span>
                </a>
            @endif

            @if(auth()->user()->role == 'writer')
                <a class="block justify-center flex items-center text-center" href="{{ route("writer.dashboard") }}">
                    <svg aria-hidden="true" focusable="false" data-prefix="fa-solid" data-icon="arrow-left-rotate" class="w-4 h-4 text-pink-700" role="img" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512"><path d="M47.998 16C65.668 16 79.992 30.324 79.992 47.992V93.305C124.859 44.789 188.227 16 256 16C388.344 16 496 123.656 496 256S388.344 496 256 496C203.531 496 153.75 479.406 111.969 447.969C94.312 434.687 90.75 409.625 104.031 391.969C117.344 374.312 142.437 370.75 160.031 384.031C187.844 404.938 221.031 416 256 416C344.219 416 416 344.219 416 256S344.219 96 256 96C205.246 96 158.059 120.094 128.057 160H128.176C128.174 160 128.172 160.008 128.17 160.008H192.006C209.676 160.008 224 174.336 224 192.004C224 209.676 209.674 224 192.004 224H47.996C39.158 224 31.158 220.422 25.369 214.633S16 200.844 16 192.004V47.996C16 30.324 30.326 16 47.998 16Z" fill="currentColor"/></svg>
                    <span class="ml-2 text-pink-700"> Return to Dashboard</span>
                </a>
            @endif


        </form>
    </div>
</body>
</html>
