@extends("frontend.layouts.master")

@section("container")
    <div class="bg-white p-6 mt-4">

        <div class="flex items-end justify-center">
            <div class="text-center mt-6 font-black text-3xl">
                <span class="text-primary-color">Submit your</span> Profile
            </div>
            <div class="ml-2 bg-black mb-2 h-1 w-24"></div>
        </div>
        <div class="lg:p-6">
            <div class="mt-4 mb-4">

            </div>
            <form action="{{ route("submit_profile",$career->id) }}" method="post" enctype="multipart/form-data">
                @csrf
                <div class="max-w-2xl mx-auto border bg-white border-gray-200 p-4 lg:p-8">
                    <div>

                        @include('admin.partials.messages')
                        @if (count($errors) > 0)
                            <div class="rounded-md bg-red-50 p-4 mb-4">
                                <div class="flex">
                                    <div class="flex-shrink-0">
                                        <svg class="h-5 w-5 text-red-400" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 20 20" fill="currentColor" aria-hidden="true">
                                            <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zM8.707 7.293a1 1 0 00-1.414 1.414L8.586 10l-1.293 1.293a1 1 0 101.414 1.414L10 11.414l1.293 1.293a1 1 0 001.414-1.414L11.414 10l1.293-1.293a1 1 0 00-1.414-1.414L10 8.586 8.707 7.293z" clip-rule="evenodd" />
                                        </svg>
                                    </div>
                                    <div class="ml-3">
                                        <h3 class="text-sm font-medium text-red-800">
                                            There were {{ count($errors->all()) }} errors with your submission
                                        </h3>
                                        <div class="mt-2 text-sm text-red-700">
                                            <ul class="list-disc pl-5 space-y-1">
                                                @foreach ($errors->all() as $error)
                                                    <li>{{ $error }}</li>
                                                @endforeach
                                            </ul>
                                        </div>
                                    </div>
                                </div>
                            </div>


                        @endif
                    </div>
                    <div>
                        <label class="label-h-class text-xs">Name <span class="text-red-600">*</span></label>
                        <div class="mt-1">
                            <input type="text" name="name" class="textbox-class" placeholder="Enter your name" value="{{ old('name') }}">
                        </div>
                    </div>

                    <div class="mt-8">
                        <label class="label-h-class text-xs">Email <span class="text-red-600">*</span></label>
                        <div class="mt-1">
                            <input type="text" name="email" class="textbox-class" placeholder="Enter your email" value="{{ old('email') }}">
                        </div>
                    </div>

                    <div class="mt-8">
                        <label class="label-h-class text-xs">Mobile No <span class="text-red-600">*</span></label>
                        <div class="mt-1">
                            <input type="text" name="mobile" class="textbox-class" placeholder="Enter your Mobile No." value="{{ old('mobile') }}">
                        </div>
                    </div>

                    <div class="mt-8">
                        <label class="label-h-class text-xs">Where are you currently located <span class="text-red-600">*</span></label>
                        <div class="mt-1">
                            <input type="text" name="location" class="textbox-class" placeholder="Location" value="{{ old('location') }}">
                        </div>
                    </div>

                    <div class="mt-8">
                        <label class="label-h-class text-xs">Cover Letter <span class="text-red-600">*</span></label>
                        <div class="mt-1">
                            <textarea type="text" name="cover_letter" class="textbox-class h-24">{{ old('cover_letter') }}</textarea>
                        </div>
                    </div>

                    <div class="mt-8">
                        <label class="label-h-class text-xs">Upload Resume <span class="text-red-600">*</span></label>
                        <div class="mt-1">
                            <input type="file" name="resume" class="file-h-class"/>
                        </div>
                    </div>


                    <div class="mt-8">
                        <button class="bg_primary_color rounded-lg shadow text-white font-semibold py-3 w-full">Upload your CV</button>
                    </div>
                </div>
            </form>
        </div>
    </div>
@endsection
