@php use App\Models\Faq; @endphp
@extends("frontend.layouts.master")

@section("container")
<?php
    $faqs= Faq::where('active',1)->get();
?>
<div class="bg-white">
    <div class="max-w-7xl mx-auto py-16 px-4 sm:px-6 lg:py-20 lg:px-8">
        <div class="lg:grid lg:grid-cols-3 lg:gap-8">
            <div>
                <h2 class="text-3xl font-extrabold text-gray-900">
                    Frequently asked questions
                </h2>
                <p class="mt-4 text-lg text-gray-500">Can’t find the answer you’re looking for? Reach out to our
                    <a href="#" class="font-medium text-primary-color hover:text-indigo-500">customer support</a> team.</p>
            </div>
            <div class="mt-12 lg:mt-0 lg:col-span-2">
                <dl class="space-y-12">
                    @foreach($faqs as $faq)
                        <div>
                            <dt class="text-lg leading-6 font-semibold text-primary-color">
                                {{ $faq->question }}
                            </dt>
                            <dd class="mt-2 text-base text-gray-500">
                                {{ $faq->answer }}
                            </dd>
                        </div>
                    @endforeach

                </dl>
            </div>
        </div>
    </div>
</div>
@endsection
