@php use App\Project\NewOrderStatus;use Carbon\Carbon; @endphp
<x-filament-panels::page>
    <style>
        .order_detail{
            border-collapse: collapse;
            font-size: 13px;
        }
        .order_detail th{
            padding: 10px 20px;
            border:1px solid #737373;
            color: #525252;
            background: #d4d4d4;

        }
        .order_detail td{
            padding: 10px 20px;
            text-align: center;
            border:1px solid #737373;
            color: #525252;
        }
        .box{
            background: #d4d4d4;
            font-size: 13px;
            margin-bottom: 10px;
        }
        .box h2{
            font-weight: bold;
            color: #262626;
            font-size: 14px;
            margin-bottom: 7px;
        }
        .box .time{
            background: #262626;
            color: #f5f5f5;
            font-size: 11px;
            font-weight: bold;
            padding: 7px;
        }
        .box .inner{
            padding: 10px;
        }
        .box p{

        }
        .box p span{
            text-decoration: underline;
        }
        .box .table-container{
            background: white;
            padding: 10px;
            /*display: inline-block;*/
            margin-top: 10px;
        }
        .box table{
            width: 100%;
        }
        .box th{
            text-align: left;
            padding: 10px;
            font-size: 12px;
            border-bottom: 1px solid #CCCCCC;
        }
        .box td{
            text-align: left;
            padding:  10px;
            font-size: 12px;

        }
        .box .note_class{
            background: #f3f3f3;
            font-weight: bold;
        }
        .box .empty_class{
            border-bottom: 1px solid #CCCCCC;
        }
        .box .empty_class td{
            padding: 0;
        }
    </style>
    <div class="bg-white p-4 shadow mt-6">
        @if($order)

            <div class="">
                <div class="">
                    <table class="order_detail" style="width: 100%;margin-bottom: 16px;">
                        <tr>
                            <th >Status</th>
                            <th >Order Id</th>
                        </tr>
                        <tr>
                            <td >{{ order_status($order->new_order_status) }}</td>

                            <td >{{ $order->order_id }}</td>
                        </tr>

                    </table>
                </div>
                <div class="">



                    @foreach($order->new_order_processes as $process)





                        @if( $process->status == NewOrderStatus::$MANAGER_PUSHED_TO_WRITER )
                            <div class="box">
                                <div class="time">{{ Carbon::parse($process->created_at)->toDayDateTimeString() }}</div>
                                <div class="">



                                    <div class="inner">
                                        <h2 class="">
                                            {{ new_order_status($process->status) }}
                                        </h2>
                                        <div class="table-container">
                                            <table class="">


                                            @foreach($process->new_order_process_details  as $detail)
                                                <tr>
                                                    <td >Root Domain</td>
                                                    <td >{{ $detail->new_site->root_domain }}</td>
                                                </tr>
                                                <tr>
                                                    <td >Url</td>
                                                    <td >{{ $detail->ourl }}</td>
                                                </tr>
                                                <tr>
                                                    <td >Anchor</td>
                                                    <td >{{ $detail->anchor }}</td>
                                                </tr>
                                                @if($order->order_type == "gp")
                                                    <tr>
                                                        <td >Title</td>
                                                        <td >{{ $detail->title }}</td>
                                                    </tr>
                                                @endif

                                                    <tr class="empty_class">
                                                        <td></td>
                                                        <td></td>
                                                    </tr>

                                            @endforeach

                                            <tr class="note_class">
                                                <td >Note</td>
                                                <td >
                                                    {{ $process->note }}
                                                </td>
                                            </tr>
                                        </table>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        @endif

                        @if( $process->status == NewOrderStatus::$WRITER_PUSHED_TO_MANAGER )
                            <div class="box">
                                <div class="time">{{ Carbon::parse($process->created_at)->toDayDateTimeString() }}</div>
                                <div class="inner">

                                    <h2 class="">
                                        {{ new_order_status($process->status) }}
                                    </h2>
                                    <div class="">
                                        <table class="table-container">

                                            @foreach($process->new_order_process_details  as $detail)

                                                <tr>
                                                    <td >Root Domain</td>
                                                    <td >{{ $detail->new_site->root_domain }}</td>
                                                </tr>
                                                @if($order->order_type == "gp" )
                                                    <tr>
                                                        <td >Upload Doc File</td>
                                                        <td >
                                                            @if($detail->upload_doc_file)
                                                                <a href="{{ url("/upload/".$detail->upload_doc_file) }}" class="text-xs font-bold underline text-black">Click to Download</a>
                                                            @endif
                                                        </td>
                                                    </tr>
                                                    <tr>
                                                        <td >Doc URLS</td>
                                                        <td class="text-xs border border-gray-300 p-3 "><div class="break-words w-full">{{ $detail->doc_urls }}</div></td>
                                                    </tr>
                                                @endif

                                                @if($order->order_type == "niche" )
                                                    <tr>
                                                        <td >Type</td>
                                                        <td ><div class="break-words w-full">{{ $detail->type }}</div></td>
                                                    </tr>
                                                    @if($detail->type == 'insert')
                                                        <tr>
                                                            <td >Insert After</td>
                                                            <td ><div class="break-words w-full">{!! $detail->insert_after !!}</div></td>
                                                        </tr>
                                                        <tr>
                                                            <td >Insert Statement</td>
                                                            <td ><div class="break-words w-full">{!! $detail->statement !!}</div></td>
                                                        </tr>
                                                    @endif

                                                    @if($detail->type == 'replace')
                                                        <tr>
                                                            <td >Replace With</td>
                                                            <td ><div class="break-words w-full">{!! $detail->insert_after !!}</div></td>
                                                        </tr>
                                                        <tr>
                                                            <td >Replace Statement</td>
                                                            <td ><div class="break-words w-full">{!! $detail->statement !!}</div></td>
                                                        </tr>
                                                    @endif

                                                @endif
                                                <tr class="empty_class">
                                                    <td></td>
                                                    <td></td>
                                                </tr>
                                                <tr class="note_class">
                                                    <td >Note</td>
                                                    <td >{{ $detail->note }}</td>
                                                </tr>

                                            @endforeach

                                        </table>
                                    </div>
                                </div>
                            </div>
                        @endif


                        @if( $process->status == NewOrderStatus::$MANAGER_REJECTED_AND_PUSHED_BACK_TO_WRITER )
                            <div class="flex items-start w-full mt-8">
                                <div class="w-24  flex justify-end mr-8 mt-4">
                                    <svg xmlns="http://www.w3.org/2000/svg" class="text-slate-800 w-8 h-8"
                                         viewBox="0 0 640 512">
                                        <path
                                            d="M128 120c-13.3 0-24-10.7-24-24s10.7-24 24-24s24 10.7 24 24s-10.7 24-24 24zm32 49.3c28.3-12.3 48-40.5 48-73.3c0-44.2-35.8-80-80-80S48 51.8 48 96c0 32.8 19.7 61 48 73.3V224H32c-17.7 0-32 14.3-32 32s14.3 32 32 32H288v54.7c-28.3 12.3-48 40.5-48 73.3c0 44.2 35.8 80 80 80s80-35.8 80-80c0-32.8-19.7-61-48-73.3V288H608c17.7 0 32-14.3 32-32s-14.3-32-32-32H544V169.3c28.3-12.3 48-40.5 48-73.3c0-44.2-35.8-80-80-80s-80 35.8-80 80c0 32.8 19.7 61 48 73.3V224H160V169.3zM536 96c0 13.3-10.7 24-24 24s-24-10.7-24-24s10.7-24 24-24s24 10.7 24 24zM320 440c-13.3 0-24-10.7-24-24s10.7-24 24-24s24 10.7 24 24s-10.7 24-24 24z"
                                            fill="currentColor"/>
                                    </svg>
                                </div>
                                <div class="border border-gray-300 p-4 flex-1">

                                    <div class="font-semibold text-red-500 text-sm uppercase">
                                        {{ new_order_status($process->status) }}
                                    </div>
                                    <div class="text-xs text-slate-700 mt-1">{{ $process->created_at }}</div>
                                    <div class="mt-4">
                                        <table class="table-auto border-separate">
                                            <tr>
                                                <td >Note</td>
                                                <td >
                                                    {{ $process->note }}
                                                </td>
                                            </tr>
                                        </table>
                                    </div>
                                </div>
                            </div>
                        @endif






                    @endforeach


                </div>
            </div>
        @endif
    </div>

</x-filament-panels::page>
