<?php

namespace App\Providers\Filament;

use App\Filament\Auth\BloggerLogin;
use App\Filament\Auth\ManagerLogin;
use App\Filament\Blogger\Pages\ChangePassword;
use App\Filament\Blogger\Pages\Profile;
use App\Filament\Blogger\Widgets\BloggerOrdersWidget;
use App\Filament\Blogger\Widgets\BloggerStatsWidget;
use App\Filament\Blogger\Widgets\TodayCompletedOrderWidget;
use App\Filament\Blogger\Widgets\TodayOrderWidget;
use App\Filament\Blogger\Widgets\TodayRejectedOrderWidget;
use App\Filament\Blogger\Widgets\TodayWaitingOrderWidget;
use App\Http\Middleware\BloggerMiddleware;
use Filament\Http\Middleware\Authenticate;
use Filament\Http\Middleware\DisableBladeIconComponents;
use Filament\Http\Middleware\DispatchServingFilamentEvent;
use Filament\Navigation\MenuItem;
use Filament\Pages;
use Filament\Panel;
use Filament\PanelProvider;
use Filament\Support\Colors\Color;
use Filament\Support\Enums\MaxWidth;
use Filament\Widgets;
use Illuminate\Cookie\Middleware\AddQueuedCookiesToResponse;
use Illuminate\Cookie\Middleware\EncryptCookies;
use Illuminate\Foundation\Http\Middleware\VerifyCsrfToken;
use Illuminate\Routing\Middleware\SubstituteBindings;
use Illuminate\Session\Middleware\AuthenticateSession;
use Illuminate\Session\Middleware\StartSession;
use Illuminate\Support\Facades\View;
use Illuminate\View\Middleware\ShareErrorsFromSession;

class BloggerPanelProvider extends PanelProvider
{
    public function panel(Panel $panel): Panel
    {
        return $panel
            ->id('blogger')
            ->path('blogger')
            ->brandName("Link Management")
            ->brandLogo(asset("images/logo1.jpeg"))
//            ->login(BloggerLogin::class)
            ->login()
            ->sidebarCollapsibleOnDesktop()
            ->topNavigation(true)
            ->maxContentWidth(MaxWidth::Full)
            ->colors([
                'primary' => Color::Amber,
            ])
//            ->renderHook('panels::auth.login.form.before',function (){
//                return view('blogger_login');
//            })
            ->discoverResources(in: app_path('Filament/Blogger/Resources'), for: 'App\\Filament\\Blogger\\Resources')
            ->discoverPages(in: app_path('Filament/Blogger/Pages'), for: 'App\\Filament\\Blogger\\Pages')
            ->pages([
                Pages\Dashboard::class,
            ])
            ->discoverWidgets(in: app_path('Filament/Blogger/Widgets'), for: 'App\\Filament\\Blogger\\Widgets')
            ->widgets([
                BloggerStatsWidget::class,
                BloggerOrdersWidget::class,
                TodayOrderWidget::class,
                TodayWaitingOrderWidget::class,
                TodayRejectedOrderWidget::class,
                TodayCompletedOrderWidget::class
            ])
            ->userMenuItems([
                MenuItem::make()->label("Profile")
                    ->icon('heroicon-o-user')
                    ->url(function (){
                        return Profile::getUrl();
                    }),
                MenuItem::make()->label("Change Password")
                    ->icon('heroicon-o-cog-6-tooth')
                    ->url(function (){
                        return ChangePassword::getUrl();
                    }),
            ])
            ->middleware([
                EncryptCookies::class,
                AddQueuedCookiesToResponse::class,
                StartSession::class,
                AuthenticateSession::class,
                ShareErrorsFromSession::class,
                VerifyCsrfToken::class,
                SubstituteBindings::class,
                DisableBladeIconComponents::class,
                DispatchServingFilamentEvent::class,
            ])
            ->darkMode(false)
            ->databaseNotifications()
            ->databaseNotificationsPolling('60s')
            ->authMiddleware([
                Authenticate::class,
                BloggerMiddleware::class
            ]);
    }
}
