<?php


namespace App\Project\Shared;


use App\Exceptions\ExcelFileHeadingNotFound;
use Maatwebsite\Excel\HeadingRowImport;

class ExcelHeadingsValidate
{
    /**
     * @throws ExcelFileHeadingNotFound
     */
    public static function validate($uploaded_filename_with_path)
    {
        $headings= ( new HeadingRowImport )->toArray($uploaded_filename_with_path);
        if( $headings[0][0][0] !== 'root_domain' ) { throw  new ExcelFileHeadingNotFound("root domain column not found"); }
        if( $headings[0][0][1] !== 'dr' ) { throw  new ExcelFileHeadingNotFound("dr column not found"); }
        if( $headings[0][0][2] !== 'rd' ) { throw  new ExcelFileHeadingNotFound("rd column not found"); }
        if( $headings[0][0][3] !== 'traffic' ) { throw  new ExcelFileHeadingNotFound("traffic column not found"); }
        if( $headings[0][0][4] !== 'da' ) { throw  new ExcelFileHeadingNotFound("da column not found"); }
        if( $headings[0][0][5] !== 'categoryniche' ) { throw  new ExcelFileHeadingNotFound("Category/Niche column not found"); }
        if( $headings[0][0][6] !== 'spam_score' ) { throw  new ExcelFileHeadingNotFound("Spam Score column not found"); }
        if( $headings[0][0][7] !== 'deal_gp_price' ) { throw  new ExcelFileHeadingNotFound("Deal GP Price column not found"); }
        if( $headings[0][0][8] !== 'deal_link_insertion_price' ) { throw  new ExcelFileHeadingNotFound("Deal Link Insertion Price column not found"); }
        if( $headings[0][0][9] !== 'deal_cbd_casino_adult_price' ) { throw  new ExcelFileHeadingNotFound("Deal CBD, Casino, Adult Price column not found"); }
        if( $headings[0][0][10] !== 'blogger_email' ) { throw  new ExcelFileHeadingNotFound("Blogger Email column not found"); }
    }
}
