<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class WithdrawRequest extends Model
{
    use HasFactory;

    public function user()
    {
        return $this->belongsTo(User::class);
    }

    public function wallet_histories()
    {
        return $this->hasMany(WalletHistory::class);
    }

    public function request_date()
    {
        return $this->hasOne(WalletHistory::class)->orderBy('id','desc');
    }

    public function remarks_data()
    {
        return $this->hasOne(WalletHistory::class)->orderBy('id','desc');
    }

}
