<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Career extends Model
{
    use HasFactory;

    protected  $fillable = ["title","experience","qualification","skills"];

    public function career_applies()
    {
        return $this->hasMany(CareerApply::class);
    }


    public function status()
    {
        if( $this->active == 0 ){
            return 'disabled';
        }else{
            return 'enable';
        }
    }
}
