<?php

namespace App\Livewire\Vendor;

use App\Models\Wallet;
use App\Models\WalletHistory;
use App\Models\WithdrawRequest;
use Carbon\Carbon;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Livewire\Component;

class WithdrawRequestLivewire extends Component
{
    public $selected_bills= [];
    public $amount = "";
    public $total = 0;
    public $payment_method= "";

    public $paypal_id= "";
    public $paypal_link= "";

    public $bank_type = "";
    public $beneficiary_account_number = "";
    public $beneficiary_name = "";
    public $customer_reference_number = "";
    public $ifsc_code = "";
    public $bene_bank_name = "";
    public $bene_bank_branch_name = "";
    public $beneficiary_email_id = "";


    public function mount()
    {
        $this->bank_type = Auth::user()->bank_type;
        $this->beneficiary_name = Auth::user()->beneficiary_name;
        $this->beneficiary_account_number = Auth::user()->beneficiary_account_number;
        $this->customer_reference_number = Auth::user()->customer_reference_number;
        $this->ifsc_code = Auth::user()->ifsc_code;
        $this->bene_bank_name = Auth::user()->bene_bank_name;
        $this->bene_bank_branch_name = Auth::user()->bene_bank_branch_name;
        $this->beneficiary_email_id = Auth::user()->beneficiary_email_id;
        $this->paypal_id = Auth::user()->paypal_email;
        $this->paypal_invoice_link = Auth::user()->paypal_invoice_link;
        $this->upi_id = Auth::user()->upi_id;
    }

    public function updatedSelectedBills()
    {
        $t =  $histories = WalletHistory::with("new_order_process_detail.new_order_process.new_order")->whereHas('wallet',function ($q){
            $q->where('user_id',Auth::id());
        })->whereIn('id',$this->selected_bills)->get();

        $this->total = $t->sum('price');
    }


    public function render()
    {
        $wallet= Wallet::where('user_id',Auth::id())->first();
        $histories = WalletHistory::with("new_order_process_detail.new_order_process.new_order")->whereHas('wallet',function ($q){
            $q->where('user_id',Auth::id());
        })->where('status',null)->where('request_date',null)->where('approved_date',null)->get();
        return view('livewire.vendor.withdraw-request-livewire',compact("wallet","histories"));
    }

    public function withdrawRequest()
    {

//        dd($this->payment_method);
        $this->validate([
//            "amount"    =>  "required",
            "payment_method"    =>  "required"
        ]);

        if(count($this->selected_bills) == 0){
            session()->flash("error","Select at least one Order");
            return '';
        }
        elseif($this->payment_method == 'bank'){
            if(
                Auth::user()->bank_type == null ||
                Auth::user()->beneficiary_name == null ||
                Auth::user()->beneficiary_account_number == null ||
                Auth::user()->customer_reference_number == null ||
                Auth::user()->bene_bank_name == null ||
                Auth::user()->bene_bank_branch_name == null ||
                Auth::user()->beneficiary_email_id == null ||
                Auth::user()->ifsc_code == null
            ){
                session()->flash("error","Bank Details are missing");
                return '';
            }
        }elseif ($this->payment_method == 'paypal_id'){
            if(Auth::user()->paypal_email == null ){
                session()->flash("error","Paypal Id is missing");
                return '';
            }
        }elseif ($this->payment_method == 'qr_code'){
            if(Auth::user()->qr_code_image == null ){
                session()->flash("error","QR Code is missing");
                return '';
            }
        }elseif ($this->payment_method == 'upi_id'){
            if(Auth::user()->upi_id == null ||
                Auth::user()->bank_type == null ||
                Auth::user()->beneficiary_name == null ||
                Auth::user()->beneficiary_account_number == null ||
                Auth::user()->customer_reference_number == null ||
                Auth::user()->bene_bank_name == null ||
                Auth::user()->bene_bank_branch_name == null ||
                Auth::user()->beneficiary_email_id == null ||
                Auth::user()->ifsc_code == null
            ){
                session()->flash("error","UPI ID is missing or Bank Details are missing");
                return '';
            }
        }else{

        }


//        dd("END");
//        if($this->amount == "0"){
//            session()->flash("error","Enter Amount");
//        }



        try{




                DB::beginTransaction();


                $withdraw_request = new WithdrawRequest();
                $withdraw_request->user_id = Auth::id();
                $withdraw_request->status = 0;
                $withdraw_request->save();
                foreach ($this->selected_bills as $bill) {
                    $history = WalletHistory::whereHas('wallet', function ($q) {
                        $q->where('user_id', Auth::id());
                    })->where('id', $bill)->firstOrFail();


                    $history->payment_method = $this->payment_method;
                    $history->request_date = Carbon::now();
                    if ($this->payment_method == 'bank') {
                        $history->bank_type = Auth::user()->bank_type;
                        $history->beneficiary_name = Auth::user()->beneficiary_name;
                        $history->beneficiary_account_number = Auth::user()->beneficiary_account_number;
                        $history->customer_reference_number = Auth::user()->customer_reference_number;
                        $history->ifsc_code = Auth::user()->ifsc_code;
                        $history->bene_bank_name = Auth::user()->bene_bank_name;
                        $history->bene_bank_branch_name = Auth::user()->bene_bank_branch_name;
                        $history->beneficiary_email_id = Auth::user()->beneficiary_email_id;
                    } elseif ($this->payment_method == 'paypal_id') {
                        $history->paypal_email = Auth::user()->paypal_email;
                    } elseif ($this->payment_method == 'qr_code') {
                        $history->qr_code_image = Auth::user()->qr_code_image;
                    } elseif ($this->payment_method == 'upi_id') {
                        $history->upi_id = Auth::user()->upi_id;
                    }
                    $history->status = 0;
                    $history->withdraw_request_id = $withdraw_request->id;
                    $history->save();
                }



                DB::commit();
                return redirect()->route("vendor.wallet_index")->with("success", "Request Sent");
        }catch (\Exception $exception){
            DB::rollBack();
            session()->flash("error",$exception->getMessage());
        }


    }
}
