<?php

namespace App\Livewire\Vendor;

use App\Models\BulkUpload;
use App\Models\BulkUploadSite;
use App\Models\NewSite;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Livewire\Component;

class BulkPendingUploadedSites extends Component
{
    public $data = [];
    public $id = null;

    public function __construct($id)
    {
        $this->id = $id;
    }

    public function render()
    {
        $this->data = BulkUploadSite::where('bulk_upload_id',$this->id)->get();
        return view('livewire.vendor.bulk-pending-uploaded-sites');
    }

    public function accept($id)
    {
       try{
           $bulk_upload_site= BulkUploadSite::findOrFail($id);

            DB::beginTransaction();
           $new_site= new NewSite();
           $new_site->uploaded_user_id = Auth::id();
           $new_site->association_type = $bulk_upload_site->association_type;
           $new_site->domain_type = $bulk_upload_site->domain_type;
           $new_site->root_domain = $bulk_upload_site->root_domain;
           $new_site->niche = $bulk_upload_site->niche;
           $new_site->category = $bulk_upload_site->category;
           $new_site->traffic_source = $bulk_upload_site->traffic_source;
           $new_site->spam_score = $bulk_upload_site->spam_score;
           $new_site->word_count = $bulk_upload_site->word_count;
           $new_site->sample_url = $bulk_upload_site->sample_url;
           $new_site->marked_sponsor = $bulk_upload_site->marked_sponsor;
           $new_site->link_type = $bulk_upload_site->link_type;
           $new_site->link_validity = $bulk_upload_site->link_validity;
           $new_site->accept_grey_niche = $bulk_upload_site->accept_grey_niche;
           $new_site->grey_niche_types = $bulk_upload_site->grey_niche_types;
           $new_site->da = $bulk_upload_site->da;
           $new_site->dr = $bulk_upload_site->dr;
           $new_site->traffic = $bulk_upload_site->traffic;
           $new_site->gp_price = $bulk_upload_site->gp_price;
           $new_site->rd = $bulk_upload_site->rd;
           $new_site->niche_edit_price = $bulk_upload_site->niche_edit_price;
           $new_site->deal_cbd_casino = $bulk_upload_site->deal_cbd_casino;
           $new_site->email = $bulk_upload_site->email;
           $new_site->site_status = $bulk_upload_site->site_status;
           $new_site->source = $bulk_upload_site->source;
           $new_site->save();


           $bulk_upload_site->delete();

            DB::commit();
       }catch (\Exception $exception){
            DB::rollBack();
       }
    }

}
