<?php

namespace App\Livewire;

use App\Harman\Helpers\FileProcess;
use Illuminate\Support\Facades\Auth;
use Livewire\Component;
use Livewire\WithFileUploads;

class PaymentDetailsLivewire extends Component
{
    use WithFileUploads;
    public $bank_type = "";
    public $beneficiary_account_number = "";
    public $beneficiary_name = "";
    public $customer_reference_number = "";
    public $ifsc_code = "";
    public $bene_bank_name = "";
    public $bene_bank_branch_name = "";
    public $beneficiary_email_id = "";

    public $upi_id = "";
    public $qr_code_image = "";

    public $paypal_id = "";
//    public $paypal_invoice_link = "";

    public function mount()
    {
        $this->bank_type = Auth::user()->bank_type;
        $this->beneficiary_name = Auth::user()->beneficiary_name;
        $this->beneficiary_account_number = Auth::user()->beneficiary_account_number;
        $this->customer_reference_number = Auth::user()->customer_reference_number;
        $this->ifsc_code = Auth::user()->ifsc_code;
        $this->bene_bank_name = Auth::user()->bene_bank_name;
        $this->bene_bank_branch_name = Auth::user()->bene_bank_branch_name;
        $this->beneficiary_email_id = Auth::user()->beneficiary_email_id;
        $this->upi_id = Auth::user()->upi_id;

        $this->paypal_id = Auth::user()->paypal_email;
//        $this->paypal_invoice_link = Auth::user()->paypal_invoice_link;
    }


    public function render()
    {
        return view('livewire.payment-details-livewire');
    }

    public function savePayment()
    {
       try{
           $u= Auth::user();
           $u->bank_type = $this->bank_type;
           $u->beneficiary_name = $this->beneficiary_name;
           $u->beneficiary_account_number = $this->beneficiary_account_number;
           $u->customer_reference_number = $this->customer_reference_number;
           $u->ifsc_code = $this->ifsc_code;
           $u->bene_bank_name = $this->bene_bank_name;
           $u->bene_bank_branch_name = $this->bene_bank_branch_name;
           $u->beneficiary_email_id = $this->beneficiary_email_id;
           $u->upi_id = $this->upi_id;

           if($this->qr_code_image){

               $f= new FileProcess();
               $f->init("uploads", $this->qr_code_image);
               $f->unique("users", "qr_code_image");
               $f->prefix("qrcode_");
               $filename = $f->upload();
               $u->qr_code_image = $filename;
           }

           $u->paypal_email = $this->paypal_id;
//           $u->paypal_invoice_link = $this->paypal_invoice_link;
           $u->save();

           session()->flash("success","Payment Details Updated");
       }catch (\Exception $exception){
           session()->flash("error",$exception->getMessage());
       }
    }

}
