<?php

namespace App\Livewire\Manager\Messages;

use App\Models\Message;
use App\Models\Thread;
use Illuminate\Database\Eloquent\ModelNotFoundException;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Livewire\Component;

class ThreadDetailLivewire extends Component
{
    public $message= "";
    public $thread_id;

    public function render()
    {
        try{
            $thread= Thread::where(function ($query){
                $query->where('user_id',Auth::id())->orWhere('owner_id',Auth::id());
            })->where('id',$this->thread_id)->firstOrFail();
            $messages= Message::where('thread_id',$thread->id)->orderBy('id','desc')->get();

            return view('livewire.manager.messages.thread-detail-livewire',compact("thread","messages"));

        }catch (ModelNotFoundException $exception){
            abort(404);
        }
    }

    public function postMessage()
    {
        $this->validate([
           "message"    =>  "required"
        ]);

        try{

            DB::beginTransaction();
            $message= new Message();
            $message->thread_id= $this->thread_id;
            $message->user_id= Auth::id();
            $message->message= $this->message;
            $message->save();

            $thread= Thread::findOrFail($this->thread_id);
            $thread->updated_at= now();
            $thread->save();

            DB::commit();
            session()->flash("success","Message Sent");
            $this->message = "";
        }catch (\Exception $exception){
            DB::rollBack();
            session()->flash("error",$exception->getMessage());
        }

    }

}
