<?php

namespace App\Imports;

use App\Models\PreviousOrder;
use Maatwebsite\Excel\Concerns\ToModel;
use Maatwebsite\Excel\Concerns\WithHeadingRow;

class PreviousOrderImport implements ToModel, WithHeadingRow
{
    /**
    * @param array $row
    *
    * @return \Illuminate\Database\Eloquent\Model|null
    */
    public function model(array $row)
    {

        return new PreviousOrder([
            "past_order_root_domain" => $row['past_order_root_domain'],
            "blogger_root_domain" => $row['blogger_root_domain'],
            "target_client_url" => $row['target_client_url'],
            "live_link_delivery" => $row['live_link_delivery'],
        ]);
    }
}
