<?php

namespace App\Imports;

use App\Exceptions\ExcelFileHeadingNotFound;
use App\Models\NewSite;
use App\Project\Shared\ExcelImportColumns;
use App\Project\Shared\SiteStatusOptions;
use App\Project\Site\NewSiteStatus;
use Illuminate\Support\Facades\Auth;
use Maatwebsite\Excel\Concerns\ToModel;
use Maatwebsite\Excel\Concerns\WithHeadingRow;
use Maatwebsite\Excel\HeadingRowImport;
use function Symfony\Component\Mime\Header\get;

class NewSiteImport implements ToModel, WithHeadingRow
{

    private $uploaded_user_id;
    private $site_status;
    private $source;
    private $bulk_upload_id;
    private $bulk_upload_status;

    public function __construct($uploaded_user_id, $site_status, $source, $bulk_upload_id, $bulk_upload_status)
    {
        $this->uploaded_user_id = $uploaded_user_id;
        $this->site_status = $site_status;
        $this->source = $source;
        $this->bulk_upload_id = $bulk_upload_id;
        $this->bulk_upload_status = $bulk_upload_status;
    }

    /**
     * @param array $row
     *
     * @return \Illuminate\Database\Eloquent\Model|null
     * @throws \Exception
     */
    public function model(array $row)
    {

        if(!empty($row['root_domain'])) {
            $data = [
                "uploaded_user_id" => $this->uploaded_user_id,
                "root_domain" => $row["root_domain"],
                "dr" => $row["dr"],
                "rd" => (double)$row["rd"],
                "traffic_source" => $row["traffic"],
                "email" => trim($row['email']),
                "da" => (double)$row["da"],
                "spam_score" => str_replace("%", "", $row['spam_score']),
                "website_niche" => $row['website_niche'],
                "category" => $row['main_category'],
                "website_status" => $row['website_status'],

                "href_url" => $row['href_url'],

                "marked_sponsor" => $row['marked_sponsor'],
                "grey_niche" => $row['grey_niche'],
                "gp_price" => str_replace("$", "", $row['gp_agreed_price']),
                "niche_edit_price" => str_replace("$", "", $row['ne_agreed_price']),
//            "deal_cbd_casino"  => str_replace("$","",$row['casino_cbd_agreed_price']),
                "country_source" => $row['country_source'],
                "sample_url" => $row['sample_post'],
                "paypal_id" => $row['paypal_id'],
                "fc_gp" => (double) $row['fc_gp'],
                "fc_ne" => (double) $row['fc_ne'],
                "skype" => $row['skype'],
                "whatsapp" => $row['whatsapp'],
                "site_status" => $this->site_status,
                "total_time" =>(double) $row['total_time'],
                "source" => $this->site_status,
                "bulk_upload_id" => $this->bulk_upload_id,
                "bulk_upload_status" => $this->bulk_upload_status,
            ];

//            dd($data);
            return new NewSite($data);
        }
    }
}
