<?php

namespace App\Imports;

use App\Models\BulkUploadSite;
use App\Project\Shared\SiteStatusOptions;
use Illuminate\Support\Facades\Auth;
use Maatwebsite\Excel\Concerns\ToModel;
use Maatwebsite\Excel\Concerns\WithHeadingRow;

class BulkUploadExcel implements ToModel, WithHeadingRow
{
    private $id;
    private $vendor_id;

    public function __construct($id,$vendor_id)
    {
        $this->id = $id;
        $this->vendor_id = $vendor_id;
    }
    /**
    * @param array $row
    *
    * @return \Illuminate\Database\Eloquent\Model|null
    */
    public function model(array $row)
    {
        if( !empty($row["root_domain"]) ) {
            return new BulkUploadSite([
                "uploaded_user_id"  =>  $this->vendor_id,
                "bulk_upload_id" => $this->id,
                "root_domain"   =>  $row["root_domain"],
                "dr"   =>  $row["dr"],
                "rd"   => (double) $row["rd"],
                "traffic_source"   =>  $row["traffic"],
                "email"  => $row['email'],
                "da"   =>  (double) $row["da"],
                "spam_score"  => str_replace("%","",$row['spam_score']),
                "website_niche"  => $row['website_niche'],
                "category"  => $row['main_category'],
                "marked_sponsor"  => $row['marked_sponsor'],
                "grey_niche"  => $row['grey_niche'],
                "gp_price"  => str_replace("$","",$row['gp_agreed_price']),
                "niche_edit_price"  => str_replace("$","",$row['ne_agreed_price']),
                "deal_cbd_casino"  => str_replace("$","",$row['casino_cbd_agreed_price']),
                "country_source"  => $row['country_source'],
                "sample_url"  => $row['sample_post'],
                "paypal_id"  => $row['paypal_id'],
                "skype"  => $row['skype'],
                "whatsapp"  => $row['whatsapp'],
                "site_status"   =>  SiteStatusOptions::$APPROVED,
                "source"    =>  "From Admin Excel Import"
            ]);
        }
    }
}
