<?php

namespace App\Http\Controllers\Vendor;

use App\Harman\Helpers\LinkVerify;
use App\Harman\Helpers\NewLinkVerify;
use App\Http\Controllers\Controller;
use App\Models\NewOrderProcessDetail;
use App\Project\NewOrderStatus;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class OrderNotificationController extends Controller
{
    public function pending_order_notification_from_manager()
    {
        $new_process_details= NewOrderProcessDetail::with("new_site")->where('vendor_id',Auth::id())
            ->whereIn('status',[NewOrderStatus::$MANAGER_PUSHED_TO_BLOGGER])->get();
        return view("vendor.order_notifications.pending_orders",compact("new_process_details"));
    }

    public function rejected_order_notification_from_manager()
    {
        $new_process_details= NewOrderProcessDetail::with("new_site")->where('vendor_id',Auth::id())
            ->whereIn('status',[NewOrderStatus::$MANAGER_DISAPPROVED_AND_PUSHED_BACK_TO_BLOGGER])->get();
        return view("vendor.order_notifications.pending_orders",compact("new_process_details"));
    }

    public function post_pending_order($id,Request $request)
    {

        try{
            $detail= NewOrderProcessDetail::where('vendor_id',Auth::id())
                ->whereIn('status',[NewOrderStatus::$MANAGER_PUSHED_TO_BLOGGER,NewOrderStatus::$MANAGER_DISAPPROVED_AND_PUSHED_BACK_TO_BLOGGER])
                ->where('id',$id)->firstOrFail();

            if( $request->has("submit") ) {
                $request->validate( [
                    "submit_url" => "required"
                ]);

//                return $request->submit_url;

//                $a = "";
//                $b = "";
//                $crawler = \Goutte::request('GET', $request->submit_url);
//                $c = $crawler->filter('a')->each(function ($node) use ($detail,$a){
//                        if ( trim(strtolower($node->text())) == strtolower(trim($detail->anchor)) ){
//                           return $node->text();
////                            $b= $node->attr("href");
////                            $arr[$node->text()] = $node->attr("href");
//                        }
////                        return  ( trim(strtolower($node->text())) == strtolower(trim($detail->anchor)) ) && ( rtrim(strtolower($node->attr("href")),'/') == rtrim(strtolower(trim($detail->ourl)),'/')) ;
//                });
//                $c = $crawler->filter('a')->each(function ($node) use ($detail){
////                    if ( trim(strtolower($node->text())) == strtolower(trim($detail->anchor)) ){
//                        dump( $node->text()."=>". $node->attr("href") );
////                    }
//                });


//die;
//                dump($c);
//                foreach ($c as $cc) {
//                    echo $cc;
//                    echo "<br>";
//                }

//                return $arr;
//                dd($content);
//                die;
//                if(count(array_filter($c)) == 0){
//                    echo "Not Verfiy";
//                }else{
//                    echo "Verified";
//                }
//
//                die;
                $v =(new NewLinkVerify(trim($detail->ourl), trim($detail->anchor), trim($request->submit_url)))->verify();
//                if(!$v){
////                    dd($v);
//                    return redirect()->back()->withErrors(['submit_url'=>'Link Verification Failed']);
//                }


                $detail->submit_url= $request->submit_url;
                $detail->verify = $v ? "verified" : "Not Verified";
                $detail->status = NewOrderStatus::$BLOGGER_PUSHED_BACK_TO_MANAGER_WITH_SUCCESS;
                $detail->save();

                return redirect()->route("vendor.my_orders")->with("success","Successfully Pushed to Manager");
            }

            if( $request->reject ){
                $detail->status = NewOrderStatus::$BLOGGER_PUSHED_BACK_TO_MANAGER_WITH_REJECTION;
                $detail->reject_reason = $request->reason_for_rejection;
                $detail->save();

                return redirect()->route("vendor.my_orders")->with("success","Order Rejected");
            }
        }catch (\Exception $exception){
//            dd($exception->getMessage());
            return redirect()->back()->with("error",$exception->getMessage());
        }
    }

    public function completed_orders()
    {
        $new_process_details= NewOrderProcessDetail::where('vendor_id',Auth::id())
            ->whereIn('status',[NewOrderStatus::$MANAGER_VERIFIED_AND_FINISHED,NewOrderStatus::$BLOGGER_PUSHED_BACK_TO_MANAGER_WITH_REJECTION])->get();
//        return $new_process_details;
        return view("vendor.order_notifications.view_completed_orders",compact("new_process_details"));
    }

    public function view_completed_orders($id,Request $request)
    {
        $detail= NewOrderProcessDetail::with("new_order_process.new_order")->where('vendor_id',Auth::id())
            ->where('id',$id)->firstOrFail();
        $action = $request->action;
        return view("vendor.order_notifications.completed_orders",compact("detail","action"));
    }


}
