<?php

namespace App\Http\Controllers\Vendor;

use App\Http\Controllers\Controller;
use App\Models\NewOrderProcessDetail;
use App\Project\NewOrderStatus;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class MyOrderController extends Controller
{
    public function my_orders(Request $request)
    {
        $action = 'pending';

        if( $request->action == 'rejected' ){ $action = 'rejected'; }
        elseif( $request->action == 'completed' ){ $action = 'completed'; }
        elseif( $request->action == 'waiting' ){ $action = 'waiting'; }

        $orders = [];
        if( $action == 'completed' ){
            $orders =  $new_process_details= NewOrderProcessDetail::where('vendor_id',Auth::id())
                ->whereIn('status',[NewOrderStatus::$MANAGER_VERIFIED_AND_FINISHED,NewOrderStatus::$BLOGGER_PUSHED_BACK_TO_MANAGER_WITH_REJECTION])->get();
        }

        if( $action == 'pending' ){
            $orders = $new_process_details= NewOrderProcessDetail::with("new_site")->where('vendor_id',Auth::id())
                ->whereIn('status',[NewOrderStatus::$MANAGER_PUSHED_TO_BLOGGER])->get();
        }

        if( $action == 'rejected' ){
            $orders = NewOrderProcessDetail::with("new_site")->where('vendor_id',Auth::id())
                ->whereIn('status',[NewOrderStatus::$MANAGER_DISAPPROVED_AND_PUSHED_BACK_TO_BLOGGER])->get();
        }

        if( $action == 'waiting' ){
            $orders = NewOrderProcessDetail::with("new_site")->where('vendor_id',Auth::id())
                ->whereIn('status',[NewOrderStatus::$BLOGGER_PUSHED_BACK_TO_MANAGER_WITH_SUCCESS])->get();
        }

        return view("vendor.my_orders.index",compact("orders","action"));

    }
}
