<?php

namespace App\Http\Controllers\Vendor;

use App\Http\Controllers\Controller;
use App\Models\Message;
use App\Models\Thread;
use App\Models\User;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class MessageController extends Controller
{
    public function index()
    {
        return view("vendor.messages.index");
    }

    public function messages($id)
    {
        $thread= Thread::findOrFail($id);
        return view("vendor.messages.detail",compact("id","thread"));
    }

    public function create()
    {
        return view("vendor.messages.create");
    }

    public function store(Request $request)
    {
        $request->validate([
           "message"    =>  "required"
        ]);

         try {
            //Check Thread is Created or not
            $admin= User::where('role','admin')->first();

            $thread= Thread::where('owner_id',auth()->user()->id)->where('user_id',$admin->id)->first();
            if( $thread ){
                //Found
                $message= new Message();
                $message->thread_id= $thread->id;
                $message->user_id= Auth::id();
                $message->message= $request->message;
                $message->save();
            }else{
                //Not Found
                $new_thread= new Thread();
                $new_thread->owner_id= Auth::id();
                $new_thread->user_id= $admin->id;
                $new_thread->subject="aaa";
                $new_thread->save();

                $message= new Message();
                $message->thread_id= $new_thread->id;
                $message->user_id= Auth::id();
                $message->message= $request->message;
                $message->save();
            }

            return redirect()->back();
         }catch (\Exception $exception){
             return redirect()->back()->with("error",$exception->getMessage());
         }

    }
}
