<?php

namespace App\Http\Controllers;

use App\Harman\Helpers\FileProcess;
use App\Mail\AccountCreated;
use App\Models\Career;
use App\Models\CareerApply;
use App\Models\Contact;
use App\Models\User;
use App\Providers\RouteServiceProvider;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Mail;
use Illuminate\Support\Facades\Validator;

class HomeController extends Controller
{
    public function submit_profile($id)
    {
        $career= Career::find($id);
        if( !$career ){
            return redirect()->route("jobs_list");
        }
        return view("frontend.home.submit_profile",compact("career"));
    }

    public function save_profile(Request $request, $id)
    {
        $request->validate([
            "name"  =>  "required",
            "email"  =>  "required|email",
            "mobile"  =>  "required|numeric",
            "location"  =>  "required",
            "cover_letter"  =>  "required",
            "resume"  =>  "required|mimes:txt,docx,pdf",
        ]);

        try {
            $resume= new FileProcess();
            $resume->init("uploads",$request->resume);
            $resume->prefix("resume_");
            $resume->unique("career_applies","upload_resume");
            $filename= $resume->upload();

            $apply= new CareerApply();
            $apply->career_id= $id;
            $apply->name    =   $request->name;
            $apply->email    =   $request->email;
            $apply->phone    =   $request->mobile;
            $apply->location    =   $request->location;
            $apply->cover_letter    =   $request->cover_letter;
            $apply->upload_resume= $filename;
            $apply->save();

            return redirect()->back()->with("success","Thank You");
        }catch (\Exception $exception){
            return redirect()->back()->with("error",$exception->getMessage());
        }


    }

    public function contact()
    {
        return view("frontend.home.contact");
    }

    public function contact_store(Request $request)
    {
        $v= Validator::make($request->all(),[
            "name"     =>      "required",
            "email"     =>      "required",
            "phone"     =>      "required",
            "subject"     =>      "required",
            "message"     =>      "required",
        ]);

        if( $v->fails() ){
            if($request->get('route') == 'homepage'){
                return redirect()->to("/#contact")->withErrors($v->errors())->withInput();
            }else{
                return redirect()->to("/contact#contact")->withErrors($v->errors())->withInput();
            }

        }

        try {
            $c= new Contact();
            $c->name= $request->name;
            $c->email= $request->email;
            $c->phone= $request->phone;
            $c->subject= $request->subject;
            $c->message= $request->message;
            $c->save();

            if($request->get('route') == 'home') {
                return redirect()->to("/#contact")->with("success", "Thank You");
            }else{
                return redirect()->to("/contact#contact")->with("success", "Thank You");
            }
        }catch (\Exception $exception){
            return redirect()->back()->with("error",$exception->getMessage());
        }

    }

    public function register(Request $request)
    {
        $request->validate([
            'name' => ['required', 'string', 'max:255'],
            'email' => ['required', 'string', 'email', 'max:255', 'unique:users'],
            'password' => ['required', 'confirmed',"min:6","regex:/^(?=.*?[a-z])(?=.*?[0-9]).{6,}$/"],
        ],[
            "password.regex"    =>  "Your password must be upto 6 characters long, should contain at least 1 alpha numeric character."
        ]);

        $user = User::create([
            'name' => $request->name,
            'email' => $request->email,
            'skype' => $request->skype,
            'whatsapp' => $request->whatsapp,
            'password' => Hash::make($request->password),
            'role'  =>  'vendor'
        ]);

//        Mail::to($request->email)->send(new AccountCreated($request->name));

//        event(new Registered($user));

        Auth::login($user);

        return redirect("/blogger");
    }
}
