<?php

use App\Models\MasterType;
use App\Models\NewOrder;
use App\Models\NewOrderProcessDetail;
use App\Project\NewOrderStatus;
use Carbon\Carbon;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;

function select_dropdown($errors,$url_slug,$label_text,$name,$multiple=false,$prevalue=false){
    $masters= MasterType::with("masters")->where('url_slug',$url_slug)->first();

    $text = "";
    $text .= '<div><div class="flex items-center">';
    $text .= '<label class="label-h-class w-2/5 text-right pr-8">'.$label_text.'</label>';
    if( $multiple == true ){
        $text .= '<select class="select-h-class focus:ring-blue-500 focus:border-blue-500 block mt-1 w-full rounded-md cursor-pointer focus:outline-none" name="'.$name.'" multiple>';
    }else{
        $text .= '<select class="select-h-class focus:ring-blue-500 focus:border-blue-500" name="'.$name.'">';
    }

    $text .= '<option value="">Select</option>';
    foreach($masters->masters as $master){
        if( is_array( $prevalue) ){
            if(in_array($master->id,$prevalue)){
                $text .= '<option selected value="'.$master->id.'">'.$master->name.'</option>';
            }else{
                $text .= '<option value="'.$master->id.'">'.$master->name.'</option>';
            }
        }else{
            if( $prevalue ){
                if( $prevalue == $master->id ){
                    $text .= '<option selected value="'.$master->id.'">'.$master->name.'</option>';
                }else{
                    $text .= '<option value="'.$master->id.'">'.$master->name.'</option>';
                }
            }else{
                if( old($name) == $master->id ){
                    $text .= '<option selected value="'.$master->id.'">'.$master->name.'</option>';
                }else{
                    $text .= '<option value="'.$master->id.'">'.$master->name.'</option>';
                }
            }

        }


    }
    $text .= "</select>";
    $text .= "</div>";
    if($errors->has($name) ){
        $text .= '<div class="text-right mt-1 text-red-400 text-xs">'.$errors->first($name).'</div>';
    }
    $text .= "</div>";

    return $text;
}

function no_links_select_dropdown($errors,$url_slug,$label_text,$name,$multiple=false,$prevalue=false){
    $masters= MasterType::with("masters")->where('url_slug',$url_slug)->first();

    $text = "";
    $text .= '<div><div class="flex items-center">';
    $text .= '<label class="label-h-class w-2/5 text-right pr-8">'.$label_text.'</label>';
    if( $multiple == true ){
        $text .= '<select class="select-h-class focus:ring-blue-500 focus:border-blue-500 block mt-1 w-full rounded-md cursor-pointer focus:outline-none" name="'.$name.'" multiple>';
    }else{
        $text .= '<select class="select-h-class focus:ring-blue-500 focus:border-blue-500" name="'.$name.'">';
    }

    $text .= '<option value="">Select</option>';
    foreach($masters->masters as $master){
        if( $master->name == 1 ||  $master->name == 2 || $master->name == 3 || $master->name == 5 ){
            if( is_array( $prevalue) ){
                if(in_array($master->id,$prevalue)){
                    $text .= '<option selected value="'.$master->id.'">'.$master->name.'</option>';
                }else{
                    $text .= '<option value="'.$master->id.'">'.$master->name.'</option>';
                }
            }else{
                if( $prevalue ){
                    if( $prevalue == $master->id ){
                        $text .= '<option selected value="'.$master->id.'">'.$master->name.'</option>';
                    }else{
                        $text .= '<option value="'.$master->id.'">'.$master->name.'</option>';
                    }
                }else{
                    if( old($name) == $master->id ){
                        $text .= '<option selected value="'.$master->id.'">'.$master->name.'</option>';
                    }else{
                        $text .= '<option value="'.$master->id.'">'.$master->name.'</option>';
                    }
                }

            }
        }



    }
    $text .= "</select>";
    $text .= "</div>";
    if($errors->has($name) ){
        $text .= '<div class="text-right mt-1 text-red-400 text-xs">'.$errors->first($name).'</div>';
    }
    $text .= "</div>";

    return $text;
}

function payment_method_is_setup_or_not(){
    return auth()->user()->paypal_email == "" && (auth()->user()->ac_holder_name == "" && auth()->user()->bank_name == "" && auth()->user()->account_number == "" && auth()->user()->bank_address == "" && auth()->user()->swift_code == "");
}

function payment_method_is_bank(){
    return auth()->user()->paypal_email == "" && (auth()->user()->ac_holder_name != "" && auth()->user()->bank_name != "" && auth()->user()->account_number != "" && auth()->user()->bank_address != "" && auth()->user()->swift_code != "");
}

function payment_method_is_paypal(){
    return auth()->user()->paypal_email != "" && (auth()->user()->ac_holder_name == "" && auth()->user()->bank_name == "" && auth()->user()->account_number == "" && auth()->user()->bank_address == "" && auth()->user()->swift_code == "");
}

function remove_http($url) {

}


function team_order_added_notification(){
    return NewOrder::whereIn('new_order_status',[NewOrderStatus::$PENDING_ORDER,NewOrderStatus::$MANAGER_CREATED_ORDER_AND_PUSHED_TO_TEAM])->where('team_id',Auth::id())->count();
}

function team_rejected_links(){
    return NewOrder::where('new_order_status',NewOrderStatus::$MANAGER_DISAPPROVED_POST_TEAM)->where('team_id',Auth::id())->count();
}

function team_completed_orders(){
    return NewOrder::whereNotIn('new_order_status',[NewOrderStatus::$PENDING_ORDER,NewOrderStatus::$TEAM_PUSHED_TO_MANAGER,NewOrderStatus::$MANAGER_DISAPPROVED_POST_TEAM,NewOrderStatus::$MANAGER_CREATED_ORDER_AND_PUSHED_TO_TEAM])->where('team_id',Auth::id())->count();
}

function manager_pending_approvals_for_team(){
    return NewOrder::where('new_order_status',NewOrderStatus::$TEAM_PUSHED_TO_MANAGER)->where('manager_id',Auth::id())->count();
}

function manager_pending_approvals_for_writer(){
    return NewOrder::where('new_order_status',NewOrderStatus::$WRITER_PUSHED_TO_MANAGER)->where('manager_id',Auth::id())->count();
}

function writer_order_added_notifications(){
    return  NewOrder::whereHas("order_processes_manager_pushed_to_writer", function ($q){
        $q->where('writer_id',Auth::id());
    })->has("order_processes_manager_pushed_to_writer.new_order_process_details")
        ->where('new_order_status',NewOrderStatus::$MANAGER_PUSHED_TO_WRITER)
        ->with("order_processes_manager_pushed_to_writer","manager")->count();
}

function writer_completed_orders_notifications(){
    return  NewOrder::whereHas("order_processes_manager_pushed_to_writer", function ($q){
        $q->where('writer_id',Auth::id());
    })->has("order_processes_manager_pushed_to_writer.new_order_process_details")
        ->whereNotIn('new_order_status',[
            NewOrderStatus::$PENDING_ORDER,
            NewOrderStatus::$TEAM_PUSHED_TO_MANAGER,
            NewOrderStatus::$MANAGER_DISAPPROVED_POST_TEAM,
            NewOrderStatus::$MANAGER_CREATED_ORDER_AND_PUSHED_TO_TEAM,
            NewOrderStatus::$MANAGER_PUSHED_TO_WRITER,
            NewOrderStatus::$WRITER_PUSHED_TO_MANAGER,
            NewOrderStatus::$MANAGER_REJECTED_AND_PUSHED_BACK_TO_WRITER,
        ])
        ->with("order_processes_manager_pushed_to_writer","manager")->count();
}

function writer_rejected_notifications(){
    return  NewOrder::whereHas("order_processes_manager_pushed_to_writer", function ($q){
        $q->where('writer_id',Auth::id());
    })->has("order_processes_manager_pushed_to_writer.new_order_process_details")
        ->where('new_order_status',NewOrderStatus::$MANAGER_REJECTED_AND_PUSHED_BACK_TO_WRITER)
        ->with("order_processes_manager_pushed_to_writer","manager")->count();
}

function manager_pending_approvals_for_bloggers(){
    return NewOrderProcessDetail::whereHas('new_order_process',function ($q){
        $q->where('manager_id',Auth::id());
    })->whereIn('status',[NewOrderStatus::$BLOGGER_PUSHED_BACK_TO_MANAGER_WITH_SUCCESS])->count();
}

function bloggers_rejected_orders_for_manager(){
    return NewOrderProcessDetail::whereHas('new_order_process',function ($q){
        $q->where('manager_id',Auth::id());
    })->whereIn('status',[NewOrderStatus::$BLOGGER_PUSHED_BACK_TO_MANAGER_WITH_REJECTION])->count();
}


function order_status($status){
    switch ($status){
        case NewOrderStatus::$PENDING_ORDER:
            return 'Pending Order';
        case NewOrderStatus::$TEAM_PUSHED_TO_MANAGER:
            return 'Team pushed to Manager';
        case NewOrderStatus::$MANAGER_PUSHED_TO_WRITER:
            return 'Manager pushed to Writer';
        case NewOrderStatus::$WRITER_PUSHED_TO_MANAGER:
            return 'Writer pushed to manager';
        case NewOrderStatus::$MANAGER_DISAPPROVED_POST_TEAM:
            return 'Manager Disapproved Post';

        default:
            return 'No...';

    }
}

function new_order_status($status){
    switch ($status){
        case NewOrderStatus::$PENDING_ORDER:
            return 'Manager Pushed to Team ';
        case NewOrderStatus::$MANAGER_CREATED_ORDER_AND_PUSHED_TO_TEAM:
            return 'Manager Pushed to Team';
        case NewOrderStatus::$TEAM_PUSHED_TO_MANAGER:
            return 'Team Pushed to Manager';
        case NewOrderStatus::$MANAGER_PUSHED_TO_WRITER:
            return 'Manager Pushed to Writer';
        case NewOrderStatus::$WRITER_PUSHED_TO_MANAGER:
            return 'Writer Pushed to Manager';
        case NewOrderStatus::$MANAGER_DISAPPROVED_POST_TEAM:
            return 'Manager Disapproved Team Post';
        case NewOrderStatus::$MANAGER_PUSHED_TO_BLOGGER:
            return 'Manager Pushed to Blogger';
        case NewOrderStatus::$BLOGGER_PUSHED_BACK_TO_MANAGER_WITH_SUCCESS:
            return 'Blogger Pushed back to Manager Successfully';
        case NewOrderStatus::$BLOGGER_PUSHED_BACK_TO_MANAGER_WITH_REJECTION:
            return 'Blogger Reject and Pushed back to Manager ';
        case NewOrderStatus::$MANAGER_VERIFIED_AND_FINISHED:
            return 'Manager Verified and Finished';
        case NewOrderStatus::$MANAGER_DISAPPROVED_AND_PUSHED_BACK_TO_WRITER:
            return 'Manager Disapproved and Pushed back to Writer';
        case NewOrderStatus::$MANAGER_DISAPPROVED_AND_PUSHED_BACK_TO_BLOGGER:
            return 'Manager Disapproved and Pushed back to Blogger';
        case NewOrderStatus::$MANAGER_REJECTED_AND_PUSHED_BACK_TO_WRITER:
            return 'Manager Rejected and Pushed back to Writer';
    }
}

function new_order_status_team($status){
    switch ($status){
        case NewOrderStatus::$PENDING_ORDER:
            return 'Manager Pushed to Team';
        case NewOrderStatus::$TEAM_PUSHED_TO_MANAGER:
            return 'Team Pushed to Manager';

        case NewOrderStatus::$MANAGER_DISAPPROVED_POST_TEAM:
            return 'Manager Disapproved Team Post';



    }
}


function vendor_balance(){
    $wallet =  DB::table("wallets")
        ->selectRaw("sum( price ) as balance")
        ->join("wallet_histories","wallets.id","wallet_histories.wallet_id")
        ->where('wallets.user_id',Auth::user()->id)
        ->where('wallet_histories.approved_date','=',null)
        ->first();
    return $wallet->balance ?? 0;
}

function admin_vendor_balance($user_id){
    $wallet =  DB::table("wallets")
        ->selectRaw("sum( price ) as balance")
        ->join("wallet_histories","wallets.id","wallet_histories.wallet_id")
        ->where('wallets.user_id',$user_id)
        ->where('wallet_histories.approved_date','=',null)
        ->first();
    return $wallet->balance ?? 0;
}


function remaining_time($date){
    $timeDifference = Carbon::now()->diff($date);
    // Calculate the remaining days, hours, and minutes
    $remainingDays = $timeDifference->days;
    $remainingHours = $timeDifference->h;
    $remainingMinutes = $timeDifference->i;

    // Create an array to store the time components
    $timeComponents = [];

    if ($remainingDays > 0) {
        $timeComponents[] = $remainingDays . ($remainingDays === 1 ? ' Day' : ' Days');
    }
    if ($remainingHours > 0) {
        $timeComponents[] = $remainingHours . ($remainingHours === 1 ? ' Hour' : ' Hours');
    }
    if ($remainingMinutes > 0) {
        $timeComponents[] = $remainingMinutes . ($remainingMinutes === 1 ? ' Minute' : ' Minutes');
    }

    // Combine the time components into the desired format
    $remainingTime = implode(' : ', $timeComponents);

    return $remainingTime;
}
