<?php


namespace App\Harman\Site;


use App\Models\MasterType;
use Illuminate\Support\Facades\DB;

class SiteData
{
    public static function filters()
    {
        return MasterType::with("masters")
            ->where('url_slug','domain-type')
            ->orWhere('url_slug','category-type')
            ->orWhere('url_slug','traffic-source')
            ->orWhere('url_slug','niche-type')
            ->orWhere('url_slug','grey-niche-type')
            ->orWhere('url_slug','sponsor-type')
            ->get();
    }

    public static function records($request)
    {
        $records= DB::table("sites")
            ->select("sites.id as site_id","sites.name as site_name","email","domain_name","user_id","sites.created_at as site_created",
                "sites.da as site_da","sites.dr as site_dr",
                "sites.traffic as site_traffic","sites.gp as site_gp",
                "sites.rd as site_rd","sites.niche as site_niche"
            )
            ->join('site_multiples','sites.id','=','site_multiples.site_id')
            ->addSelect(["associate_type"=> DB::table("masters")->select("name")->whereColumn('masters.id',"sites.associate_type_id")->limit(1) ])
            ->addSelect(["domain_type"=> DB::table("masters")->select("name")->whereColumn('masters.id',"sites.domain_type_id")->limit(1) ])
            ->addSelect(["niche_type"=> DB::table("masters")->select("name")->whereColumn('masters.id',"sites.niche_type_id")->limit(1) ])
            ->addSelect(["sponsor_type"=> DB::table("masters")->select("name")->whereColumn('masters.id',"sites.sponsor_type_id")->limit(1) ])
            ->addSelect(["link_type"=> DB::table("masters")->select("name")->whereColumn('masters.id',"sites.link_type_id")->limit(1) ])
            ->addSelect(["validity_type"=> DB::table("masters")->select("name")->whereColumn('masters.id',"sites.validity_type_id")->limit(1) ])
            ->addSelect(["grey_niche_type"=> DB::table("masters")->select("name")->whereColumn('masters.id',"sites.grey_niche_type_id")->limit(1) ])
            ->addSelect(["no_of_links"=> DB::table("masters")->select("name")->whereColumn('masters.id',"sites.no_of_links_id")->limit(1) ])
            ->when($request->get("account"),function ($query) use ($request){
                if($request->get('account') == 'created'){
                    $query->where('user_id','!=',null);
                }
                if($request->get('account') == 'pending'){
                    $query->where('user_id','=',null);
                }
            })
            ->when($request->get('domain-type'),function ($query) use ($request){
                $query->whereIn('sites.domain_type_id',$request->get("domain-type"));
            })
            ->when($request->get('sponsor-type'),function ($query) use ($request){
                $query->whereIn('sites.sponsor_type_id',$request->get("sponsor-type"));
            })
            ->when($request->get('grey-niche-type'),function ($query) use ($request){
                $query->whereIn('sites.grey_niche_type_id',$request->get("grey-niche-type"));
            })

            ->when($request->get('niche-type'),function ($query) use ($request){
                $query->whereIn('sites.niche_type_id',$request->get("niche-type"));
            })
            ->when($request->get('category-type'),function ($query) use ($request){
                $query->whereIn('site_multiples.name',$request->get("category-type"));
            })
            ->when($request->get('traffic-source'),function ($query) use ($request){
                $query->whereIn('site_multiples.name',$request->get("traffic-source"));
            })
            ->addSelect(["category_type"=>
                DB::table("site_multiples")
                    ->selectRaw("GROUP_CONCAT((select name from masters where masters.id = site_multiples.name limit 1)) as original_name")
                    ->whereColumn('site_multiples.site_id',"sites.id")
                    ->where('master_type_url_slug','category-type')
                    ->groupBy("site_id")->limit(1)])
            ->addSelect(["traffic_source"=>
                DB::table("site_multiples")
                    ->selectRaw("GROUP_CONCAT((select name from masters where masters.id = site_multiples.name limit 1)) as original_name")
                    ->whereColumn('site_multiples.site_id',"sites.id")
                    ->where('master_type_url_slug','traffic-source')
                    ->groupBy("site_id")->limit(1)])
            ->addSelect(["grey_niche"=>
                DB::table("site_multiples")
                    ->selectRaw("GROUP_CONCAT((select name from masters where masters.id = site_multiples.name limit 1)) as original_name")
                    ->whereColumn('site_multiples.site_id',"sites.id")
                    ->where('master_type_url_slug','grey-niche')
                    ->groupBy("site_id")->limit(1)])

            ->groupBy('site_name','email','domain_name','associate_type',"user_id",'domain_type','niche_type','sponsor_type','link_type','validity_type','grey_niche_type',
                'no_of_links','category_type','traffic_source','grey_niche',"site_created","site_da","site_dr","site_traffic","site_gp","site_rd","site_niche","sites.id"
            )
            ->orderBy('site_name','desc')
            ->paginate(request('per_page') ? $request->per_page : 10);
        $records->appends(
            [
                'niche-type'=>$request->get('niche-type'),
                'category-type'=>$request->get('category-type'),
                'domain-type'=>$request->get('domain-type'),
                'traffic-source'=>$request->get('traffic-source'),
                'sponsor-type'=>$request->get('sponsor-type'),
                'grey-niche-type'=>$request->get('grey-niche-type'),
                'account'=>$request->get('account'),
                'per_page'  =>  $request->per_page
            ]);
        return $records;
    }

}
