<?php


namespace App\Harman\Site;


use App\Harman\Common\SiteStatus;
use App\Models\Site;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class CreateSiteStep4
{
    public function create(Request $request)
    {
        $da= $request->da;
        $dr= $request->dr;
        $rd= $request->rd;
        $traffic= $request->traffic;
        $gp= $request->gp;
        $niche= $request->niche_price;


//            return $request->all();
        $traffic_query= DB::table("price_charts")
            ->whereRaw("traffic_start_range <= ".$traffic." and traffic_end_range > ".$traffic." " )
            ->first();
        if( $gp > $traffic_query->gp_end_range ){
            return redirect()->back()->withInput()->withErrors(['gp'=>'Please lower your price. It does not meet our pricing criteria']);
        }

        $rd_query= DB::table("price_charts")
            ->whereRaw("rd_start_range <= ".$rd." and rd_end_range > ".$rd." " )
            ->first();
//        return $rd_query;

        if( $niche > $rd_query->niche_end_range ){
            return redirect()->back()->withInput()->withErrors(['niche_price'=>'Please lower your price. It does not meet our pricing criteria']);
        }

         try {
             $site= Site::where('unique_code',$request->id)->firstOrFail();
            $site->da= $da;
            $site->dr= $dr;
            $site->traffic= $traffic;
            $site->gp= $gp;
            $site->rd= $rd;
            $site->niche= $niche;
            $site->step4= 1;
             $site->steps_complete = 4;
             $site->status= SiteStatus::$PENDING;
            $site->save();

            session()->remove("code");
             return redirect()->route("site_create")->with("success","Thank you! your profile is submitted");
         }catch (\Exception $exception){
             return redirect()->back()->with("error",$exception->getMessage());
         }

    }
}
