<?php


namespace App\Harman\Site;


use App\Models\Site;
use App\Models\SiteMultiple;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class CreateSiteStep2
{
    public function create(Request $request)
    {
        try {
            DB::beginTransaction();
            $site= Site::with("site_multiple_category_type","site_multiple_traffic_source")->where('unique_code',$request->id)->firstOrFail();
            $site->domain_name= $request->domain_name;
            $site->associate_type_id= $request->associate_type;
            $site->domain_type_id= $request->domain_type;
            $site->niche_type_id= $request->niche_type;
            $site->steps_complete = 2;
            $site->step2= 1;
            $site->save();

            foreach ($site->site_multiple_category_type as $item){
                $item->delete();
            }

            foreach ($site->site_multiple_traffic_source as $item){
                $item->delete();
            }

            foreach ($request->category_type as $category){
                $multiple= new SiteMultiple();
                $multiple->site_id= $site->id;
                $multiple->name= $category;
                $multiple->master_type_url_slug = 'category-type';
                $multiple->save();
            }

            foreach ($request->traffic_source as $traffic){
                $multiple= new SiteMultiple();
                $multiple->site_id= $site->id;
                $multiple->name= $traffic;
                $multiple->master_type_url_slug = 'traffic-source';
                $multiple->save();
            }

            DB::commit();
            return redirect()->route("site_create",["type"=>"step3"]);
        }catch (\Exception $exception){
            DB::rollBack();
            return redirect()->back()->with("error",$exception->getMessage());
        }
    }
}
