<?php

namespace App\Harman\Helpers;

use App\components\MyCrawler;
use App\components\MyStore;
use Crwlr\Crawler\Steps\Dom;
use Crwlr\Crawler\Steps\Html;
use Crwlr\Crawler\Steps\Loading\Http;

class CrawlerLinkVerify
{
    private $target_url = "";
    private $anchor_keywords = "";
    private $page_url = "";

    public function __construct($target_url, $anchor_keywords, $page_url)
    {
        $this->target_url = $target_url;
        $this->anchor_keywords = $anchor_keywords;
        $this->page_url = $page_url;
    }

    public function verify()
    {
        try{
            $crawler= new MyCrawler();
            $crawler->input($this->page_url)
                ->addStep(Http::get())
                ->addStep(Html::root()->extract([
                    "title" => Dom::cssSelector('a')->attribute("href")->toAbsoluteUrl(),
                    "texts" => Dom::cssSelector("a")->text()
                ])->keep(['title','texts']));

            $crawler->setStore(new MyStore($this->target_url,$this->anchor_keywords));

            $crawler->runAndTraverse();
        }catch (\Exception $exception){
            return false;
        }
    }
}
