<?php


namespace App\Harman\Helpers;


use Illuminate\Support\Facades\DB;
use Illuminate\Support\Str;

class CleanUrl
{
    private $table;
    private $text;

    public function __construct($table, $text)
    {
        $this->table = $table;
        $this->text = $text;
    }

    public function clean()
    {
        $title = Str::slug($this->text);
        $count= DB::table($this->table)->whereRaw("url_slug RLIKE '^{$title}(-[0-9]*)?$' ")->latest('id')->pluck("url_slug");
        if( $count->count() != 0){
            $pieces= explode("-",$count);
            $number= end($pieces);
            return $title.'-'.((int)$number + 1);
        }else{
            return $title;
        }
    }
}
