<?php

namespace App\Filament\Writer\Widgets;

use App\Filament\Writer\Resources\CompletedOrdersResource;
use App\Filament\Writer\Resources\OrderAddedNotificationResource;
use App\Filament\Writer\Resources\RejectedNotificationResource;
use App\Filament\Writer\Resources\TicketResource;
use App\Models\Thread;
use Filament\Widgets\StatsOverviewWidget as BaseWidget;
use Filament\Widgets\StatsOverviewWidget\Stat;
use Illuminate\Support\Facades\Auth;

class WriterStatsWidget extends BaseWidget
{
    protected static ?string $pollingInterval = null;

    protected static bool $isDiscovered = false;

    protected function getStats(): array
    {
        return [
            Stat::make("Completed Orders",writer_completed_orders_notifications())->url(CompletedOrdersResource::getUrl()),
            Stat::make("Order Added Notifications",writer_order_added_notifications())->url(OrderAddedNotificationResource::getUrl()),
            Stat::make("Rejected Notifications",writer_rejected_notifications())->url(RejectedNotificationResource::getUrl()),
            Stat::make("Threads",Thread::where('owner_id', Auth::id())->orWhere('user_id',Auth::id())->count())->url(TicketResource::getUrl()),
        ];
    }
}
