<?php

namespace App\Filament\Writer\Resources\RejectedNotificationResource\Pages;

use App\Filament\Writer\Resources\OrderAddedNotificationResource;
use App\Filament\Writer\Resources\RejectedNotificationResource;
use App\Models\NewOrder;
use App\Models\NewOrderProcess;
use App\Models\NewOrderProcessDetail;
use App\Models\User;
use App\Models\WriterAutoSave;
use App\Project\NewOrderStatus;
use Filament\Forms\Components\FileUpload;
use Filament\Forms\Components\Hidden;
use Filament\Forms\Components\Repeater;
use Filament\Forms\Components\RichEditor;
use Filament\Forms\Components\Section;
use Filament\Forms\Components\Select;
use Filament\Forms\Components\TextInput;
use Filament\Forms\Concerns\InteractsWithForms;
use Filament\Forms\Contracts\HasForms;
use Filament\Forms\Form;
use Filament\Forms\Get;
use Filament\Notifications\Notification;
use Filament\Resources\Pages\Page;
use Illuminate\Contracts\View\View;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Log;

class RejectedNotificationDetailPage extends Page implements HasForms
{
    use InteractsWithForms;

    public ?array $data = [];

    public $id;


    public $order;


    protected static string $resource = RejectedNotificationResource::class;

    protected static string $view = 'filament.writer.resources.rejected-notification-resource.pages.rejected-notification-detail-page';

    public function mount(int | string $record): void
    {


        $this->id = $record;
        $this->order = NewOrder::whereHas("order_processes_manager_rejected_and_pushed_to_writer", function ($q){
            $q->where('writer_id',Auth::id());
        })->has("order_processes_manager_rejected_and_pushed_to_writer.new_order_process_details")
            ->where('new_order_status',NewOrderStatus::$MANAGER_REJECTED_AND_PUSHED_BACK_TO_WRITER)
            ->with("order_processes_manager_rejected_and_pushed_to_writer.new_order_process_details","manager")->where('id',$record)->first();

            $data  = [];

            foreach($this->order->order_processes_manager_pushed_to_writer->new_order_process_details as $details){

                $data[] = [
                    "id"    =>  $details->id,
                    "root_domain" => $details->new_site->root_domain,
                    "anchor" => $details->anchor,
                    "title" => $details->title,
                    "url" => $details->ourl,
                    "post_url"  =>  $details->url,
                    "options"   =>  "insert"
                ];

            }

            $this->form->fill(["details"    =>  $data]);





    }



    public function form(Form $form): Form
    {
        return $form
            ->schema([
                Section::make("Detail Page")->schema([
                    Repeater::make("details")
                        ->orderable(false)
                        ->addable(false)
                        ->deletable(false)
                        ->schema([
                            Hidden::make("id"),
                            TextInput::make("root_domain")->disabled()->inlineLabel()->required(),
                            TextInput::make("anchor")->disabled()->inlineLabel()->required(),
                            TextInput::make("title")->disabled()->inlineLabel()->required()->hidden(function (){
                                if($this->order->order_type == "gp"){
                                    return false;
                                }
                                return true;
                            }),
                            TextInput::make("post_url")->label("POST URL")->disabled()->inlineLabel()->required()->hidden(function (){
                                if($this->order->order_type == "niche"){
                                    return false;
                                }
                                return true;
                            }),
                            TextInput::make("url")->label("URL")->disabled()->inlineLabel()->required(),

                            Select::make("options")->native(false)->default('replace')->options([
                                "insert"    =>  "Insert",
                                "replace"   =>  "Replace"
                            ])->live()->columns(1)->required()->inlineLabel()->hidden(function (){
                                if($this->order->order_type == "niche"){
                                    return false;
                                }
                                return true;
                            }),

                            FileUpload::make("upload_doc_file")->label("Upload Document")
                                ->directory("uploads")
                                ->requiredWithout('doc_urls')
                                ->inlineLabel()->hidden(function (){
                                    if($this->order->order_type == "gp"){
                                        return false;
                                    }
                                    return true;
                                }),
                            TextInput::make("doc_urls")->label("Doc Urls")->requiredWithout('upload_doc_file')->inlineLabel()->hidden(function (){
                                if($this->order->order_type == "gp"){
                                    return false;
                                }
                                return true;
                            }),


                            RichEditor::make("insert_after")->live(onBlur: true)->required()->label(function (Get $get){
                                if($get('options') == 'insert'){
                                    return "Insert After";
                                }
                                if($get('options') == 'replace'){
                                    return "Replace with";
                                }
                            })->hidden(function (){
                                if($this->order->order_type == "niche"){
                                    return false;
                                }
                                return true;
                            }),
                            RichEditor::make("statement")->live(onBlur: true)->required()->label(function (Get $get){
                                if($get('options') == 'insert'){
                                    return "Insert Statement";
                                }
                                if($get('options') == 'replace'){
                                    return "Replace Statement";
                                }
                            })->hidden(function (){
                                if($this->order->order_type == "niche"){
                                    return false;
                                }
                                return true;
                            }),

                            TextInput::make("note")->required()->label("Note")->inlineLabel(),

                        ])
                ])
            ])->statePath('data');
    }

    public function render(): View
    {
        $order = NewOrder::whereHas("order_processes_manager_rejected_and_pushed_to_writer", function ($q){
            $q->where('writer_id',Auth::id());
        })->has("order_processes_manager_rejected_and_pushed_to_writer.new_order_process_details")
            ->where('new_order_status',NewOrderStatus::$MANAGER_REJECTED_AND_PUSHED_BACK_TO_WRITER)
            ->with("order_processes_manager_rejected_and_pushed_to_writer.new_order_process_details","manager")->where('id',$this->id)->first();
        return parent::render()->with("order",$order);
    }


    public function create(): void
    {
        $type = $this->order->order_type;
        $data = $this->form->getState();

        try{
            DB::beginTransaction();
            $new_order_process= new NewOrderProcess();
            $new_order_process->new_order_id= $this->order->id;
            $new_order_process->manager_id= $this->order->manager_id;
            $new_order_process->writer_id= Auth::id();
            $new_order_process->status= NewOrderStatus::$WRITER_PUSHED_TO_MANAGER;
            $new_order_process->save();

            $this->order->new_order_status = NewOrderStatus::$WRITER_PUSHED_TO_MANAGER;
            $this->order->save();

            foreach ($data['details'] as $site){
                $newOrderProcessDetail= NewOrderProcessDetail::where('id',$site['id'])->firstOrFail();

                $detail= new NewOrderProcessDetail();
                $detail->new_order_process_id = $new_order_process->id;
                $detail->new_site_id= $newOrderProcessDetail->new_site_id;
                $detail->price= $newOrderProcessDetail->price;
                $detail->url= $newOrderProcessDetail->url;
                $detail->anchor= $newOrderProcessDetail->anchor;
                $detail->title= $newOrderProcessDetail->title;
                $detail->ourl= $newOrderProcessDetail->ourl;
                $detail->note = $site['note'];

                if($type == 'gp') {
                    $detail->doc_urls = $site['doc_urls'];
                    $detail->upload_doc_file = $site['upload_doc_file'];
                }
                if($type == 'niche') {
                    $detail->insert_after = $site['insert_after'];
                    $detail->type = $site['options'];
                    $detail->statement = $site['statement'];
                }


                $detail->save();

            }

            DB::commit();


            Notification::make("success")->title("Order Pushed to Manager")->send();

            $admin = admin_record();
            $manager = User::where('role','manager')->where('id',$this->order->manager_id)->first();

            Notification::make()->title("Order No. ".$this->order->order_id." Pushed to Manager")
                ->body("Pushed by ".Auth::user()->name.'('.Auth::user()->email.')')
                ->success()
                ->sendToDatabase([$admin,$manager]);


            $this->redirect(OrderAddedNotificationResource::getUrl("index"));

            return ;
        }catch (\Exception $exception){
            DB::rollBack();

            dd($exception->getLine());

        }


    }



}
