<?php

namespace App\Filament\Writer\Resources\OrderAddedNotificationResource\Pages;

use App\Filament\Writer\Resources\OrderAddedNotificationResource;
use App\Models\NewOrder;
use App\Models\NewOrderProcess;
use App\Models\NewOrderProcessDetail;
use App\Models\User;
use App\Models\WriterAutoSave;
use App\Project\NewOrderStatus;
use Filament\Forms\Components\FileUpload;
use Filament\Forms\Components\Hidden;
use Filament\Forms\Components\Repeater;
use Filament\Forms\Components\RichEditor;
use Filament\Forms\Components\Section;
use Filament\Forms\Components\Select;
use Filament\Forms\Components\Textarea;
use Filament\Forms\Components\TextInput;
use Filament\Forms\Components\Toggle;
use Filament\Forms\Concerns\InteractsWithForms;
use Filament\Forms\Contracts\HasForms;
use Filament\Forms\Form;
use Filament\Forms\Get;
use Filament\Notifications\Notification;
use Filament\Resources\Pages\Page;
use Illuminate\Contracts\View\View;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Log;

class OrderAddedNotificationDetailPage extends Page implements HasForms
{
    use InteractsWithForms;

    public ?array $data = [];

    public $writer_auto_save;

    public $id;

    public $order;

    protected static string $resource = OrderAddedNotificationResource::class;

    protected static string $view = 'filament.writer.resources.order-added-notification-resource.pages.order-added-notification-detail-page';

    public function mount(int|string $record): void
    {
        $this->id = $record;
        $this->order = NewOrder::whereHas("order_processes_manager_pushed_to_writer", function ($q){
            $q->where('writer_id',Auth::id());
        })->has("order_processes_manager_pushed_to_writer.new_order_process_details")
            ->where('new_order_status',NewOrderStatus::$MANAGER_PUSHED_TO_WRITER)
            ->with("order_processes_manager_pushed_to_writer","manager")->where('id',$record)->firstOrFail();

        $data  = [];

        $this->writer_auto_save= WriterAutoSave::where('order_id',$this->order->id)->first();

        if( !$this->writer_auto_save ){
            $this->writer_auto_save = new WriterAutoSave();
            $this->writer_auto_save->order_id = $this->order->id;
            $this->writer_auto_save->save();
        }






        foreach($this->order->order_processes_manager_pushed_to_writer->new_order_process_details as $details){

            $data[] = [
                "id"    =>  $details->id,
                "root_domain" => $details->new_site->root_domain,
                "anchor" => $details->anchor,
                "title" => $details->title,
                "url" => $details->ourl,
                "post_url"  =>  $details->url,
                "payment_method"  =>  $details->payment_method,
                "upfront_payment"  =>  $details->upfront_payment,
                "upfront_payment_remarks"  =>  $details->upfront_payment_remarks,
                "options"   =>  "insert",
                "bank_type" => $details->bank_type,
                "beneficiary_name" => $details->beneficiary_name,
                "beneficiary_account_number" => $details->beneficiary_account_number,
                "customer_reference_number" => $details->customer_reference_number,
                "ifsc_code" => $details->ifsc_code,
                "bene_bank_name" => $details->bene_bank_name,
                "bene_bank_branch_name" => $details->bene_bank_branch_name,
                "beneficiary_email_id" => $details->beneficiary_email_id,
                "paypal_id" => $details->paypal_email,
                "qr_code_image" => $details->qr_code_image,
                "upi_id" => $details->upi_id,
            ];


        }


//        Log::info(print_r($data));

        $auto_save = [];
        if( !$this->writer_auto_save->jsondata ){

            foreach($this->order->order_processes_manager_pushed_to_writer->new_order_process_details as $details){
                $auto_save[] = [
                    "id"    =>  $details->id,

                    "insert_after"  =>  "",
                    "statement" =>  "",
                    "doc_urls"  =>  "",
                    "note"  =>  ""
                ];
            }

            $this->writer_auto_save->jsondata = json_encode($auto_save);
            $this->writer_auto_save->save();

        }else{
            $auto_save = json_decode($this->writer_auto_save->jsondata);

            foreach ($auto_save as $item) {
                $extraById[$item->id] = (array) $item;
            }

            $data = array_map(function ($item) use ($extraById) {
                $extra = $extraById[$item['id']] ?? [];
                return array_merge($item, $extra);
            }, $data);

        }


//        dd($order->order_processes_manager_pushed_to_writer->new_order_process_details->toArray());
        $this->form->fill(["details"    =>  $data]);
    }




    public function form(Form $form): Form
    {
        return $form

            ->schema([
                Section::make("Detail Page")->schema([
                    Repeater::make("details")
                        ->orderable(false)
                        ->addable(false)
                        ->deletable(false)
                        ->schema([
                            Hidden::make("id"),
                            TextInput::make("root_domain")->disabled()->inlineLabel()->required(),
                            TextInput::make("anchor")->disabled()->inlineLabel()->required(),
                            TextInput::make("title")->disabled()->inlineLabel()->required()->hidden(function (){
                                if($this->order->order_type == "gp"){
                                    return false;
                                }
                                return true;
                            }),
                            TextInput::make("post_url")->label("POST URL")->disabled()->inlineLabel()->required()->hidden(function (){
                                if($this->order->order_type == "niche"){
                                    return false;
                                }
                                return true;
                            }),
                            TextInput::make("url")->label("URL")->disabled()->inlineLabel()->required(),


                            Select::make("options")->native(false)->default('replace')->options([
                                "insert"    =>  "Insert",
                                "replace"   =>  "Replace"
                            ])->live()
                                ->afterStateUpdated(function ($state, $get, $set) {
                                    $writer_auto_save = WriterAutoSave::where('order_id',$this->order->id)->first();
                                    $data = json_decode($writer_auto_save->jsondata,true);
                                    foreach ( $data as &$item){
                                        if($item['id'] == $get('id')){
                                            $item['options'] = $state;
                                        }
                                    }

                                    $writer_auto_save->jsondata = json_encode($data);
                                    $writer_auto_save->save();
                                })
                                ->columns(1)->required()->inlineLabel()->hidden(function (){
                                if($this->order->order_type == "niche"){
                                    return false;
                                }
                                return true;
                            }),

                            FileUpload::make("upload_doc_file")->label("Upload Document")
                                ->directory("uploads")
                                ->requiredWithout('doc_urls')
                                ->inlineLabel()->hidden(function (){
                                if($this->order->order_type == "gp"){
                                    return false;
                                }
                                return true;
                            }),
                            TextInput::make("doc_urls")->label("Doc Urls")
                                ->requiredWithout('upload_doc_file')
                                ->live(debounce: 500)
                                ->afterStateUpdated(function ($state, $get, $set) {
                                    $writer_auto_save = WriterAutoSave::where('order_id',$this->order->id)->first();
                                    $data = json_decode($writer_auto_save->jsondata,true);
                                    foreach ( $data as &$item){
                                        if($item['id'] == $get('id')){
                                            $item['doc_urls'] = $state;
                                        }
                                    }

                                    $writer_auto_save->jsondata = json_encode($data);
                                    $writer_auto_save->save();
                                })
                                ->inlineLabel()->hidden(function (){
                                if($this->order->order_type == "gp"){
                                    return false;
                                }
                                return true;
                            }),


                            RichEditor::make("insert_after")->required()
                                ->live(debounce: 500)
                                ->afterStateUpdated(function ($state, $get, $set) {
                                    $writer_auto_save = WriterAutoSave::where('order_id',$this->order->id)->first();
                                    $data = json_decode($writer_auto_save->jsondata,true);
                                    foreach ( $data as &$item){
                                        if($item['id'] == $get('id')){
                                            $item['insert_after'] = $state;
                                        }
                                    }

                                    $writer_auto_save->jsondata = json_encode($data);
                                    $writer_auto_save->save();
                                })
                                ->label(function (Get $get){
                                if($get('options') == 'insert'){
                                    return "Insert After";
                                }
                                if($get('options') == 'replace'){
                                    return "Replace with";
                                }
                            })->hidden(function (){
                                if($this->order->order_type == "niche"){
                                    return false;
                                }
                                return true;
                            }),
                            RichEditor::make("statement")->required()
                                ->live(debounce: 500)
                                ->afterStateUpdated(function ($state, $get, $set) {
                                    $writer_auto_save = WriterAutoSave::where('order_id',$this->order->id)->first();
                                    $data = json_decode($writer_auto_save->jsondata,true);
                                    foreach ( $data as &$item){
                                        if($item['id'] == $get('id')){
                                            $item['statement'] = $state;
                                        }
                                    }

                                    $writer_auto_save->jsondata = json_encode($data);
                                    $writer_auto_save->save();
                                })
                                ->label(function (Get $get){
                                if($get('options') == 'insert'){
                                    return "Insert Statement";
                                }
                                if($get('options') == 'replace'){
                                    return "Replace Statement";
                                }
                            })->hidden(function (){
                                if($this->order->order_type == "niche"){
                                    return false;
                                }
                                return true;
                            }),

                            TextInput::make("note")->required()
                                ->live(debounce: 500)
                                ->afterStateUpdated(function ($state, $get, $set) {
                                    $writer_auto_save = WriterAutoSave::where('order_id',$this->order->id)->first();
                                    $data = json_decode($writer_auto_save->jsondata,true);
                                    foreach ( $data as &$item){
                                        if($item['id'] == $get('id')){
                                            $item['note'] = $state;
                                        }
                                    }

                                    $writer_auto_save->jsondata = json_encode($data);
                                    $writer_auto_save->save();
                                })
                                ->label("Note")->inlineLabel(),

                        ])
                ])
            ])->statePath('data');
    }

    public function render(): View
    {
        $order = NewOrder::whereHas("order_processes_manager_pushed_to_writer", function ($q){
            $q->where('writer_id',Auth::id());
        })->has("order_processes_manager_pushed_to_writer.new_order_process_details")
            ->where('new_order_status',NewOrderStatus::$MANAGER_PUSHED_TO_WRITER)
            ->with("order_processes_manager_pushed_to_writer","manager")->where('id',$this->id)->firstOrFail();
        return parent::render()->with("order",$order);
    }


    public function create(): void
    {
        $type = $this->order->order_type;
        $data = $this->form->getState();

        try{
            DB::beginTransaction();
            $new_order_process= new NewOrderProcess();
            $new_order_process->new_order_id= $this->order->id;
            $new_order_process->manager_id= $this->order->manager_id;
            $new_order_process->writer_id= Auth::id();
            $new_order_process->status= NewOrderStatus::$WRITER_PUSHED_TO_MANAGER;
            $new_order_process->save();

            $this->order->new_order_status = NewOrderStatus::$WRITER_PUSHED_TO_MANAGER;
            $this->order->save();

            foreach ($data['details'] as $site){
                $newOrderProcessDetail= NewOrderProcessDetail::where('id',$site['id'])->firstOrFail();

                $detail= new NewOrderProcessDetail();
                $detail->new_order_process_id = $new_order_process->id;
                $detail->new_site_id= $newOrderProcessDetail->new_site_id;
                $detail->price= $newOrderProcessDetail->price;
                $detail->url= $newOrderProcessDetail->url;
                $detail->anchor= $newOrderProcessDetail->anchor;
                $detail->title= $newOrderProcessDetail->title;
                $detail->ourl= $newOrderProcessDetail->ourl;
                $detail->upfront_payment= $newOrderProcessDetail->upfront_payment;
                $detail->upfront_payment_remarks= $newOrderProcessDetail->upfront_payment_remarks;

                $detail->bank_type =  $newOrderProcessDetail->bank_type;
                $detail->beneficiary_name =  $newOrderProcessDetail->beneficiary_name;
                $detail->beneficiary_account_number =  $newOrderProcessDetail->beneficiary_account_number;
                $detail->customer_reference_number =  $newOrderProcessDetail->customer_reference_number;
                $detail->ifsc_code =  $newOrderProcessDetail->ifsc_code;
                $detail->bene_bank_name =  $newOrderProcessDetail->bene_bank_name;
                $detail->bene_bank_branch_name =  $newOrderProcessDetail->bene_bank_branch_name;
                $detail->beneficiary_email_id =  $newOrderProcessDetail->beneficiary_email_id;
                $detail->upi_id =  $newOrderProcessDetail->upi_id;
                $detail->qr_code_image = $newOrderProcessDetail->qr_code_image;
                $detail->paypal_email =  $newOrderProcessDetail->paypal_email;
                $detail->payment_method =  $newOrderProcessDetail->payment_method;


                $detail->note = $site['note'];

                if($type == 'gp') {
                    $detail->doc_urls = $site['doc_urls'];
                    $detail->upload_doc_file = $site['upload_doc_file'];
                }
                if($type == 'niche') {
                    $detail->insert_after = $site['insert_after'];
                    $detail->type = $site['options'];
                    $detail->statement = $site['statement'];
                }


                $detail->save();

            }




            Notification::make("success")->title("Order Pushed to Manager")->send();
            $admin = admin_record();
            $manager = User::where('role','manager')->where('id',$this->order->manager_id)->first();

            Notification::make()->title("Order No. ".$this->order->order_id." Pushed to Manager")
                ->body("Pushed by ".Auth::user()->name.'('.Auth::user()->email.')')
                ->success()
                ->sendToDatabase([$admin,$manager]);

            DB::commit();
            $this->redirect(OrderAddedNotificationResource::getUrl("index"));

             return ;
        }catch (\Exception $exception){
            DB::rollBack();

            dd($exception->getLine());

        }


    }

}


//Iiwamritsarmidtownnewgen@gmail.com
