<?php

namespace App\Filament\Writer\Pages;

use Filament\Forms\Components\FileUpload;
use Filament\Forms\Components\Section;
use Filament\Forms\Components\Select;
use Filament\Forms\Components\TextInput;
use Filament\Forms\Concerns\InteractsWithForms;
use Filament\Forms\Contracts\HasForms;
use Filament\Forms\Form;
use Filament\Notifications\Notification;
use Filament\Pages\Page;
use Illuminate\Support\Facades\Auth;

class Profile extends Page implements HasForms
{
    use InteractsWithForms;

    protected static bool $shouldRegisterNavigation = false;

    public ?array $data = [];

    public function mount(): void
    {
        $this->form->fill();
    }

    protected static ?string $navigationIcon = 'heroicon-o-document-text';

    protected static string $view = 'filament.writer.pages.profile';

    public function form(Form $form): Form
    {
        return $form
            ->schema([
                Section::make("Update Profile")->description("Update your profile information")->schema([
                    TextInput::make('email')
                        ->default(function (){
                            return Auth::user()->email;
                        })->disabled()
                        ->inlineLabel()->required(),
                    TextInput::make('name')
                        ->default(function (){
                            return Auth::user()->name;
                        })
                        ->inlineLabel()->required(),
                    Select::make("gender")->inlineLabel()
                        ->default(Auth::user()->gender)
                        ->options([
                            "male"    =>  "Male",
                            "female"    =>  "Female",
                            "other"   =>  "Other",
                        ])->required(),
                    TextInput::make('mobile_number')->default(Auth::user()->mobile_number)->inlineLabel()->required(),
                    FileUpload::make("profile_image")
                        ->default(Auth::user()->profile_image)
                        ->label("Profile Image")
                        ->directory("uploads")
                        ->image(),

                ])->columnSpan(1),
            ])->columns(2)
            ->statePath('data');
    }

    public function create(): void
    {
        $data = $this->form->getState();


        try{
            Auth::user()->update([
                "name"  => $data['name'],
                "gender"    => $data['gender'],
                "mobile_number"  => $data['mobile_number'],
                "profile_image" => $data['profile_image']
            ]);

            Notification::make("success")->title("Profile Updated")->success()->send();
        }catch (\Exception $exception){
            dd($exception->getMessage());
        }

    }
}
