<?php

namespace App\Filament\Widgets;

use App\Filament\Resources\PendingBulkUploadRequestsResource;
use App\Models\BulkUpload;
use Filament\Forms\Components\TextInput;
use Filament\Tables;
use Filament\Tables\Columns\TextColumn;
use Filament\Tables\Filters\Filter;
use Filament\Tables\Table;
use Filament\Widgets\TableWidget as BaseWidget;
use Illuminate\Database\Eloquent\Builder;

class PendingBulkUploadRequestsWidget extends BaseWidget
{
    protected static bool $isDiscovered = false;

    protected int | string | array $columnSpan = 2;
    public function table(Table $table): Table
    {
        return $table
            ->query(
                BulkUpload::with("user")->whereIn('status',[0,1])
            )
            ->recordUrl(null)
            ->paginated(config("app.pagination"))
            ->columns([
                TextColumn::make('vendor.name')->label("Name")->sortable()->wrap(),
                TextColumn::make('user.email')->label("Email")->sortable()->wrap(),

                TextColumn::make("created_at")->sortable()->label("Datetime")->dateTime(),
                TextColumn::make("status")->badge()->formatStateUsing(function (BulkUpload $record) {
                    if($record->status == 0){
                        return 'No Excel File Upload';
                    }else if($record->status == 1){
                        return 'Excel File Uploaded. Waiting Blogger to accept/decline';
                    }
                })->color(function (BulkUpload $record) {
                    if($record->status == 0){
                        return "danger";
                    }else if($record->status == 1){
                        return "warning";
                    }
                }),
                TextColumn::make("id")->label("Excel File")->icon("heroicon-o-arrow-down-tray")->formatStateUsing(function (BulkUpload $record){
                    return 'Download';
                })->tooltip("Download Excel File")->url(function (BulkUpload $record) {
                    return url('/uploads/'.$record->filename);
                })
            ])
            ->filtersLayout(Tables\Enums\FiltersLayout::AboveContentCollapsible)
            ->filters([
                Filter::make("vendor")->form([
                    TextInput::make("name"),
                    TextInput::make("email"),

                ])->columns(6)->columnSpanFull()
                    ->query(function (Builder $query, array $data): Builder {
                        return $query
                            ->when($data['name'], function (Builder $query) use ($data) {
                                return $query->whereHas("user", function (Builder $query) use ($data) {
                                    $query->where('name', 'LIKE','%'.$data['name'].'%');
                                });
                            })
                            ->when($data['email'], function (Builder $query) use ($data) {
                                return $query->whereHas("user", function (Builder $query) use ($data) {
                                    $query->where('email', 'LIKE','%'.$data['email'].'%');
                                });
                            });
                    }),
            ])
            ->actions([
                Tables\Actions\Action::make("upload_excel_file")->label(function (BulkUpload $record){
                    if( $record->status == 0 ){
                        return 'Upload Excel File';
                    }
                    elseif ($record->status == 1){
                        return 'View Uploaded Sites';
                    }
                })->url(function (BulkUpload $record) {
                    if($record->status == 0){
                        return PendingBulkUploadRequestsResource::getUrl('upload-excel-file', ['record' => $record->id]);
                    }

                    if ($record->status == 1) {
                        return PendingBulkUploadRequestsResource::getUrl('bulk-uploaded-sites', ['record' => $record->id]);
                    }
                })
            ])
            ->bulkActions([

            ])
            ;
    }
}
