<?php

namespace App\Filament\Widgets;

use App\Models\NewOrder;
use App\Models\WithdrawRequest;
use Filament\Widgets\ChartWidget;
use Illuminate\Support\Facades\DB;

class MonthlyOrdersChart extends ChartWidget
{
    protected static ?string $heading = 'Monthly Orders Chart';
    public ?string $filter = '2024';
    protected static bool $isDiscovered = false;
    protected static ?string $pollingInterval = null;

    public function total_amount($month,$year)
    {
        return NewOrder::selectRaw('COUNT(id)')->whereRaw('MONTH(created_at) = '.$month.' AND YEAR(created_at) = '.$year)->count();
    }

    protected function getFilters(): ?array
    {
        return [
            2023 => 2023,
            2024 => 2024,
            2025 => 2025,
            2026 => 2026,
            2027 => 2027,
        ];
    }

    protected function getData(): array
    {

        $year =  $this->filter;;
        $months = [];
        foreach (range(1,12) as $item){
            $months[] = $this->total_amount($item,$year);
        }

        return [
            'datasets' => [
                [
                    'label' => 'Payment',
                    'data' => $months,
                    'borderColor'    => '#a21caf',
                    'backgroundColor'=> '#a21caf',
                ]
            ],
            'labels' => ['Jan', 'Feb', 'Mar', 'Apr', 'May', 'Jun', 'Jul', 'Aug', 'Sep', 'Oct', 'Nov', 'Dec'],
        ];
    }

    protected function getType(): string
    {
        return 'bar';
    }
}
