<?php

namespace App\Filament\Widgets;

use App\Models\NewOrder;
use App\Models\User;
use Filament\Widgets\ChartWidget;

class BloggersJoinedChart extends ChartWidget
{
    protected static ?string $heading = 'Bloggers Joined';

    public ?string $filter = '2024';
    protected static bool $isDiscovered  = false;

    protected static ?string $pollingInterval = null;

    public function total_amount($month,$year)
    {
        return User::selectRaw('COUNT(id)')->whereRaw('MONTH(created_at) = '.$month.' AND YEAR(created_at) = '.$year)->where('role','vendor')->count();
    }

    protected function getFilters(): ?array
    {
        return [
            2023 => 2023,
            2024 => 2024,
            2025 => 2025,
            2026 => 2026,
            2027 => 2027,
        ];
    }

    protected function getData(): array
    {

        $year =  $this->filter;
        $months = [];
        foreach (range(1,12) as $item){
            $months[] = $this->total_amount($item,$year);
        }

        return [
            'datasets' => [
                [
                    'label' => 'Bloggers',
                    'data' => $months,
                    'borderColor'    => '#facc15',
                    'backgroundColor'=> '#facc15',
                ]
            ],
            'labels' => ['Jan', 'Feb', 'Mar', 'Apr', 'May', 'Jun', 'Jul', 'Aug', 'Sep', 'Oct', 'Nov', 'Dec'],
        ];
    }

    protected function getType(): string
    {
        return 'bar';
    }
}
